import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import ValueState from "@ui5/webcomponents-base/dist/types/ValueState.js";
import ListItem from "@ui5/webcomponents/dist/ListItem.js";
import UploadState from "./types/UploadState.js";
import "@ui5/webcomponents-icons/dist/refresh.js";
import "@ui5/webcomponents-icons/dist/stop.js";
import "@ui5/webcomponents-icons/dist/edit.js";
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 * A component to be used within the <code>ui5-upload-collection</code>.
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents-fiori/dist/UploadCollectionItem.js";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.fiori.UploadCollectionItem
 * @extends sap.ui.webc.main.ListItem
 * @tagname ui5-upload-collection-item
 * @public
 * @implements sap.ui.webc.fiori.IUploadCollectionItem
 * @since 1.0.0-rc.7
 */
declare class UploadCollectionItem extends ListItem {
    /**
     * Holds an instance of <code>File</code> associated with this item.
     *
     * @type {File}
     * @name sap.ui.webc.fiori.UploadCollectionItem.prototype.file
     * @defaultvalue null
     * @public
     */
    file?: object;
    /**
     * The name of the file.
     *
     * @type {string}
     * @name sap.ui.webc.fiori.UploadCollectionItem.prototype.fileName
     * @defaultvalue ""
     * @public
     */
    fileName: string;
    /**
     * If set to <code>true</code> the file name will be clickable and it will fire <code>file-name-click</code> event upon click.
     *
     * @type {boolean}
     * @name sap.ui.webc.fiori.UploadCollectionItem.prototype.fileNameClickable
     * @defaultvalue false
     * @public
     */
    fileNameClickable: boolean;
    /**
     * Disables the delete button.
     *
     * @type {boolean}
     * @name sap.ui.webc.fiori.UploadCollectionItem.prototype.disableDeleteButton
     * @defaultvalue false
     * @public
     */
    disableDeleteButton: boolean;
    /**
     * By default, the delete button will always be shown, regardless of the <code>ui5-upload-collection</code>'s property <code>mode</code>.
     * Setting this property to <code>true</code> will hide the delete button.
     *
     * @type {boolean}
     * @name sap.ui.webc.fiori.UploadCollectionItem.prototype.hideDeleteButton
     * @defaultvalue false
     * @public
     */
    hideDeleteButton: boolean;
    /**
     * Hides the retry button when <code>uploadState</code> property is <code>Error</code>.
     *
     * @type {boolean}
     * @name sap.ui.webc.fiori.UploadCollectionItem.prototype.hideRetryButton
     * @defaultvalue false
     * @public
     */
    hideRetryButton: boolean;
    /**
     * Hides the terminate button when <code>uploadState</code> property is <code>Uploading</code>.
     *
     * @type {boolean}
     * @name sap.ui.webc.fiori.UploadCollectionItem.prototype.hideTerminateButton
     * @defaultvalue false
     * @public
     */
    hideTerminateButton: boolean;
    /**
     * The upload progress in percentage.
     * <br><br>
     * <b>Note:</b> Expected values are in the interval [0, 100].
     *
     * @type {sap.ui.webc.base.types.Integer}
     * @name sap.ui.webc.fiori.UploadCollectionItem.prototype.progress
     * @defaultvalue 0
     * @public
     */
    progress: number;
    /**
     * If set to <code>Uploading</code> or <code>Error</code>, a progress indicator showing the <code>progress</code> is displayed.
     * Also if set to <code>Error</code>, a refresh button is shown. When this icon is pressed <code>retry</code> event is fired.
     * If set to <code>Uploading</code>, a terminate button is shown. When this icon is pressed <code>terminate</code> event is fired.
     *
     * @type {sap.ui.webc.fiori.types.UploadState}
     * @name sap.ui.webc.fiori.UploadCollectionItem.prototype.uploadState
     * @defaultvalue "Ready"
     * @public
     */
    uploadState: `${UploadState}`;
    /**
     * Indicates if editing.
     *
     * @type {boolean}
     * @defaultvalue false
     * @private
     */
    _editing: boolean;
    /**
     * A thumbnail, which will be shown in the beginning of the <code>ui5-upload-collection-item</code>.
     * <br><br>
     * <b>Note:</b> Use <code>ui5-icon</code> or <code>img</code> for the intended design.
     *
     * @type {HTMLElement}
     * @slot
     * @name sap.ui.webc.fiori.UploadCollectionItem.prototype.thumbnail
     * @public
     */
    thumbnail: Array<HTMLElement>;
    /**
     * Hold the description of the <code>ui5-upload-collection-item</code>. Will be shown below the file name.
     *
     * @type {Node[]}
     * @slot
     * @name sap.ui.webc.fiori.UploadCollectionItem.prototype.default
     * @public
     */
    static i18nFioriBundle: I18nBundle;
    static onDefine(): Promise<void>;
    /**
     * @override
     */
    onDetailClick(): Promise<void>;
    _initInputField(): Promise<void>;
    _onDetailKeyup(e: KeyboardEvent): void;
    _onInputFocusin(e: FocusEvent): void;
    _onInputKeyDown(e: KeyboardEvent): void;
    _onRename(): void;
    _onRenameKeyup(e: KeyboardEvent): void;
    _onRenameCancel(e: KeyboardEvent): Promise<void>;
    _onRenameCancelKeyup(e: KeyboardEvent): void;
    _focus(): void;
    _onFileNameClick(): void;
    _onRetry(): void;
    _onRetryKeyup(e: KeyboardEvent): void;
    _onTerminate(): void;
    _onTerminateKeyup(e: KeyboardEvent): void;
    _onDelete(): void;
    getFocusDomRef(): HTMLElement | undefined;
    /**
     * @override
     */
    get classes(): {
        main: {
            "ui5-uci-root": boolean;
            "ui5-uci-root-editing": boolean;
            "ui5-uci-root-uploading": boolean;
        } | {
            "ui5-uci-root": boolean;
            "ui5-uci-root-editing": boolean;
            "ui5-uci-root-uploading": boolean;
        };
    };
    /**
     * @override
     */
    get renderUploadCollectionDeleteButton(): boolean;
    get _fileNameWithoutExtension(): string;
    get _fileExtension(): string;
    get _renameBtnText(): string;
    get _cancelRenameBtnText(): string;
    get _showProgressIndicator(): boolean;
    get _progressText(): string;
    get _showRetry(): boolean;
    get _showTerminate(): boolean;
    get _retryButtonTooltip(): string;
    get _terminateButtonTooltip(): string;
    get _editButtonTooltip(): string;
    get valueStateName(): ValueState;
    /**
     * override
     */
    get typeDetail(): boolean;
    get showEditButton(): boolean;
}
export default UploadCollectionItem;
