import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import ItemNavigation from "@ui5/webcomponents-base/dist/delegate/ItemNavigation.js";
import type { ResizeObserverCallback } from "@ui5/webcomponents-base/dist/delegate/ResizeHandler.js";
import ResponsivePopover from "@ui5/webcomponents/dist/ResponsivePopover.js";
import WizardContentLayout from "./types/WizardContentLayout.js";
import WizardTab from "./WizardTab.js";
import WizardStep from "./WizardStep.js";
type WizardStepChangeEventDetail = {
    step: WizardStep;
    previousStep: WizardStep;
    changeWithClick: boolean;
};
type AccessibilityInformation = {
    ariaSetsize: number;
    ariaPosinset: number;
    ariaLabel: string;
};
type StepInfo = {
    icon: string;
    titleText: string;
    subtitleText: string;
    number: number;
    selected: boolean;
    disabled: boolean;
    hideSeparator: boolean;
    activeSeparator: boolean;
    branchingSeparator: boolean;
    pos: number;
    accInfo: AccessibilityInformation;
    refStepId: string;
    tabIndex: string;
    styles: object;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-wizard</code> helps users to complete a complex task by dividing it into sections and guiding them through it.
 * It has two main areas - a navigation area at the top showing the step sequence and a content area below it.
 *
 * <h3>Structure</h3>
 * <h4>Navigation area</h4>
 * The top most area of the <code>ui5-wizard</code> is occupied by the navigation area.
 * It shows the sequence of steps, where the recommended number of steps is between 3 and 8 steps.
 * <ul>
 * <li> Steps can have different visual representations - numbers or icons.</li>
 * <li> Steps might have labels for better readability - titleText and subTitleText.</li>
 * <li> Steps are defined by using the <code>ui5-wizard-step</code> as slotted element within the <code>ui5-wizard</code>.</li>
 * </ul>
 *
 * <b>Note:</b> If no selected step is defined, the first step will be auto selected.
 * <br>
 * <b>Note:</b> If multiple selected steps are defined, the last step will be selected.
 *
 * <h3>CSS Shadow Parts</h3>
 *
 * <ui5-link target="_blank" href="https://developer.mozilla.org/en-US/docs/Web/CSS/::part">CSS Shadow Parts</ui5-link> allow developers to style elements inside the Shadow DOM.
 * <br>
 * The <code>ui5-wizard</code> exposes the following CSS Shadow Parts:
 * <ul>
 * <li>navigator - Used to style the progress navigator of the <code>ui5-wizard</code>.</li>
 * <li>step-content - Used to style a <code>ui5-wizard-step</code> container.</li>
 * </ul>
 *
 * <h3>Keyboard Handling</h3>
 * The user can navigate using the following keyboard shortcuts:
 * <br>
 *
 * <h4>Wizard Progress Navigation</h4>
 * <ul>
 * 	<li>[LEFT], [DOWN] - Focus moves backward to the WizardProgressNavAnchors.</li>
 * 	<li>[UP], [RIGHT] - Focus moves forward to the WizardProgressNavAnchor.</li>
 * 	<li>[SPACE] or [ENTER], [RETURN] - Selects an active step</li>
 * 	<li>[HOME] or [PAGE UP] - Focus goes to the first step</li>
 * 	<li>[END] or [PAGE DOWN] - Focus goes to the last step</li>
 * </ul>
 *
 * <h4>Fast Navigation</h4>
 * This component provides a build in fast navigation group which can be used via <code>F6 / Shift + F6</code> or <code> Ctrl + Alt(Option) + Down /  Ctrl + Alt(Option) + Up</code>.
 * In order to use this functionality, you need to import the following module:
 * <code>import "@ui5/webcomponents-base/dist/features/F6Navigation.js"</code>
 *
 * <h4>Content</h4>
 * The content occupies the main part of the page. It can hold any type of HTML elements.
 * It's defined by using the <code>ui5-wizard-step</code> as slotted element within the <code>ui5-wizard</code>.
 *
 * <h3>Scrolling</h3>
 * The component handles user scrolling by selecting the closest step, based on the current scroll position
 * and scrolls to particular place, when the user clicks on the step within the navigation area.
 * <br><br>
 *
 * <b>Important:</b> In order the component's scrolling behaviour to work, it has to be limited from the outside parent element in terms of height.
 * The component or its parent has to be given percentage or absolute height. Otherwise, the component will be scrolled out with the entire page.
 * <br><br>
 * <b>For example:</b>
 * <br><br>
 * <code>&lt;ui5-dialog style="height: 80%"&gt;<br></code>
 * <code>&#9;&lt;ui5-wizard&gt;&lt;/ui5-wizard&gt;<br></code>
 * <code>&lt;/ui5-dialog&gt;</code>
 *
 * <h4>Moving to next step</h4>
 * The <code>ui5-wizard-step</code> provides the necessary API and it's up to the user of the component to use it to move to the next step.
 * You have to set its <code>selected</code> property (and remove the <code>disabled</code> one if set) to <code>true</code>.
 * The <code>ui5-wizard</code> will automatically scroll to the content of the newly selected step.
 * <br><br>
 *
 * The Fiori 3 guidelines recommends having a "nextStep" button in the content area.
 * You can place a button, or any other type of element to trigger step change, inside the <code>ui5-wizard-step</code>,
 * and show/hide it when certain fields are filled or user defined criteria is met.
 *
 * <h3>Usage</h3>
 * <h4>When to use:</h4>
 * When the user has to accomplish a long or unfamiliar task.
 *
 * <h4>When not to use:</h4>
 * When the task has less than 3 steps.
 *
 * <h3>Responsive Behavior</h3>
 * On small widths the step's titleText, subtitleText and separators in the navigation area shrink and from particular point the steps are grouped together and overlap.
 * Tapping on them will show a popover to select the step to navigate to. On mobile device, the grouped steps are presented within a dialog.
 *
 * <h3>ES6 Module Import</h3>
 * <code>import "@ui5/webcomponents-fiori/dist/Wizard.js";</code> (includes &lt;ui5-wizard-step/&gt;)
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.fiori.Wizard
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-wizard
 * @since 1.0.0-rc.10
 * @appenddocs sap.ui.webc.fiori.WizardStep
 * @public
 */
declare class Wizard extends UI5Element {
    /**
     * Defines how the content of the <code>ui5-wizard</code> would be visualized.
     * @public
     * @type {sap.ui.webc.fiori.types.WizardContentLayout}
     * @since 1.14.0
     * @name sap.ui.webc.fiori.Wizard.prototype.contentLayout
     * @defaultvalue "MultipleSteps"
     */
    contentLayout?: WizardContentLayout;
    /**
     * Defines the width of the <code>ui5-wizard</code>.
     * @private
     */
    width?: number;
    /**
     * Defines the threshold to switch between steps upon user scrolling.
     * <br><br>
     *
     * <b>For Example:</b>
     * <br>
     * (1) To switch to the next step, when half of the step is scrolled out - set <code>step-switch-threshold="0.5"</code>.
     * (2) To switch to the next step, when the entire current step is scrolled out - set <code>step-switch-threshold="1"</code>.
     *
     * <br><br>
     * <b>Note:</b> Supported values are between 0.5 and 1
     * and values out of the range will be normalized to 0.5 and 1 respectively.
     * @private
     * @type {sap.ui.webc.base.types.Float}
     * @defaultvalue 0.7
     * @since 1.0.0-rc.13
     */
    stepSwitchThreshold: number;
    /**
     * Defines the height of the <code>ui5-wizard</code> content.
     * @private
     */
    contentHeight?: number;
    _groupedTabs: Array<WizardTab>;
    _breakpoint: string;
    /**
     * Defines the steps.
     * <br><br>
     * <b>Note:</b> Use the available <code>ui5-wizard-step</code> component.
     *
     * @type {sap.ui.webc.fiori.IWizardStep[]}
     * @name sap.ui.webc.fiori.Wizard.prototype.default
     * @public
     * @slot steps
     */
    steps: Array<WizardStep>;
    static i18nBundle: I18nBundle;
    stepScrollOffsets: Array<number>;
    selectedStepIndex: number;
    previouslySelectedStepIndex: number;
    selectionRequestedByClick: boolean;
    selectionRequestedByScroll: boolean;
    _prevWidth: number;
    _prevContentHeight: number;
    _itemNavigation: ItemNavigation;
    _onStepResize: ResizeObserverCallback;
    constructor();
    get classes(): {
        popover: {
            "ui5-wizard-responsive-popover": boolean;
            "ui5-wizard-popover": boolean;
            "ui5-wizard-dialog": boolean;
        };
    };
    static onDefine(): Promise<void>;
    static get SCROLL_DEBOUNCE_RATE(): number;
    onExitDOM(): void;
    onBeforeRendering(): void;
    onAfterRendering(): void;
    /**
     * Normalizes the step selection as follows:
     * (1) If there is no selected step - the first step is going to be selected.
     * (2) If the selected steps are more than one - the last step is going to be selected.
     * (3) If the selected step is also disabled - log a warning.
     * @private
     */
    syncSelection(): void;
    /**
     * Selects the first step.
     * @private
     */
    selectFirstStep(): void;
    /**
     * Selects the last step from multiple selected ones.
     * @private
     */
    selectLastSelectedStep(): void;
    /**
     * Deselects all steps.
     * @private
     */
    deselectAll(): void;
    /**
     * Stores the scroll offsets of the steps,
     * e.g. the steps' starting point.
     *
     * <b>Note:</b> the disabled ones has negative offsets.
     * @private
     */
    storeStepScrollOffsets(): void;
    /**
     * Handles user click on steps' tabs within the header.
     * <b>Note:</b> the handler is bound in the template.
     * @param {MouseEvent} e
     * @private
     */
    onSelectionChangeRequested(e: MouseEvent): void;
    /**
     * Handles user scrolling with debouncing.
     * <b>Note:</b> the handler is bound in the template.
     * @param {MouseEvent} e
     * @private
     */
    onScroll(e: MouseEvent): void;
    /**
     * Handles when a step in the header is focused in order to update the <code>ItemNavigation</code>.
     * <b>Note:</b> the handler is bound in the template.
     * @param {FocusEvent} e
     * @private
     */
    onStepInHeaderFocused(e: FocusEvent): void;
    /**
     * Handles resize in order to:
     * (1) sync steps' scroll offset and selection
     * (2) adapt navition step header
     * @private
     */
    onStepResize(): void;
    attachStepsResizeObserver(): void;
    detachStepsResizeObserver(): void;
    _calcCurrentBreakpoint(): void;
    /**
     * Updates the expanded attribute for each ui5-wizard-tab based on the ui5-wizard width
     * @private
     */
    _adjustHeaderOverflow(): void;
    _isGroupAtStart(selectedStep: WizardTab): boolean;
    _isGroupAtEnd(selectedStep: WizardTab): boolean;
    _showPopover(oDomTarget: WizardTab, isAtStart: boolean): Promise<void>;
    _onGroupedTabClick(e: MouseEvent): Promise<void>;
    _onOverflowStepButtonClick(e: MouseEvent): void;
    _closeRespPopover(): Promise<void>;
    _respPopover(): Promise<ResponsivePopover>;
    /**
     * Called upon <code>onScroll</code>.
     * Selects the closest step, based on the user scroll position.
     * @param {Integer} scrollPos the current scroll position
     * @private
     */
    changeSelectionByScroll(scrollPos: number): void;
    /**
     * Called upon <code>onSelectionChangeRequested</code>.
     * Selects the external step (ui5-wizard-step),
     * based on the clicked or activated via keyboard step in the header (ui5-wizard-tab).
     * @param {WizardTab} stepInHeader the step equivalent in the header
     * @private
     */
    changeSelectionByStepAction(stepInHeader: WizardTab): Promise<void>;
    getContentHeight(): number;
    getStepAriaLabelText(step: WizardStep, ariaLabel: string): string;
    get stepsDOM(): HTMLElement[];
    get progressNavigatorListDOM(): Element;
    get _stepsInHeader(): StepInfo[];
    get _steps(): WizardStep[];
    get stepsCount(): number;
    get selectedStep(): WizardStep | null;
    get lastSelectedStep(): WizardStep | null;
    get selectedSteps(): WizardStep[];
    get enabledSteps(): WizardStep[];
    get selectedStepsCount(): number;
    get slottedSteps(): WizardStep[];
    get contentDOM(): Element;
    get stepsInHeaderDOM(): WizardTab[];
    get enabledStepsInHeaderDOM(): WizardTab[];
    get navAriaRoleDescription(): string;
    get navAriaLabelText(): string;
    get navAriaDescribedbyText(): string;
    get listAriaLabelText(): string;
    get actionSheetStepsText(): string;
    get navStepDefaultHeading(): string;
    get optionalStepText(): string;
    get activeStepText(): string;
    get inactiveStepText(): string;
    get ariaLabelText(): string;
    get effectiveStepSwitchThreshold(): number;
    /**
     * Returns an array of data objects, based on the user defined steps
     * to later build the steps (tabs) within the header.
     * @returns {Array<StepInfo>}
     * @private
     */
    getStepsInfo(): StepInfo[];
    /**
     * Returns the index of the selected step.
     * @returns {Integer}
     * @private
     */
    getSelectedStepIndex(): number;
    /**
     * Returns the index of the last enabled step.
     * @returns {Integer}
     * @private
     */
    getLastEnabledStepIndex(): number;
    getStepByRefId(refId: string): WizardStep;
    getStepWrapperByRefId(refId: string): HTMLElement;
    getStepWrapperByIdx(idx: number): HTMLElement;
    /**
     * Scrolls to the content of the selected step, used in <code>onAfterRendering</cod>.
     * @private
     */
    scrollToSelectedStep(): void;
    /**
     * Scrolls to the content item within the <code>ui5-wizard</code> shadowDOM
     * by given step index.
     *
     * @private
     * @param {Integer} stepIndex the index of a step
     */
    scrollToContentItem(stepIndex: number): void;
    /**
     * Returns to closest scroll position for the given step index.
     *
     * @private
     * @param {Integer} stepIndex the index of a step
     */
    getClosestScrollPosByStepIndex(stepIndex: number): number;
    /**
     * Returns the closest step index by given scroll position.
     * @private
     * @param {Integer} scrollPos the scroll position
     */
    getClosestStepIndexByScrollPos(scrollPos: number): number;
    /**
     * Switches the selection from the old step to the newly selected step.
     *
     * @param {WizardStep} selectedStep the old step
     * @param {WizardStep} stepToSelect the step to be selected
     * @param {Integer} stepToSelectIndex the index of the newly selected step
     * @param {boolean} changeWithClick the selection changed due to user click in the step navigation
     * @private
     */
    switchSelectionFromOldToNewStep(selectedStep: WizardStep | null, stepToSelect: WizardStep, stepToSelectIndex: number, changeWithClick: boolean): void;
    /**
     * Sorter method for sorting an array in ascending order.
     * @private
     */
    sortAscending(a: number, b: number): 1 | 0 | -1;
}
export type { WizardStepChangeEventDetail, };
export default Wizard;
