import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type { ITabbable } from "@ui5/webcomponents-base/dist/delegate/ItemNavigation.js";
type WizardTabInfo = {
    [key: string]: string;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 * Private component, used internally by the <code>ui5-wizard</code>
 * to represent a "step" in the navigation header of the <code>ui5-wizard</code>.
 *
 * <h3>Usage</h3>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/WizardTab.js";</code> (imported with <ui5-wizard>)
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.fiori.WizardTab
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-wizard-tab
 * @private
 */
declare class WizardTab extends UI5Element implements ITabbable {
    /**
     * Defines the <code>icon</code> of the step.
     * @type {string}
     * @defaultvalue ""
     * @private
     */
    icon: string;
    /**
     * Defines the <code>titleText</code> of the step.
     * @type {string}
     * @defaultvalue ""
     * @private
     * @since 1.0.0-rc.15
     */
    titleText: string;
    /**
     * Defines the <code>subtitleText</code> of the step.
     * @type {string}
     * @defaultvalue ""
     * @private
     * @since 1.0.0-rc.15
     */
    subtitleText: string;
    /**
     * Defines the number that will be displayed in place of the <code>icon</code>, when it's missing.
     * @type {string}
     * @defaultvalue ""
     * @private
     */
    number: string;
    /**
     * Defines if the step is <code>disabled</code> - the step is not responding to user interaction.
     * @type {boolean}
     * @defaultvalue false
     * @private
     */
    disabled: boolean;
    /**
     * Defines if the step is <selected>selected</code>.
     * <br><br>
     *
     * @type {boolean}
     * @defaultvalue false
     * @private
     */
    selected: boolean;
    /**
     * Defines if the step's separator is hidden or not.
     * @type {boolean}
     * @defaultvalue false
     * @private
     */
    hideSeparator: boolean;
    /**
     * Defines if the step's separator is active or not.
     * @type {boolean}
     * @defaultvalue false
     * @private
     */
    activeSeparator: boolean;
    /**
     * Defines if the step's separator is dashed or not.
     * @type {boolean}
     * @defaultvalue false
     * @private
     */
    branchingSeparator: boolean;
    /**
     * Defines the tabindex of the step.
     * @type {string}
     * @defaultvalue "-1"
     * @private
     */
    _tabIndex: string;
    _wizardTabAccInfo?: WizardTabInfo;
    _onclick(): void;
    _onkeyup(e: KeyboardEvent): void;
    _onfocusin(): void;
    get tabIndex(): number;
    get hasTexts(): string;
    get accInfo(): {
        ariaSetsize: string | undefined;
        ariaPosinset: string | undefined;
        ariaLabel: string | undefined;
        ariaCurrent: string | undefined;
        ariaDisabled: string | undefined;
    };
}
export default WizardTab;
