import { registerIllustrationLoader } from "@ui5/webcomponents-base/dist/asset-registries/Illustrations.js";

export const loadIllustration = async (illustrationName) => {
  const collectionAndPrefix = "V4/";
  const cleanIllustrationName = illustrationName.startsWith(collectionAndPrefix) ? illustrationName.replace(collectionAndPrefix, "") : illustrationName;
  switch (cleanIllustrationName) {
		case "AddColumn": return (await import("../../illustrations/AddColumn.js")).default;
		case "AddDimensions": return (await import("../../illustrations/AddDimensions.js")).default;
		case "AddPeople": return (await import("../../illustrations/AddPeople.js")).default;
		case "BalloonSky": return (await import("../../illustrations/BalloonSky.js")).default;
		case "BeforeSearch": return (await import("../../illustrations/BeforeSearch.js")).default;
		case "Connection": return (await import("../../illustrations/Connection.js")).default;
		case "EmptyCalendar": return (await import("../../illustrations/EmptyCalendar.js")).default;
		case "EmptyList": return (await import("../../illustrations/EmptyList.js")).default;
		case "EmptyPlanningCalendar": return (await import("../../illustrations/EmptyPlanningCalendar.js")).default;
		case "ErrorScreen": return (await import("../../illustrations/ErrorScreen.js")).default;
		case "FilterTable": return (await import("../../illustrations/FilterTable.js")).default;
		case "GroupTable": return (await import("../../illustrations/GroupTable.js")).default;
		case "NoActivities": return (await import("../../illustrations/NoActivities.js")).default;
		case "NoColumnsSet": return (await import("../../illustrations/NoColumnsSet.js")).default;
		case "NoData": return (await import("../../illustrations/NoData.js")).default;
		case "NoDimensionsSet": return (await import("../../illustrations/NoDimensionsSet.js")).default;
		case "NoEntries": return (await import("../../illustrations/NoEntries.js")).default;
		case "NoFilterResults": return (await import("../../illustrations/NoFilterResults.js")).default;
		case "NoMail": return (await import("../../illustrations/NoMail.js")).default;
		case "NoMail_v1": return (await import("../../illustrations/NoMail_v1.js")).default;
		case "NoNotifications": return (await import("../../illustrations/NoNotifications.js")).default;
		case "NoSavedItems": return (await import("../../illustrations/NoSavedItems.js")).default;
		case "NoSavedItems_v1": return (await import("../../illustrations/NoSavedItems_v1.js")).default;
		case "NoSearchResults": return (await import("../../illustrations/NoSearchResults.js")).default;
		case "NoTasks": return (await import("../../illustrations/NoTasks.js")).default;
		case "NoTasks_v1": return (await import("../../illustrations/NoTasks_v1.js")).default;
		case "PageNotFound": return (await import("../../illustrations/PageNotFound.js")).default;
		case "ReloadScreen": return (await import("../../illustrations/ReloadScreen.js")).default;
		case "ResizeColumn": return (await import("../../illustrations/ResizeColumn.js")).default;
		case "SearchEarth": return (await import("../../illustrations/SearchEarth.js")).default;
		case "SearchFolder": return (await import("../../illustrations/SearchFolder.js")).default;
		case "SimpleBalloon": return (await import("../../illustrations/SimpleBalloon.js")).default;
		case "SimpleBell": return (await import("../../illustrations/SimpleBell.js")).default;
		case "SimpleCalendar": return (await import("../../illustrations/SimpleCalendar.js")).default;
		case "SimpleCheckMark": return (await import("../../illustrations/SimpleCheckMark.js")).default;
		case "SimpleConnection": return (await import("../../illustrations/SimpleConnection.js")).default;
		case "SimpleEmptyDoc": return (await import("../../illustrations/SimpleEmptyDoc.js")).default;
		case "SimpleEmptyList": return (await import("../../illustrations/SimpleEmptyList.js")).default;
		case "SimpleError": return (await import("../../illustrations/SimpleError.js")).default;
		case "SimpleMagnifier": return (await import("../../illustrations/SimpleMagnifier.js")).default;
		case "SimpleMail": return (await import("../../illustrations/SimpleMail.js")).default;
		case "SimpleNoSavedItems": return (await import("../../illustrations/SimpleNoSavedItems.js")).default;
		case "SimpleNotFoundMagnifier": return (await import("../../illustrations/SimpleNotFoundMagnifier.js")).default;
		case "SimpleReload": return (await import("../../illustrations/SimpleReload.js")).default;
		case "SimpleTask": return (await import("../../illustrations/SimpleTask.js")).default;
		case "SleepingBell": return (await import("../../illustrations/SleepingBell.js")).default;
		case "SortColumn": return (await import("../../illustrations/SortColumn.js")).default;
		case "SuccessBalloon": return (await import("../../illustrations/SuccessBalloon.js")).default;
		case "SuccessCheckMark": return (await import("../../illustrations/SuccessCheckMark.js")).default;
		case "SuccessHighFive": return (await import("../../illustrations/SuccessHighFive.js")).default;
		case "SuccessScreen": return (await import("../../illustrations/SuccessScreen.js")).default;
		case "Survey": return (await import("../../illustrations/Survey.js")).default;
		case "Tent": return (await import("../../illustrations/Tent.js")).default;
		case "UnableToLoad": return (await import("../../illustrations/UnableToLoad.js")).default;
		case "UnableToLoadImage": return (await import("../../illustrations/UnableToLoadImage.js")).default;
		case "UnableToUpload": return (await import("../../illustrations/UnableToUpload.js")).default;
		case "UploadCollection": return (await import("../../illustrations/UploadCollection.js")).default;
		case "UploadToCloud": return (await import("../../illustrations/UploadToCloud.js")).default;
    default:
      throw new Error("[Illustrations] Illustration not found: " + illustrationName);
  }
};

const loadAndCheck = async (illustrationName) => {
  const data = await loadIllustration(illustrationName);
  return data;
};

["AddColumn","AddDimensions","AddPeople","BalloonSky","BeforeSearch","Connection","EmptyCalendar","EmptyList","EmptyPlanningCalendar","ErrorScreen","FilterTable","GroupTable","NoActivities","NoColumnsSet","NoData","NoDimensionsSet","NoEntries","NoFilterResults","NoMail","NoMail_v1","NoNotifications","NoSavedItems","NoSavedItems_v1","NoSearchResults","NoTasks","NoTasks_v1","PageNotFound","ReloadScreen","ResizeColumn","SearchEarth","SearchFolder","SimpleBalloon","SimpleBell","SimpleCalendar","SimpleCheckMark","SimpleConnection","SimpleEmptyDoc","SimpleEmptyList","SimpleError","SimpleMagnifier","SimpleMail","SimpleNoSavedItems","SimpleNotFoundMagnifier","SimpleReload","SimpleTask","SleepingBell","SortColumn","SuccessBalloon","SuccessCheckMark","SuccessHighFive","SuccessScreen","Survey","Tent","UnableToLoad","UnableToLoadImage","UnableToUpload","UploadCollection","UploadToCloud"].forEach((illustrationName) =>
  registerIllustrationLoader(`V4/${illustrationName}`, loadAndCheck)
);
