import { registerIllustrationLoader } from "@ui5/webcomponents-base/dist/asset-registries/Illustrations.js";

export const loadIllustration = async (illustrationName) => {
  const collectionAndPrefix = "V4/Tnt";
  const cleanIllustrationName = illustrationName.startsWith(collectionAndPrefix) ? illustrationName.replace(collectionAndPrefix, "") : illustrationName;
  switch (cleanIllustrationName) {
		case "ChartArea": return (await import("../../illustrations/tnt/ChartArea.js")).default;
		case "ChartArea2": return (await import("../../illustrations/tnt/ChartArea2.js")).default;
		case "ChartBPMNFlow": return (await import("../../illustrations/tnt/ChartBPMNFlow.js")).default;
		case "ChartBar": return (await import("../../illustrations/tnt/ChartBar.js")).default;
		case "ChartBullet": return (await import("../../illustrations/tnt/ChartBullet.js")).default;
		case "ChartDoughnut": return (await import("../../illustrations/tnt/ChartDoughnut.js")).default;
		case "ChartFlow": return (await import("../../illustrations/tnt/ChartFlow.js")).default;
		case "ChartGantt": return (await import("../../illustrations/tnt/ChartGantt.js")).default;
		case "ChartOrg": return (await import("../../illustrations/tnt/ChartOrg.js")).default;
		case "ChartPie": return (await import("../../illustrations/tnt/ChartPie.js")).default;
		case "CodePlaceholder": return (await import("../../illustrations/tnt/CodePlaceholder.js")).default;
		case "Company": return (await import("../../illustrations/tnt/Company.js")).default;
		case "Components": return (await import("../../illustrations/tnt/Components.js")).default;
		case "ExternalLink": return (await import("../../illustrations/tnt/ExternalLink.js")).default;
		case "FaceID": return (await import("../../illustrations/tnt/FaceID.js")).default;
		case "Fingerprint": return (await import("../../illustrations/tnt/Fingerprint.js")).default;
		case "Lock": return (await import("../../illustrations/tnt/Lock.js")).default;
		case "Mission": return (await import("../../illustrations/tnt/Mission.js")).default;
		case "NoApplications": return (await import("../../illustrations/tnt/NoApplications.js")).default;
		case "NoFlows": return (await import("../../illustrations/tnt/NoFlows.js")).default;
		case "NoUsers": return (await import("../../illustrations/tnt/NoUsers.js")).default;
		case "Radar": return (await import("../../illustrations/tnt/Radar.js")).default;
		case "Secrets": return (await import("../../illustrations/tnt/Secrets.js")).default;
		case "Services": return (await import("../../illustrations/tnt/Services.js")).default;
		case "SessionExpired": return (await import("../../illustrations/tnt/SessionExpired.js")).default;
		case "SessionExpiring": return (await import("../../illustrations/tnt/SessionExpiring.js")).default;
		case "Success": return (await import("../../illustrations/tnt/Success.js")).default;
		case "SuccessfulAuth": return (await import("../../illustrations/tnt/SuccessfulAuth.js")).default;
		case "Systems": return (await import("../../illustrations/tnt/Systems.js")).default;
		case "Teams": return (await import("../../illustrations/tnt/Teams.js")).default;
		case "Tools": return (await import("../../illustrations/tnt/Tools.js")).default;
		case "UnableToLoad": return (await import("../../illustrations/tnt/UnableToLoad.js")).default;
		case "Unlock": return (await import("../../illustrations/tnt/Unlock.js")).default;
		case "UnsuccessfulAuth": return (await import("../../illustrations/tnt/UnsuccessfulAuth.js")).default;
		case "User2": return (await import("../../illustrations/tnt/User2.js")).default;
    default:
      throw new Error("[Illustrations] Illustration not found: " + illustrationName);
  }
};

const loadAndCheck = async (illustrationName) => {
  const data = await loadIllustration(illustrationName);
  return data;
};

["ChartArea","ChartArea2","ChartBPMNFlow","ChartBar","ChartBullet","ChartDoughnut","ChartFlow","ChartGantt","ChartOrg","ChartPie","CodePlaceholder","Company","Components","ExternalLink","FaceID","Fingerprint","Lock","Mission","NoApplications","NoFlows","NoUsers","Radar","Secrets","Services","SessionExpired","SessionExpiring","Success","SuccessfulAuth","Systems","Teams","Tools","UnableToLoad","Unlock","UnsuccessfulAuth","User2"].forEach((illustrationName) =>
  registerIllustrationLoader(`V4/Tnt${illustrationName}`, loadAndCheck)
);
