import { registerIllustrationLoader } from "@ui5/webcomponents-base/dist/asset-registries/Illustrations.js";

export const loadIllustration = async (illustrationName) => {
  const collectionAndPrefix = "V5/Tnt";
  const cleanIllustrationName = illustrationName.startsWith(collectionAndPrefix) ? illustrationName.replace(collectionAndPrefix, "") : illustrationName;
  switch (cleanIllustrationName) {
		case "ChartArea": return (await import("../../illustrations-v5/tnt/ChartArea.js")).default;
		case "ChartArea2": return (await import("../../illustrations-v5/tnt/ChartArea2.js")).default;
		case "ChartBPMNFlow": return (await import("../../illustrations-v5/tnt/ChartBPMNFlow.js")).default;
		case "ChartBar": return (await import("../../illustrations-v5/tnt/ChartBar.js")).default;
		case "ChartBullet": return (await import("../../illustrations-v5/tnt/ChartBullet.js")).default;
		case "ChartDoughnut": return (await import("../../illustrations-v5/tnt/ChartDoughnut.js")).default;
		case "ChartFlow": return (await import("../../illustrations-v5/tnt/ChartFlow.js")).default;
		case "ChartGantt": return (await import("../../illustrations-v5/tnt/ChartGantt.js")).default;
		case "ChartOrg": return (await import("../../illustrations-v5/tnt/ChartOrg.js")).default;
		case "ChartPie": return (await import("../../illustrations-v5/tnt/ChartPie.js")).default;
		case "CodePlaceholder": return (await import("../../illustrations-v5/tnt/CodePlaceholder.js")).default;
		case "Company": return (await import("../../illustrations-v5/tnt/Company.js")).default;
		case "Components": return (await import("../../illustrations-v5/tnt/Components.js")).default;
		case "EmptyContentPane": return (await import("../../illustrations-v5/tnt/EmptyContentPane.js")).default;
		case "ExternalLink": return (await import("../../illustrations-v5/tnt/ExternalLink.js")).default;
		case "FaceID": return (await import("../../illustrations-v5/tnt/FaceID.js")).default;
		case "Fingerprint": return (await import("../../illustrations-v5/tnt/Fingerprint.js")).default;
		case "Lock": return (await import("../../illustrations-v5/tnt/Lock.js")).default;
		case "Mission": return (await import("../../illustrations-v5/tnt/Mission.js")).default;
		case "NoApplications": return (await import("../../illustrations-v5/tnt/NoApplications.js")).default;
		case "NoFlows": return (await import("../../illustrations-v5/tnt/NoFlows.js")).default;
		case "NoUsers": return (await import("../../illustrations-v5/tnt/NoUsers.js")).default;
		case "Radar": return (await import("../../illustrations-v5/tnt/Radar.js")).default;
		case "Secrets": return (await import("../../illustrations-v5/tnt/Secrets.js")).default;
		case "Services": return (await import("../../illustrations-v5/tnt/Services.js")).default;
		case "SessionExpired": return (await import("../../illustrations-v5/tnt/SessionExpired.js")).default;
		case "SessionExpiring": return (await import("../../illustrations-v5/tnt/SessionExpiring.js")).default;
		case "Success": return (await import("../../illustrations-v5/tnt/Success.js")).default;
		case "SuccessfulAuth": return (await import("../../illustrations-v5/tnt/SuccessfulAuth.js")).default;
		case "Systems": return (await import("../../illustrations-v5/tnt/Systems.js")).default;
		case "Teams": return (await import("../../illustrations-v5/tnt/Teams.js")).default;
		case "Tools": return (await import("../../illustrations-v5/tnt/Tools.js")).default;
		case "UnSuccessfulAuth": return (await import("../../illustrations-v5/tnt/UnSuccessfulAuth.js")).default;
		case "Unlock": return (await import("../../illustrations-v5/tnt/Unlock.js")).default;
    default:
      throw new Error("[Illustrations] Illustration not found: " + illustrationName);
  }
};

const loadAndCheck = async (illustrationName) => {
  const data = await loadIllustration(illustrationName);
  return data;
};

["ChartArea","ChartArea2","ChartBPMNFlow","ChartBar","ChartBullet","ChartDoughnut","ChartFlow","ChartGantt","ChartOrg","ChartPie","CodePlaceholder","Company","Components","EmptyContentPane","ExternalLink","FaceID","Fingerprint","Lock","Mission","NoApplications","NoFlows","NoUsers","Radar","Secrets","Services","SessionExpired","SessionExpiring","Success","SuccessfulAuth","Systems","Teams","Tools","UnSuccessfulAuth","Unlock"].forEach((illustrationName) =>
  registerIllustrationLoader(`V5/Tnt${illustrationName}`, loadAndCheck)
);
