import { registerIllustrationLoader } from "@ui5/webcomponents-base/dist/asset-registries/Illustrations.js";

export const loadIllustration = async (illustrationName) => {
  const collectionAndPrefix = "V5/HC/Tnt";
  const cleanIllustrationName = illustrationName.startsWith(collectionAndPrefix) ? illustrationName.replace(collectionAndPrefix, "") : illustrationName;
  switch (cleanIllustrationName) {
		case "ChartArea": return (await import("../../illustrations-v5/tnt/hc/ChartArea.js")).default;
		case "ChartArea2": return (await import("../../illustrations-v5/tnt/hc/ChartArea2.js")).default;
		case "ChartBPMNFlow": return (await import("../../illustrations-v5/tnt/hc/ChartBPMNFlow.js")).default;
		case "ChartBar": return (await import("../../illustrations-v5/tnt/hc/ChartBar.js")).default;
		case "ChartBullet": return (await import("../../illustrations-v5/tnt/hc/ChartBullet.js")).default;
		case "ChartDoughnut": return (await import("../../illustrations-v5/tnt/hc/ChartDoughnut.js")).default;
		case "ChartFlow": return (await import("../../illustrations-v5/tnt/hc/ChartFlow.js")).default;
		case "ChartGantt": return (await import("../../illustrations-v5/tnt/hc/ChartGantt.js")).default;
		case "ChartOrg": return (await import("../../illustrations-v5/tnt/hc/ChartOrg.js")).default;
		case "ChartPie": return (await import("../../illustrations-v5/tnt/hc/ChartPie.js")).default;
		case "CodePlaceholder": return (await import("../../illustrations-v5/tnt/hc/CodePlaceholder.js")).default;
		case "Company": return (await import("../../illustrations-v5/tnt/hc/Company.js")).default;
		case "Components": return (await import("../../illustrations-v5/tnt/hc/Components.js")).default;
		case "EmptyContentPane": return (await import("../../illustrations-v5/tnt/hc/EmptyContentPane.js")).default;
		case "ExternalLink": return (await import("../../illustrations-v5/tnt/hc/ExternalLink.js")).default;
		case "FaceID": return (await import("../../illustrations-v5/tnt/hc/FaceID.js")).default;
		case "Fingerprint": return (await import("../../illustrations-v5/tnt/hc/Fingerprint.js")).default;
		case "Lock": return (await import("../../illustrations-v5/tnt/hc/Lock.js")).default;
		case "Mission": return (await import("../../illustrations-v5/tnt/hc/Mission.js")).default;
		case "NoApplications": return (await import("../../illustrations-v5/tnt/hc/NoApplications.js")).default;
		case "NoFlows": return (await import("../../illustrations-v5/tnt/hc/NoFlows.js")).default;
		case "NoUsers": return (await import("../../illustrations-v5/tnt/hc/NoUsers.js")).default;
		case "Radar": return (await import("../../illustrations-v5/tnt/hc/Radar.js")).default;
		case "Secrets": return (await import("../../illustrations-v5/tnt/hc/Secrets.js")).default;
		case "Services": return (await import("../../illustrations-v5/tnt/hc/Services.js")).default;
		case "SessionExpired": return (await import("../../illustrations-v5/tnt/hc/SessionExpired.js")).default;
		case "SessionExpiring": return (await import("../../illustrations-v5/tnt/hc/SessionExpiring.js")).default;
		case "Success": return (await import("../../illustrations-v5/tnt/hc/Success.js")).default;
		case "SuccessfulAuth": return (await import("../../illustrations-v5/tnt/hc/SuccessfulAuth.js")).default;
		case "Systems": return (await import("../../illustrations-v5/tnt/hc/Systems.js")).default;
		case "Teams": return (await import("../../illustrations-v5/tnt/hc/Teams.js")).default;
		case "Tools": return (await import("../../illustrations-v5/tnt/hc/Tools.js")).default;
		case "UnSuccessfulAuth": return (await import("../../illustrations-v5/tnt/hc/UnSuccessfulAuth.js")).default;
		case "Unlock": return (await import("../../illustrations-v5/tnt/hc/Unlock.js")).default;
    default:
      throw new Error("[Illustrations] Illustration not found: " + illustrationName);
  }
};

const loadAndCheck = async (illustrationName) => {
  const data = await loadIllustration(illustrationName);
  return data;
};

["ChartArea","ChartArea2","ChartBPMNFlow","ChartBar","ChartBullet","ChartDoughnut","ChartFlow","ChartGantt","ChartOrg","ChartPie","CodePlaceholder","Company","Components","EmptyContentPane","ExternalLink","FaceID","Fingerprint","Lock","Mission","NoApplications","NoFlows","NoUsers","Radar","Secrets","Services","SessionExpired","SessionExpiring","Success","SuccessfulAuth","Systems","Teams","Tools","UnSuccessfulAuth","Unlock"].forEach((illustrationName) =>
  registerIllustrationLoader(`V5/HC/Tnt${illustrationName}`, loadAndCheck)
);
