/**
 * Different types of Bar design
 *
 * @readonly
 * @enum {string}
 * @public
 * @author SAP SE
 * @alias sap.ui.webc.fiori.types.BarDesign
 */
var BarDesign;
(function (BarDesign) {
    /**
     * Default type
     * @public
     * @type {Header}
     */
    BarDesign["Header"] = "Header";
    /**
     * Subheader type
     * @public
     * @type {Subheader}
     */
    BarDesign["Subheader"] = "Subheader";
    /**
     * Footer type
     * @public
     * @type {Footer}
     */
    BarDesign["Footer"] = "Footer";
    /**
     * Floating Footer type - there is visible border on all sides
     * @public
     * @type {FloatingFooter}
     */
    BarDesign["FloatingFooter"] = "FloatingFooter";
})(BarDesign || (BarDesign = {}));
export default BarDesign;
//# sourceMappingURL=BarDesign.js.map