/**
 * SideContent FallDown options.
 * @public
 */
declare enum SideContentFallDown {
    /**
     * Side content falls down on breakpoints below XL
     * @public
     */
    BelowXL = "BelowXL",
    /**
     * Side content falls down on breakpoints below L
     * @public
     */
    BelowL = "BelowL",
    /**
     * Side content falls down on breakpoints below M
     * @public
     */
    BelowM = "BelowM",
    /**
     * Side content falls down on breakpoint M and the minimum width for the side content
     * @public
     */
    OnMinimumWidth = "OnMinimumWidth"
}
export default SideContentFallDown;
