import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import type { ITabbable } from "@ui5/webcomponents-base/dist/delegate/ItemNavigation.js";
import type ToggleButton from "@ui5/webcomponents/dist/ToggleButton.js";
import ItemNavigation from "@ui5/webcomponents-base/dist/delegate/ItemNavigation.js";
import TimelineLayout from "./types/TimelineLayout.js";
/**
 * Interface for components that may be slotted inside `ui5-timeline` as items
 * @public
 */
interface ITimelineItem extends UI5Element, ITabbable {
    layout: `${TimelineLayout}`;
    isGroupItem: boolean;
    forcedLineWidth?: string;
    icon?: string;
    nameClickable?: boolean;
    positionInGroup?: number;
    collapsed?: boolean;
    items?: Array<ITimelineItem>;
    focusLink?(): void;
    lastItem: boolean;
    isNextItemGroup?: boolean;
    firstItemInTimeline?: boolean;
}
/**
 * @class
 *
 * ### Overview
 *
 * The `ui5-timeline` component shows entries (such as objects, events, or posts) in chronological order.
 * A common use case is to provide information about changes to an object, or events related to an object.
 * These entries can be generated by the system (for example, value XY changed from A to B), or added manually.
 * There are two distinct variants of the timeline: basic and social. The basic timeline is read-only,
 * while the social timeline offers a high level of interaction and collaboration, and is integrated within SAP Jam.
 * @constructor
 * @extends UI5Element
 * @public
 * @since 0.8.0
 */
declare class Timeline extends UI5Element {
    /**
     * Defines the items orientation.
     * @default "Vertical"
     * @since 1.0.0-rc.15
     * @public
     */
    layout: `${TimelineLayout}`;
    /**
     * Defines the accessible ARIA name of the component.
     * @default undefined
     * @public
     * @since 1.2.0
     */
    accessibleName?: string;
    /**
     * Determines the content of the `ui5-timeline`.
     * @public
     */
    items: Array<ITimelineItem>;
    static i18nBundle: I18nBundle;
    _itemNavigation: ItemNavigation;
    constructor();
    get ariaLabel(): string;
    _onfocusin(e: FocusEvent): void;
    onBeforeRendering(): void;
    _setLastItem(): void;
    _setIsNextItemGroup(): void;
    _onkeydown(e: KeyboardEvent): void;
    _handleNextOrPreviousItem(e: KeyboardEvent, isNext?: boolean): void;
    get _navigatableItems(): (ToggleButton | ITimelineItem)[];
}
export default Timeline;
export type { ITimelineItem, };
