/**
 * Different illustration types of Illustrated Message.
 * @public
 */
declare enum IllustrationMessageType {
    /**
     * "Before Search" illustration type.
     * @public
     */
    BeforeSearch = "BeforeSearch",
    /**
     * "New Mail" illustration type.
     * @public
     */
    NewMail = "NewMail",
    /**
     * "No Activities" illustration type.
     * @public
     */
    NoActivities = "NoActivities",
    /**
     * "No Columns Set" illustration type.
     * @public
     */
    NoColumnsSet = "NoColumnsSet",
    /**
     * "No Data" illustration type.
     * @public
     */
    NoData = "NoData",
    /**
     * "No Email" illustration type.
     * @public
     */
    NoMail = "NoMail",
    /**
     * "No Email v1" illustration type.
     * @public
     */
    NoMail_v1 = "NoMail_v1",// eslint-disable-line
    /**
     * "No Entries" illustration type.
     * @public
     */
    NoEntries = "NoEntries",
    /**
     * "No Notifications" illustration type.
     * @public
     */
    NoNotifications = "NoNotifications",
    /**
     * "No Saved Items" illustration type.
     * @public
     */
    NoSavedItems = "NoSavedItems",
    /**
     * "No Saved Items v1" illustration type.
     * @public
     */
    NoSavedItems_v1 = "NoSavedItems_v1",// eslint-disable-line
    /**
     * "No Search Results" illustration type.
     * @public
     */
    NoSearchResults = "NoSearchResults",
    /**
     * "No Tasks" illustration type.
     * @public
     */
    NoTasks = "NoTasks",
    /**
     * "No Tasks v1" illustration type.
     * @public
     */
    NoTasks_v1 = "NoTasks_v1",// eslint-disable-line
    /**
     * "No Dimensions Set" illustration type.
     * @public
     */
    NoDimensionsSet = "NoDimensionsSet",
    /**
     * "Unable To Load" illustration type.
     * @public
     */
    UnableToLoad = "UnableToLoad",
    /**
     * "Unable To Load Image" illustration type.
     * @public
     */
    UnableToLoadImage = "UnableToLoadImage",
    /**
     * "Unable To Upload" illustration type.
     * @public
     */
    UnableToUpload = "UnableToUpload",
    /**
     * "Upload To Cloud" illustration type.
     * @public
     */
    UploadToCloud = "UploadToCloud",
    /**
     * "Add Column" illustration type.
     * @public
     */
    AddColumn = "AddColumn",
    /**
     * "Add People" illustration type.
     * @public
     */
    AddPeople = "AddPeople",
    /**
     * "Add Dimensions" illustration type.
     * @public
     */
    AddDimensions = "AddDimensions",
    /**
     * "Balloon Sky" illustration type.
     * @public
     */
    BalloonSky = "BalloonSky",
    /**
     * "Connection" illustration type.
     * @public
     */
    Connection = "Connection",
    /**
     * "Empty Calendar" illustration type.
     * @public
     */
    EmptyCalendar = "EmptyCalendar",
    /**
     * "Empty List" illustration type.
     * @public
     */
    EmptyList = "EmptyList",
    /**
     * "Empty Planning Calendar" illustration type.
     * @public
     */
    EmptyPlanningCalendar = "EmptyPlanningCalendar",
    /**
     * "Error Screen" illustration type.
     * @public
     */
    ErrorScreen = "ErrorScreen",
    /**
     * "Filter Table" illustration type.
     * @public
     */
    FilterTable = "FilterTable",
    /**
     * "Group Table" illustration type.
     * @public
     */
    GroupTable = "GroupTable",
    /**
     * "No Filter Results" illustration type.
     * @public
     */
    NoFilterResults = "NoFilterResults",
    /**
     * "Page Not Found" illustration type.
     * @public
     */
    PageNotFound = "PageNotFound",
    /**
     * "Reload Screen" illustration type.
     * @public
     */
    ReloadScreen = "ReloadScreen",
    /**
     * "Resize Column" illustration type.
     * @public
     */
    ResizeColumn = "ResizeColumn",
    /**
     * "Search Earth" illustration type.
     * @public
     */
    SearchEarth = "SearchEarth",
    /**
     * "Search Folder" illustration type.
     * @public
     */
    SearchFolder = "SearchFolder",
    /**
     * "Sign Out" illustration type.
     * @public
     */
    SignOut = "SignOut",
    /**
     * "Simple Balloon" illustration type.
     * @public
     */
    SimpleBalloon = "SimpleBalloon",
    /**
     * "Simple Bell" illustration type.
     * @public
     */
    SimpleBell = "SimpleBell",
    /**
     * "Simple Calendar" illustration type.
     * @public
     */
    SimpleCalendar = "SimpleCalendar",
    /**
     * "Simple CheckMark" illustration type.
     * @public
     */
    SimpleCheckMark = "SimpleCheckMark",
    /**
     * "Simple Connection" illustration type.
     * @public
     */
    SimpleConnection = "SimpleConnection",
    /**
     * "Simple Empty Doc" illustration type.
     * @public
     */
    SimpleEmptyDoc = "SimpleEmptyDoc",
    /**
     * "Simple Empty List" illustration type.
     * @public
     */
    SimpleEmptyList = "SimpleEmptyList",
    /**
     * "Simple Error" illustration type.
     * @public
     */
    SimpleError = "SimpleError",
    /**
     * "Simple Magnifier" illustration type.
     * @public
     */
    SimpleMagnifier = "SimpleMagnifier",
    /**
     * "Simple Mail" illustration type.
     * @public
     */
    SimpleMail = "SimpleMail",
    /**
     * "Simple No Saved Items" illustration type.
     * @public
     */
    SimpleNoSavedItems = "SimpleNoSavedItems",
    /**
     * "Simple Not Found Magnifier" illustration type.
     * @public
     */
    SimpleNotFoundMagnifier = "SimpleNotFoundMagnifier",
    /**
     * "Simple Reload" illustration type.
     * @public
     */
    SimpleReload = "SimpleReload",
    /**
     * "Simple Task" illustration type.
     * @public
     */
    SimpleTask = "SimpleTask",
    /**
     * "Sleeping Bell" illustration type.
     * @public
     */
    SleepingBell = "SleepingBell",
    /**
     * "Sort Column" illustration type.
     * @public
     */
    SortColumn = "SortColumn",
    /**
     * "Success Balloon" illustration type.
     * @public
     */
    SuccessBalloon = "SuccessBalloon",
    /**
     * "Success CheckMark" illustration type.
     * @public
     */
    SuccessCheckMark = "SuccessCheckMark",
    /**
     * "Success HighFive" illustration type.
     * @public
     */
    SuccessHighFive = "SuccessHighFive",
    /**
     * "Success Screen" illustration type.
     * @public
     */
    SuccessScreen = "SuccessScreen",
    /**
     * "Survey" illustration type.
     * @public
     */
    Survey = "Survey",
    /**
     * "Tent" illustration type.
     * @public
     */
    Tent = "Tent",
    /**
     * "Upload Collection" illustration type.
     * @public
     */
    UploadCollection = "UploadCollection",
    /**
    * "TntAvatar" illustration type.
    * @public
    */
    TntAvatar = "TntAvatar",
    /**
    * "TntCalculator" illustration type.
    * @public
    */
    TntCalculator = "TntCalculator",
    /**
    * "TntChartArea" illustration type.
    * @public
    */
    TntChartArea = "TntChartArea",
    /**
    * "TntChartArea2" illustration type.
    * @public
    */
    TntChartArea2 = "TntChartArea2",
    /**
    * "TntChartBar" illustration type.
    * @public
    */
    TntChartBar = "TntChartBar",
    /**
    * "TntChartBPMNFlow" illustration type.
    * @public
    */
    TntChartBPMNFlow = "TntChartBPMNFlow",
    /**
    * "TntChartBullet" illustration type.
    * @public
    */
    TntChartBullet = "TntChartBullet",
    /**
    * "TntChartDoughnut" illustration type.
    * @public
    */
    TntChartDoughnut = "TntChartDoughnut",
    /**
    * "TntChartFlow" illustration type.
    * @public
    */
    TntChartFlow = "TntChartFlow",
    /**
    * "TntChartGantt" illustration type.
    * @public
    */
    TntChartGantt = "TntChartGantt",
    /**
    * "TntChartOrg" illustration type.
    * @public
    */
    TntChartOrg = "TntChartOrg",
    /**
    * "TntChartPie" illustration type.
    * @public
    */
    TntChartPie = "TntChartPie",
    /**
    * "TntCodePlaceholder" illustration type.
    * @public
    */
    TntCodePlaceholder = "TntCodePlaceholder",
    /**
    * "TntCompany" illustration type.
    * @public
    */
    TntCompany = "TntCompany",
    /**
    * "TntCompass" illustration type.
    * @public
    */
    TntCompass = "TntCompass",
    /**
    * "TntComponents" illustration type.
    * @public
    */
    TntComponents = "TntComponents",
    /**
    * "TntDialog" illustration type.
    * @public
    */
    TntDialog = "TntDialog",
    /**
    * "TntExternalLink" illustration type.
    * @public
    */
    TntExternalLink = "TntExternalLink",
    /**
    * "TntFaceID" illustration type.
    * @public
    */
    TntFaceID = "TntFaceID",
    /**
    * "TntFingerprint" illustration type.
    * @public
    */
    TntFingerprint = "TntFingerprint",
    /**
    * "TntHandshake" illustration type.
    * @public
    */
    TntHandshake = "TntHandshake",
    /**
    * "TntHelp" illustration type.
    * @public
    */
    TntHelp = "TntHelp",
    /**
    * "TntLock" illustration type.
    * @public
    */
    TntLock = "TntLock",
    /**
    * "TntMission" illustration type.
    * @public
    */
    TntMission = "TntMission",
    /**
    * "TntMissionFailed" illustration type.
    * @public
    */
    TntMissionFailed = "TntMissionFailed",
    /**
    * "TntNoApplications" illustration type.
    * @public
    */
    TntNoApplications = "TntNoApplications",
    /**
    * "TntNoFlows" illustration type.
    * @public
    */
    TntNoFlows = "TntNoFlows",
    /**
    * "TntNoUsers" illustration type.
    * @public
    */
    TntNoUsers = "TntNoUsers",
    /**
    * "TntRadar" illustration type.
    * @public
    */
    TntRadar = "TntRadar",
    /**
    * "TntRoadMap" illustration type.
    * @public
    */
    TntRoadMap = "TntRoadMap",
    /**
    * "TntSecrets" illustration type.
    * @public
    */
    TntSecrets = "TntSecrets",
    /**
    * "TntServices" illustration type.
    * @public
    */
    TntServices = "TntServices",
    /**
    * "TntSessionExpired" illustration type.
    * @public
    */
    TntSessionExpired = "TntSessionExpired",
    /**
    * "TntSessionExpiring" illustration type.
    * @public
    */
    TntSessionExpiring = "TntSessionExpiring",
    /**
    * "TntSettings" illustration type.
    * @public
    */
    TntSettings = "TntSettings",
    /**
    * "TntSuccess" illustration type.
    * @public
    */
    TntSuccess = "TntSuccess",
    /**
    * "TntSuccessfulAuth" illustration type.
    * @public
    */
    TntSuccessfulAuth = "TntSuccessfulAuth",
    /**
    * "TntSystems" illustration type.
    * @public
    */
    TntSystems = "TntSystems",
    /**
    * "TntTeams" illustration type.
    * @public
    */
    TntTeams = "TntTeams",
    /**
    * "TntTools" illustration type.
    * @public
    */
    TntTools = "TntTools",
    /**
    * "TntTutorials" illustration type.
    * @public
    */
    TntTutorials = "TntTutorials",
    /**
    * "TntUnableToLoad" illustration type.
    * @public
    */
    TntUnableToLoad = "TntUnableToLoad",
    /**
    * "TntUnlock" illustration type.
    * @public
    */
    TntUnlock = "TntUnlock",
    /**
    * "TntUnsuccessfulAuth" illustration type.
    * @public
    */
    TntUnsuccessfulAuth = "TntUnsuccessfulAuth",
    /**
    * "TntUser2" illustration type.
    * @public
    */
    TntUser2 = "TntUser2"
}
export default IllustrationMessageType;
