var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var Timeline_1;
import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import customElement from "@ui5/webcomponents-base/dist/decorators/customElement.js";
import property from "@ui5/webcomponents-base/dist/decorators/property.js";
import slot from "@ui5/webcomponents-base/dist/decorators/slot.js";
import i18n from "@ui5/webcomponents-base/dist/decorators/i18n.js";
import jsxRenderer from "@ui5/webcomponents-base/dist/renderer/JsxRenderer.js";
import { isTabNext, isTabPrevious, } from "@ui5/webcomponents-base/dist/Keys.js";
import ItemNavigation from "@ui5/webcomponents-base/dist/delegate/ItemNavigation.js";
import NavigationMode from "@ui5/webcomponents-base/dist/types/NavigationMode.js";
import { TIMELINE_ARIA_LABEL } from "./generated/i18n/i18n-defaults.js";
import TimelineTemplate from "./TimelineTemplate.js";
import "./TimelineItem.js";
import "./TimelineGroupItem.js";
// Styles
import TimelineCss from "./generated/themes/Timeline.css.js";
import TimelineLayout from "./types/TimelineLayout.js";
const SHORT_LINE_WIDTH = "ShortLineWidth";
const LARGE_LINE_WIDTH = "LargeLineWidth";
/**
 * @class
 *
 * ### Overview
 *
 * The `ui5-timeline` component shows entries (such as objects, events, or posts) in chronological order.
 * A common use case is to provide information about changes to an object, or events related to an object.
 * These entries can be generated by the system (for example, value XY changed from A to B), or added manually.
 * There are two distinct variants of the timeline: basic and social. The basic timeline is read-only,
 * while the social timeline offers a high level of interaction and collaboration, and is integrated within SAP Jam.
 * @constructor
 * @extends UI5Element
 * @public
 * @since 0.8.0
 */
let Timeline = Timeline_1 = class Timeline extends UI5Element {
    constructor() {
        super();
        /**
         * Defines the items orientation.
         * @default "Vertical"
         * @since 1.0.0-rc.15
         * @public
         */
        this.layout = "Vertical";
        this._itemNavigation = new ItemNavigation(this, {
            getItemsCallback: () => this._navigatableItems,
        });
    }
    get ariaLabel() {
        return this.accessibleName
            ? `${Timeline_1.i18nBundle.getText(TIMELINE_ARIA_LABEL)} ${this.accessibleName}`
            : Timeline_1.i18nBundle.getText(TIMELINE_ARIA_LABEL);
    }
    _onfocusin(e) {
        let target = e.target;
        if (target.isGroupItem) {
            target = target.shadowRoot.querySelector("[ui5-toggle-button]");
        }
        this._itemNavigation.setCurrentItem(target);
    }
    onBeforeRendering() {
        this._itemNavigation._navigationMode = this.layout === TimelineLayout.Horizontal ? NavigationMode.Horizontal : NavigationMode.Vertical;
        if (!this.items.length) {
            return;
        }
        for (let i = 0; i < this.items.length; i++) {
            this.items[i].layout = this.layout;
            if (this.items[i + 1] && !!this.items[i + 1].icon) {
                this.items[i].forcedLineWidth = SHORT_LINE_WIDTH;
            }
            else if (this.items[i].icon && this.items[i + 1] && !this.items[i + 1].icon) {
                this.items[i].forcedLineWidth = LARGE_LINE_WIDTH;
            }
        }
        this._setLastItem();
        this._setIsNextItemGroup();
        this.items[0].firstItemInTimeline = true;
    }
    _setLastItem() {
        const items = this.items;
        for (let i = 0; i < items.length; i++) {
            items[i].lastItem = false;
        }
        if (items.length > 0) {
            items[items.length - 1].lastItem = true;
        }
    }
    _setIsNextItemGroup() {
        for (let i = 0; i < this.items.length; i++) {
            this.items[i].isNextItemGroup = false;
        }
        for (let i = 0; i < this.items.length; i++) {
            if (this.items[i + 1] && this.items[i + 1].isGroupItem) {
                this.items[i].isNextItemGroup = true;
            }
        }
    }
    _onkeydown(e) {
        const target = e.target;
        if (target.nameClickable && !target.getFocusDomRef().matches(":has(:focus-within)")) {
            return;
        }
        if (isTabNext(e)) {
            this._handleNextOrPreviousItem(e, true);
        }
        else if (isTabPrevious(e)) {
            this._handleNextOrPreviousItem(e);
        }
    }
    _handleNextOrPreviousItem(e, isNext) {
        const target = e.target;
        let updatedTarget = target;
        if (target.isGroupItem) {
            updatedTarget = target.shadowRoot.querySelector("[ui5-toggle-button]");
        }
        const nextTargetIndex = isNext ? this._navigatableItems.indexOf(updatedTarget) + 1 : this._navigatableItems.indexOf(updatedTarget) - 1;
        const nextTarget = this._navigatableItems[nextTargetIndex];
        if (!nextTarget) {
            return;
        }
        if (nextTarget) {
            e.preventDefault();
            nextTarget.focus();
            this._itemNavigation.setCurrentItem(nextTarget);
        }
    }
    get _navigatableItems() {
        const navigatableItems = [];
        if (!this.items.length) {
            return [];
        }
        this.items.forEach(item => {
            if (!item.isGroupItem) {
                navigatableItems.push(item);
                return;
            }
            const navigatableItem = item.shadowRoot.querySelector("[ui5-toggle-button]");
            if (navigatableItem) {
                navigatableItems.push(navigatableItem);
            }
            if (!item.collapsed) {
                item.items?.forEach(groupItem => {
                    navigatableItems.push(groupItem);
                });
            }
        });
        return navigatableItems;
    }
};
__decorate([
    property()
], Timeline.prototype, "layout", void 0);
__decorate([
    property()
], Timeline.prototype, "accessibleName", void 0);
__decorate([
    slot({ type: HTMLElement, individualSlots: true, "default": true })
], Timeline.prototype, "items", void 0);
__decorate([
    i18n("@ui5/webcomponents-fiori")
], Timeline, "i18nBundle", void 0);
Timeline = Timeline_1 = __decorate([
    customElement({
        tag: "ui5-timeline",
        languageAware: true,
        renderer: jsxRenderer,
        styles: TimelineCss,
        template: TimelineTemplate,
    })
], Timeline);
Timeline.define();
export default Timeline;
//# sourceMappingURL=Timeline.js.map