import CalendarWeekNumbering from './CalendarWeekNumbering.js';
import Configuration from '../Configuration.js';
import LocaleData from '../LocaleData.js';
var mWeekNumberingConfiguration = {
    ISO_8601: {
        firstDayOfWeek: 1,
        minimalDaysInFirstWeek: 4
    },
    MiddleEastern: {
        firstDayOfWeek: 6,
        minimalDaysInFirstWeek: 1
    },
    WesternTraditional: {
        firstDayOfWeek: 0,
        minimalDaysInFirstWeek: 1
    }
};
var CalendarUtils = {
    getWeekConfigurationValues: function (sCalendarWeekNumbering, oLocale) {
        var oLocaleData;
        if (mWeekNumberingConfiguration.hasOwnProperty(sCalendarWeekNumbering)) {
            return mWeekNumberingConfiguration[sCalendarWeekNumbering];
        }
        sCalendarWeekNumbering = sCalendarWeekNumbering || CalendarWeekNumbering.Default;
        if (sCalendarWeekNumbering === CalendarWeekNumbering.Default) {
            oLocale = oLocale || Configuration.getFormatSettings().getFormatLocale();
            oLocaleData = LocaleData.getInstance(oLocale);
            return {
                firstDayOfWeek: oLocaleData.getFirstDayOfWeek(),
                minimalDaysInFirstWeek: oLocaleData.getMinimalDaysInFirstWeek()
            };
        }
        return undefined;
    }
};
export default CalendarUtils;