var TimezoneUtil = {};
var sLocalTimezone = "";
var aSupportedTimezoneIDs;
var oIntlDateTimeFormatCache = {
  _oCache: new Map(),
  _iCacheLimit: 10,
  get: function (sTimezone) {
    var cacheEntry = this._oCache.get(sTimezone);
    if (cacheEntry) {
      return cacheEntry;
    }
    var oOptions = {
      hourCycle: "h23",
      hour: "2-digit",
      minute: "2-digit",
      second: "2-digit",
      fractionalSecondDigits: 3,
      day: "2-digit",
      month: "2-digit",
      year: "numeric",
      timeZone: sTimezone,
      timeZoneName: "short",
      era: "narrow",
      weekday: "short"
    };
    var oInstance = new Intl.DateTimeFormat("en-US", oOptions);
    if (this._oCache.size === this._iCacheLimit) {
      this._oCache = new Map();
    }
    this._oCache.set(sTimezone, oInstance);
    return oInstance;
  }
};
TimezoneUtil.isValidTimezone = function (sTimezone) {
  if (!sTimezone) {
    return false;
  }
  if (Intl.supportedValuesOf) {
    try {
      aSupportedTimezoneIDs = aSupportedTimezoneIDs || Intl.supportedValuesOf("timeZone");
      if (aSupportedTimezoneIDs.includes(sTimezone)) {
        return true;
      }
    } catch (oError) {
      aSupportedTimezoneIDs = [];
    }
  }
  try {
    oIntlDateTimeFormatCache.get(sTimezone);
    return true;
  } catch (oError) {
    return false;
  }
};
TimezoneUtil.convertToTimezone = function (oDate, sTargetTimezone) {
  var oFormatParts = this._getParts(oDate, sTargetTimezone);
  return TimezoneUtil._getDateFromParts(oFormatParts);
};
TimezoneUtil._getParts = function (oDate, sTargetTimezone) {
  var sKey, oPart, oDateParts = Object.create(null), oIntlDate = oIntlDateTimeFormatCache.get(sTargetTimezone), oParts = oIntlDate.formatToParts(new Date(oDate.getTime()));
  for (sKey in oParts) {
    oPart = oParts[sKey];
    if (oPart.type !== "literal") {
      oDateParts[oPart.type] = oPart.value;
    }
  }
  return oDateParts;
};
TimezoneUtil._getDateFromParts = function (oParts) {
  var oDate = new Date(0), iUTCYear = parseInt(oParts.year);
  if (oParts.era === "B") {
    iUTCYear = iUTCYear * -1 + 1;
  }
  oDate.setUTCFullYear(iUTCYear, parseInt(oParts.month) - 1, parseInt(oParts.day));
  oDate.setUTCHours(parseInt(oParts.hour), parseInt(oParts.minute), parseInt(oParts.second), parseInt(oParts.fractionalSecond || 0));
  return oDate;
};
TimezoneUtil.calculateOffset = function (oDate, sTimezoneSource) {
  var oFirstGuess = this.convertToTimezone(oDate, sTimezoneSource), iInitialOffset = oDate.getTime() - oFirstGuess.getTime(), oDateSource = new Date(oDate.getTime() + iInitialOffset), oDateTarget = this.convertToTimezone(oDateSource, sTimezoneSource);
  return (oDateSource.getTime() - oDateTarget.getTime()) / 1000;
};
TimezoneUtil.getLocalTimezone = function () {
  if (sLocalTimezone) {
    return sLocalTimezone;
  }
  sLocalTimezone = new Intl.DateTimeFormat().resolvedOptions().timeZone;
  return sLocalTimezone;
};
export default TimezoneUtil;
