var rLanguageTag = /^((?:[A-Z]{2,3}(?:-[A-Z]{3}){0,3})|[A-Z]{4}|[A-Z]{5,8})(?:-([A-Z]{4}))?(?:-([A-Z]{2}|[0-9]{3}))?((?:-[0-9A-Z]{5,8}|-[0-9][0-9A-Z]{3})*)((?:-[0-9A-WYZ](?:-[0-9A-Z]{2,8})+)*)(?:-(X(?:-[0-9A-Z]{1,8})+))?$/i;
var LanguageTag = function (sLanguageTag) {
  var aResult = rLanguageTag.exec(sLanguageTag.replace(/_/g, "-"));
  if (aResult === null) {
    throw new TypeError("The given language tag'" + sLanguageTag + "' does not adhere to BCP-47.");
  }
  this.language = aResult[1] || null;
  this.script = aResult[2] || null;
  this.region = aResult[3] || null;
  this.variant = aResult[4] && aResult[4].slice(1) || null;
  this.variantSubtags = this.variant ? this.variant.split("-") : [];
  this.extension = aResult[5] && aResult[5].slice(1) || null;
  this.extensionSubtags = this.variant ? this.variant.split("-") : [];
  this.privateUse = aResult[6] || null;
  this.privateUseSubtags = this.privateUse ? this.privateUse.slice(2).split("-") : [];
  if (this.language) {
    this.language = this.language.toLowerCase();
  }
  if (this.script) {
    this.script = this.script.toLowerCase().replace(/^[a-z]/, function ($) {
      return $.toUpperCase();
    });
  }
  if (this.region) {
    this.region = this.region.toUpperCase();
  }
  Object.freeze(this);
};
LanguageTag.prototype.toString = function () {
  return join(this.language, this.script, this.region, this.variant, this.extension, this.privateUse);
};
function join() {
  return Array.prototype.filter.call(arguments, Boolean).join("-");
}
export default LanguageTag;
