import assert from '../../base/assert.js';
import BaseObject from '../base/Object.js';
import Localization from '../../base/i18n/Localization.js';
import LanguageTag from '../../base/i18n/LanguageTag.js';
var Locale = BaseObject.extend('sap.ui.core.Locale', {
    constructor: function (vLocale) {
        BaseObject.apply(this);
        if (vLocale instanceof LanguageTag) {
            this.oLanguageTag = vLocale;
            this.sLocaleId = this.oLanguageTag.toString();
        } else {
            this.oLanguageTag = new LanguageTag(vLocale);
            this.sLocaleId = vLocale;
        }
        Object.assign(this, this.oLanguageTag);
        this.sLanguage = this.language;
    },
    getLanguage: function () {
        return this.language;
    },
    getScript: function () {
        return this.script;
    },
    getRegion: function () {
        return this.region;
    },
    getVariant: function () {
        return this.variant;
    },
    getVariantSubtags: function () {
        return this.variantSubtags;
    },
    getExtension: function () {
        return this.extension;
    },
    getExtensionSubtags: function () {
        return this.extensionSubtags;
    },
    getPrivateUse: function () {
        return this.privateUse;
    },
    getPrivateUseSubtags: function () {
        return this.privateUseSubtags;
    },
    hasPrivateUseSubtag: function (sSubtag) {
        assert(sSubtag && sSubtag.match(/^[0-9A-Z]{1,8}$/i), 'subtag must be a valid BCP47 private use tag');
        return this.privateUseSubtags.indexOf(sSubtag) >= 0;
    },
    toString: function () {
        return this.oLanguageTag.toString();
    },
    getSAPLogonLanguage: function () {
        return Localization._getSAPLogonLanguage(this);
    }
});
Locale._getCoreLocale = function (oLocale) {
    if (oLocale instanceof LanguageTag) {
        oLocale = new Locale(oLocale);
    }
    return oLocale;
};
export default Locale;