import CalendarWeekNumbering from './CalendarWeekNumbering.js';
import Configuration from '../Configuration.js';
import LocaleData from '../LocaleData.js';
var CalendarUtils = {
    getWeekConfigurationValues: function (sCalendarWeekNumbering, oLocale) {
        var oLocaleData, oWeekConfigurationValues;
        if (!sCalendarWeekNumbering) {
            return CalendarUtils.getWeekConfigurationValues(Configuration.getCalendarWeekNumbering(), oLocale);
        }
        oWeekConfigurationValues = CalendarWeekNumbering.getWeekConfigurationValues(sCalendarWeekNumbering);
        if (oWeekConfigurationValues) {
            return oWeekConfigurationValues;
        }
        if (sCalendarWeekNumbering === CalendarWeekNumbering.Default) {
            oLocale = oLocale || Configuration.getFormatSettings().getFormatLocale();
            oLocaleData = LocaleData.getInstance(oLocale);
            return {
                firstDayOfWeek: oLocaleData.getFirstDayOfWeek(),
                minimalDaysInFirstWeek: oLocaleData.getMinimalDaysInFirstWeek()
            };
        }
        return undefined;
    }
};
export default CalendarUtils;