![UI5 icon](https://raw.githubusercontent.com/SAP/ui5-webcomponents/master/docs/images/UI5_logo_wide.png)

# UI5 Web Components - Main

[![Travis CI Build Status](https://travis-ci.org/SAP/ui5-webcomponents.svg?branch=master)](https://travis-ci.org/SAP/ui5-webcomponents)
[![npm Package Version](https://badge.fury.io/js/%40ui5%2Fwebcomponents.svg)](https://www.npmjs.com/package/@ui5/webcomponents)

Provides general purpose UI building blocks such as buttons, labels, inputs and popups.

## Provided components

| Web Component            | Tag name                    | Module import                                              |
|--------------------------|-----------------------------|------------------------------------------------------------|
| Avatar                   | `ui5-avatar`                | `import "@ui5/webcomponents/dist/Avatar.js";`              |
| Avatar Group             | `ui5-avatar-group`          | `import "@ui5/webcomponents/dist/AvatarGroup.js";`         |
| Badge                    | `ui5-badge`                 | `import "@ui5/webcomponents/dist/Badge.js";`               |
| Breadcrumbs              | `ui5-breadcrumbs`           | `import "@ui5/webcomponents/dist/Breadcrumbs.js";`         |
| Breadcrumbs Item         | `ui5-breadcrumbs-item`      | comes with `ui5-breadcrumbs`                               |
| Badge                    | `ui5-badge`                 | `import "@ui5/webcomponents/dist/Badge.js";`               |
| Busy Indicator           | `ui5-busy-indicator`        | `import "@ui5/webcomponents/dist/BusyIndicator.js";`       |
| Button                   | `ui5-button`                | `import "@ui5/webcomponents/dist/Button.js";`              |
| Calendar                 | `ui5-calendar`              | `import "@ui5/webcomponents/dist/Calendar.js";`            |
| Calendar Date            | `ui5-calendar-date`         | comes with `ui5-calendar`                                  |
| Card                     | `ui5-card`                  | `import "@ui5/webcomponents/dist/Card.js";`                |
| CardHeader               | `ui5-card-header`           | `import "@ui5/webcomponents/dist/CardHeader.js";`          |
| Carousel                 | `ui5-carousel`              | `import "@ui5/webcomponents/dist/Carousel.js";`            |
| Checkbox                 | `ui5-checkbox`              | `import "@ui5/webcomponents/dist/CheckBox.js";`            |
| Color Palette            | `ui5-color-palette`         | `import "@ui5/webcomponents/dist/ColorPalette.js";`        |
| Color Palette Item       | `ui5-color-palette-item`    | comes with `ui5-color-palette`                             |
| Color Palette Popover    | `ui5-color-palette-popover` | comes with `ui5-color-palette-popover`                     |
| Color Picker             | `ui5-color-picker`          | `import "@ui5/webcomponents/dist/ComboPicker.js";`         |
| ComboBox                 | `ui5-combobox`              | `import "@ui5/webcomponents/dist/ComboBox.js";`            |
| ComboBox Item            | `ui5-cb-item`               | comes with `ui5-combobox`                                  |
| ComboBox Group Item      | `ui5-cb-group-item`         | comes with `ui5-combobox`                                  |
| Date Picker              | `ui5-date-picker`           | `import "@ui5/webcomponents/dist/DatePicker.js";`          |
| Date Range Picker        | `ui5-daterange-picker`      | `import "@ui5/webcomponents/dist/DateRangePicker.js";`     |
| Date Time Picker         | `ui5-datetime-picker`       | `import "@ui5/webcomponents/dist/DateTimePicker.js";`      |
| Dialog                   | `ui5-dialog`                | `import "@ui5/webcomponents/dist/Dialog.js";`              |
| File Uploader            | `ui5-file-uploader`         | `import "@ui5/webcomponents/dist/FileUploader.js";`        |
| Icon                     | `ui5-icon`                  | `import "@ui5/webcomponents/dist/Icon.js";`                |
| Input                    | `ui5-input`                 | `import "@ui5/webcomponents/dist/Input.js";`               |
| Label                    | `ui5-label`                 | `import "@ui5/webcomponents/dist/Label.js";`               |
| Link                     | `ui5-link`                  | `import "@ui5/webcomponents/dist/Link.js";`                |
| List                     | `ui5-list`                  | `import "@ui5/webcomponents/dist/List.js";`                |
| List - Standard Item     | `ui5-li`                    | `import "@ui5/webcomponents/dist/StandardListItem.js";`    |
| List - Custom Item       | `ui5-li-custom`             | `import "@ui5/webcomponents/dist/CustomListItem.js";`      |
| List - Group Header Item | `ui5-li-groupheader`        | `import "@ui5/webcomponents/dist/GroupHeaderListItem.js";` |
| Message Strip            | `ui5-message-strip`          | `import "@ui5/webcomponents/dist/MessageStrip.js";`        |
| Multi ComboBox           | `ui5-multi-combobox`        | `import "@ui5/webcomponents/dist/MultiComboBox.js";`       |
| Multi ComboBox Item      | `ui5-mcb-item`              | comes with `ui5-multi-combobox`                            |
| Multi Input              | `ui5-multi-input`           | `import "@ui5/webcomponents/dist/MultiInput.js";`          |
| Panel                    | `ui5-panel`                 | `import "@ui5/webcomponents/dist/Panel.js";`               |
| Popover                  | `ui5-popover`               | `import "@ui5/webcomponents/dist/Popover.js";`             |
| ProgressIndicator        | `ui5-progress-indicator`    | `import "@ui5/webcomponents/dist/ProgressIndicator.js";`   |
| Radio Button             | `ui5-radio-button`          | `import "@ui5/webcomponents/dist/RadioButton.js";`         |
| Range Slider             | `ui5-range-slider`          | `import "@ui5/webcomponents/dist/RangeSlider.js";`         |
| Rating Indicator         | `ui5-rating-indicator`      | `import "@ui5/webcomponents/dist/RatingIndicator.js";`     |
| Responsive Popover       | `ui5-responsive-popover`    | `import "@ui5/webcomponents/dist/ResponsivePopover.js";`   |
| Segmented Button         | `ui5-segmented-button`      | `import "@ui5/webcomponents/dist/SegmentedButton.js";`     |
| Segmented Button Item    | `ui5-segmented-button-item` | comes with `ui5-segmented-button `                         |
| Select                   | `ui5-select`                | `import "@ui5/webcomponents/dist/Select.js";`              |
| Select Option            | `ui5-option`                | comes with `ui5-select `                                   |
| Slider                   | `ui5-slider`                | `import "@ui5/webcomponents/dist/Slider.js";`              |
| Step Input               | `ui5-step-input`            | `import "@ui5/webcomponents/dist/StepInput.js";`           |
| Suggestion Item          | `ui5-suggestion-item`       | comes with `InputSuggestions.js` feature - see below       |
| Switch                   | `ui5-switch`                | `import "@ui5/webcomponents/dist/Switch.js";`              |
| Tab Container            | `ui5-tabcontainer`          | `import "@ui5/webcomponents/dist/TabContainer.js";`        |
| Tab                      | `ui5-tab`                   | `import "@ui5/webcomponents/dist/Tab.js";`                 |
| Tab Separator            | `ui5-tab-separator`         | `import "@ui5/webcomponents/dist/TabSeparator.js";`        |
| Table                    | `ui5-table`                 | `import "@ui5/webcomponents/dist/Table.js";`               |
| Table Column             | `ui5-table-column`          | `import "@ui5/webcomponents/dist/TableColumn.js";`         |
| Table Row                | `ui5-table-row`             | `import "@ui5/webcomponents/dist/TableRow.js";`            |
| Table Group Row          | `ui5-table-group-row`       | `import "@ui5/webcomponents/dist/TableGroupRow.js";`       |
| Table Cell               | `ui5-table-cell`            | `import "@ui5/webcomponents/dist/TableCell.js";`           |
| Textarea                 | `ui5-textarea`              | `import "@ui5/webcomponents/dist/TextArea.js";`            |
| TimePicker               | `ui5-time-picker`           | `import "@ui5/webcomponents/dist/TimePicker.js";`          |
| Title                    | `ui5-title`                 | `import "@ui5/webcomponents/dist/Title.js";`               |
| Toast                    | `ui5-toast`                 | `import "@ui5/webcomponents/dist/Toast.js";`               |
| Toggle Button            | `ui5-toggle-button`         | `import "@ui5/webcomponents/dist/ToggleButton.js";`        |
| Tree                     | `ui5-tree`                  | `import "@ui5/webcomponents/dist/Tree.js";`                |
| Tree Item                | `ui5-tree-item`             | comes with `ui5-tree`                                      |

## Provided assets

`import "@ui5/webcomponents/dist/Assets.js";`

| Assets | Module | Notes
|------------|-----------|----------- 
| `i18n`, `themes` | `@ui5/webcomponents/dist/Assets.js` | Theming parameters and translations for the components  <br><br> *Automatically imports also:<br> `@ui5/webcomponents-localization/dist/Assets.js` <br> and <br> `@ui5/webcomponents-theming/dist/Assets.js`*

## Provided features

```js
import "@ui5/webcomponents/dist/features/<FEATURE-NAME>.js
```

| Affects                                           | Feature Import                                                       | Description                                                                                             |
|---------------------------------------------------|----------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------|
| `ui5-color-palette`                               | `@ui5/webcomponents/dist/features/ColorPaletteMoreColors.js`         | Support for "more colors dialog" for the color palette component                                        |
| `ui5-input`                                       | `@ui5/webcomponents/dist/features/InputSuggestions.js`               | Support for input suggestions while typing                                                              |
| Multiple (`ui5-input`, `ui5-date-picker`, etc...) | `@ui5/webcomponents/dist/features/InputElementsFormSupport.js`       | Support for using input components in forms                                                             |

### Color Palette "More Colors" Feature

```js
import "@ui5/webcomponents/dist/features/ColorPaletteMoreColors.js";
```

The `ui5-color-palette` component has a `showMoreColors` property, that, when set to `true`, enables a "More colors" dialog.
Since this is not always needed, in order to use this dialog, you must import the above feature.

### Input Suggestions Feature

```js
import "@ui5/webcomponents/dist/features/InputSuggestions.js";
```

The `<ui5-input>` element acts as an `<input>` with the Fiori design and added functionality, such as value state.

The so-called "input suggestions" is an advanced feature that allows the user to choose from a list of predefined options while typing.
Since input suggestions may not always be needed, they do not come as part of the `<ui5-input>` itself.

To enable the functionality, import the above module into your app. This will also automatically import `ui5-suggestion-item`
for your convenience.

### Form Support Feature

```js
import "@ui5/webcomponents/dist/features/InputElementsFormSupport.js";
```

HTML ```<form>``` only submits a couple of standard HTML elements such as `<input>` and `<textarea>` to name a few.

Web Components that function as inputs, such as UI5's `<ui5-input>`, `<ui5-checkbox>`, `<ui5-textarea>` are therefore
not submitted by the form out of the box.

Generally, this is not an issue, as very few modern applications submit forms in the classic way.

However, if you need to submit forms, you can import the module above, and it will enrich:
- `ui5-input`
- `ui5-textarea`
- `ui5-checkbox`
- `ui5-radio-button`
- `ui5-date-picker`
- `ui5-select`

with functionality, allowing them to be submitted in forms (provided you set their <code>name</code> attribute) just as
any standard HTML input element would be.

In addition, the `ui5-button` element will be able to submit the closest ```form``` it's placed in, provided you set its `submits` attribute.


## Resources
- [UI5 Web Components - README.md](https://github.com/SAP/ui5-webcomponents/blob/master/README.md)
- [UI5 Web Components - Home Page](https://sap.github.io/ui5-webcomponents)
- [UI5 Web Components - Playground and API Reference](https://sap.github.io/ui5-webcomponents/playground/)

## Support
We welcome all comments, suggestions, questions, and bug reports. Please follow our [Support Guidelines](https://github.com/SAP/ui5-webcomponents/blob/master/SUPPORT.md#-content) on how to report an issue, or chat with us in the `#webcomponents` channel of the [OpenUI5 Community Slack](https://join-ui5-slack.herokuapp.com/).

## Contribute
Please check our [Contribution Guidelines](https://github.com/SAP/ui5-webcomponents/blob/master/docs/6-contributing/02-conventions-and-guidelines.md).

## License
Copyright (c) 2019 SAP SE or an SAP affiliate company. All rights reserved.
This file is licensed under the Apache Software License, Version 2.0 except as noted otherwise in the [LICENSE](https://github.com/SAP/ui5-webcomponents/blob/master/LICENSE.txt) file.
