/**
 * Interface for components that represent an avatar and may be slotted in numerous higher-order components such as <code>ui5-avatar-group</code>
 *
 * @name sap.ui.webcomponents.main.IAvatar
 * @interface
 * @public
 */
const IAvatar = "sap.ui.webcomponents.main.IAvatar";

/**
 * Interface for components that may be slotted inside <code>ui5-breadcrumbs</code> as options
 *
 * @name sap.ui.webcomponents.main.IBreadcrumbsItem
 * @interface
 * @public
 */
const IBreadcrumbsItem = "sap.ui.webcomponents.main.IBreadcrumbsItem";

/**
 * Interface for components that may be used as a button inside numerous higher-order components
 *
 * @name sap.ui.webcomponents.main.IButton
 * @interface
 * @public
 */
const IButton = "sap.ui.webcomponents.main.IButton";

/**
 * Interface for components that may be used as dates inside <code>ui5-calendar</code>
 *
 * @name sap.ui.webcomponents.main.ICalendarDate
 * @interface
 * @public
 */
const ICalendarDate = "sap.ui.webcomponents.main.ICalendarDate";

/**
 * Interface for components that may be slotted inside a <code>ui5-combobox</code>
 *
 * @name sap.ui.webcomponents.main.IComboBoxItem
 * @interface
 * @public
 */
const IComboBoxItem = "sap.ui.webcomponents.main.IComboBoxItem";

/**
 * Interface for components that may be used inside a <code>ui5-color-palette</code>
 *
 * @name sap.ui.webcomponents.main.IColorPaletteItem
 * @interface
 * @public
 */
const IColorPaletteItem = "sap.ui.webcomponents.main.IColorPaletteItem";

/**
 * Interface for components that represent an icon, usable in numerous higher-order components
 *
 * @name sap.ui.webcomponents.main.IIcon
 * @interface
 * @public
 */
const IIcon = "sap.ui.webcomponents.main.IIcon";

/**
 * Interface for components that represent an input, usable in numerous higher-order components
 *
 * @name sap.ui.webcomponents.main.IInput
 * @interface
 * @public
 */
const IInput = "sap.ui.webcomponents.main.IInput";

/**
 * Interface for components that represent a suggestion item, usable in <code>ui5-input</code>
 *
 * @name sap.ui.webcomponents.main.IInputSuggestionItem
 * @interface
 * @public
 */
const IInputSuggestionItem = "sap.ui.webcomponents.main.IInputSuggestionItem";

/**
 * Interface for components that may be slotted inside a <code>ui5-list</code> as items
 *
 * @name sap.ui.webcomponents.main.IListItem
 * @interface
 * @public
 */
const IListItem = "sap.ui.webcomponents.main.IListItem";

/**
 * Interface for components that may be slotted inside a <code>ui5-multi-combobox</code> as items
 *
 * @name sap.ui.webcomponents.main.IMultiComboBoxItem
 * @interface
 * @public
 */
const IMultiComboBoxItem = "sap.ui.webcomponents.main.IMultiComboBoxItem";

/**
 * Interface for components that may be slotted inside <code>ui5-segmented-button</code> as items
 *
 * @name sap.ui.webcomponents.main.ISegmentedButtonItem
 * @interface
 * @public
 */
const ISegmentedButtonItem = "sap.ui.webcomponents.main.ISegmentedButtonItem";

/**
 * Interface for components that may be slotted inside <code>ui5-select</code> as options
 *
 * @name sap.ui.webcomponents.main.ISelectOption
 * @interface
 * @public
 */
const ISelectOption = "sap.ui.webcomponents.main.ISelectOption";

/**
 * Interface for components that may be slotted inside <code>ui5-tabcontainer</code>
 *
 * @name sap.ui.webcomponents.main.ITab
 * @interface
 * @public
 */
const ITab = "sap.ui.webcomponents.main.ITab";

/**
 * Interface for components that may be slotted inside a <code>ui5-table</code> as rows
 *
 * @name sap.ui.webcomponents.main.ITableRow
 * @interface
 * @public
 */
const ITableRow = "sap.ui.webcomponents.main.ITableRow";

/**
 * Interface for components that may be slotted inside a <code>ui5-table</code> as columns
 *
 * @name sap.ui.webcomponents.main.ITableColumn
 * @interface
 * @public
 */
const ITableColumn = "sap.ui.webcomponents.main.ITableColumn";

/**
 * Interface for components that may be slotted inside a <code>ui5-table-row</code> as cells
 *
 * @name sap.ui.webcomponents.main.ITableCell
 * @interface
 * @public
 */
const ITableCell = "sap.ui.webcomponents.main.ITableCell";

/**
 * Interface for components that represent a token and are usable in components such as <code>ui5-multi-input</code>
 *
 * @name sap.ui.webcomponents.main.IToken
 * @interface
 * @public
 */
const IToken = "sap.ui.webcomponents.main.IToken";

/**
 * Interface for tree items for the purpose of <code>ui5-tree</code>
 *
 * @name sap.ui.webcomponents.main.ITreeItem
 * @interface
 * @public
 */
const ITreeItem = "sap.ui.webcomponents.main.ITreeItem";

export {
	IAvatar,
	IBreadcrumbsItem,
	IButton,
	ICalendarDate,
	IColorPaletteItem,
	IComboBoxItem,
	IIcon,
	IInput,
	IInputSuggestionItem,
	IListItem,
	IMultiComboBoxItem,
	ISegmentedButtonItem,
	ISelectOption,
	ITab,
	ITableCell,
	ITableColumn,
	ITableRow,
	IToken,
	ITreeItem,
};
