import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import ItemNavigation from "@ui5/webcomponents-base/dist/delegate/ItemNavigation.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import Button from "./Button.js";
import type Avatar from "./Avatar.js";
import AvatarGroupType from "./types/AvatarGroupType.js";
type AvatarGroupClickEventDetail = {
    targetRef: HTMLElement;
    overflowButtonClicked: boolean;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * Displays a group of avatars arranged horizontally. It is useful to visually
 * showcase a group of related avatars, such as, project team members or employees.
 *
 * The component allows you to display the avatars in different sizes,
 * depending on your use case.
 *
 * The <code>AvatarGroup</code> component has two group types:
 * <ul>
 * <li><code>Group</code> type: The avatars are displayed as partially overlapped on
 * top of each other and the entire group has one click/tap area.</li>
 * <li><code>Individual</code> type: The avatars are displayed side-by-side and each
 * avatar has its own click/tap area.</li>
 * </ul>
 *
 * <h3>Responsive Behavior</h3>
 *
 * When the available space is less than the width required to display all avatars,
 * an overflow visualization appears as a button placed at the end with the same shape
 * and size as the avatars. The visualization displays the number of avatars that have overflowed
 * and are not currently visible.
 *
 * <h3>Usage</h3>
 *
 * Use the <code>AvatarGroup</code> if:
 * <ul>
 * <li>You want to display a group of avatars.</li>
 * <li>You want to display several avatars which have something in common.</li>
 * </ul>
 *
 * Do not use the <code>AvatarGroup</code> if:
 * <ul>
 * <li>You want to display a single avatar.</li>
 * <li>You want to display a gallery for simple images.</li>
 * <li>You want to use it for other visual content than avatars.</li>
 * </ul>
 *
 * <h3>Keyboard Handling</h3>
 * The component provides advanced keyboard handling.
 * When focused, the user can use the following keyboard
 * shortcuts in order to perform a navigation:
 * <br>
 * - <code>type</code> Individual:
 * <br>
 * <ul>
 * <li>[TAB] - Move focus to the overflow button</li>
 * <li>[LEFT] - Navigate one avatar to the left</li>
 * <li>[RIGHT] - Navigate one avatar to the right</li>
 * <li>[HOME] - Navigate to the first avatar</li>
 * <li>[END] - Navigate to the last avatar</li>
 * <li>[SPACE],[ENTER],[RETURN] - Trigger <code>ui5-click</code> event</li>
 * </ul>
 * <br>
 * - <code>type</code> Group:
 * <br>
 * <ul>
 * <li>[TAB] - Move focus to the next interactive element after the component</li>
 * <li>[SPACE],[ENTER],[RETURN] - Trigger <code>ui5-click</code> event</li>
 * </ul>
 * <br>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.AvatarGroup
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-avatar-group
 * @since 1.0.0-rc.11
 * @public
 */
declare class AvatarGroup extends UI5Element {
    /**
     * Defines the mode of the <code>AvatarGroup</code>.
     * <br><br>
     * Available options are:
     * <ul>
     * <li><code>Group</code></li>
     * <li><code>Individual</code></li>
     * </ul>
     * @type {sap.ui.webc.main.types.AvatarGroupType}
     * @name sap.ui.webc.main.AvatarGroup.prototype.type
     * @defaultValue "Group"
     * @public
     */
    type: `${AvatarGroupType}`;
    /**
     * Defines the aria-haspopup value of the component on:
     * <br><br>
     * <ul>
     * <li> the whole container when <code>type</code> property is <code>Group</code></li>
     * <li> the default "More" overflow button when <code>type</code> is <code>Individual</code></li>
     * </ul>
     * <br><br>
     * @type String
     * @name sap.ui.webc.main.AvatarGroup.prototype.ariaHaspopup
     * @since 1.0.0-rc.15
     * @protected
     */
    ariaHaspopup: string;
    /**
     * @private
     */
    _overflowButtonText: string;
    /**
     * Defines the items of the component. Use the <code>ui5-avatar</code> component as an item.
     * <br><br>
     * <b>Note:</b> The UX guidelines recommends using avatars with "Circle" shape.
     * Moreover, if you use avatars with "Square" shape, there will be visual inconsistency
     * as the built-in overflow action has "Circle" shape.
     * @type {sap.ui.webc.main.IAvatar[]}
     * @name sap.ui.webc.main.AvatarGroup.prototype.default
     * @slot items
     * @public
     */
    items: Array<Avatar>;
    /**
     * Defines the overflow button of the component.
     * <b>Note:</b> We recommend using the <code>ui5-button</code> component.
     * <br><br>
     * <b>Note:</b> If this slot is not used, the component will
     * display the built-in overflow button.
     * @type {HTMLElement}
     * @name sap.ui.webc.main.AvatarGroup.prototype.overflowButton
     * @slot overflowButton
     * @public
     * @since 1.0.0-rc.13
     */
    overflowButton: Array<Button>;
    static i18nBundle: I18nBundle;
    _onResizeHandler: () => void;
    _colorIndex: number;
    _hiddenItems: number;
    _itemNavigation: ItemNavigation;
    constructor();
    static onDefine(): Promise<void>;
    /**
     * Returns an array containing the <code>ui5-avatar</code> instances that are currently not displayed due to lack of space.
     * @readonly
     * @type {HTMLElement[]}
     * @defaultValue []
     * @name sap.ui.webc.main.AvatarGroup.prototype.hiddenItems
     * @public
     */
    get hiddenItems(): Avatar[];
    /**
     * Returns an array containing the <code>AvatarColorScheme</code> values that correspond to the avatars in the component.
     * @readonly
     * @type {sap.ui.webc.main.types.AvatarColorScheme[]}
     * @name sap.ui.webc.main.AvatarGroup.prototype.colorScheme
     * @defaultValue []
     * @public
     */
    get colorScheme(): string[];
    get _customOverflowButton(): Button | undefined;
    get _ariaLabelText(): string;
    get _overflowButtonAriaLabelText(): string | undefined;
    get _containerAriaHasPopup(): string | undefined;
    get _overflowButtonAccAttributes(): {
        hasPopup: string | undefined;
    };
    get _role(): "button" | "group";
    get _hiddenStartIndex(): number;
    get _overflowBtnHidden(): boolean;
    get _isGroup(): boolean;
    get _itemsCount(): number;
    get _groupTabIndex(): "0" | "-1";
    get _overflowButton(): Button | null;
    /**
     * Return the effective overflow button width
     * Differences are that when in "Group" type the button is offset and overlaps the avatars
     *
     * 1) In case of "Group", (LTR/RTL aware) button width is qual to second item offset left/right
     * 2) In case of "Individual" group type width is directly taken from button element
     * @private
     */
    get _overflowButtonEffectiveWidth(): number;
    get firstAvatarSize(): "XS" | "S" | "M" | "L" | "XL";
    get classes(): {
        overflowButton: {
            "ui5-avatar-group-overflow-btn": boolean;
            "ui5-avatar-group-overflow-btn-xs": boolean;
            "ui5-avatar-group-overflow-btn-s": boolean;
            "ui5-avatar-group-overflow-btn-m": boolean;
            "ui5-avatar-group-overflow-btn-l": boolean;
            "ui5-avatar-group-overflow-btn-xl": boolean;
        };
    };
    onAfterRendering(): void;
    onBeforeRendering(): void;
    onEnterDOM(): void;
    onExitDOM(): void;
    _onResize(): void;
    _onkeydown(e: KeyboardEvent): void;
    _onkeyup(e: KeyboardEvent): void;
    _fireGroupEvent(targetRef: HTMLElement): void;
    _onClick(e: MouseEvent): void;
    _onUI5Click(e: MouseEvent): void;
    /**
     * Modifies avatars to the needs of avatar group properties. Respects already set size and background color.
     * Set the margins (offsets) based on RTL/LTR.
     * @private
     */
    _prepareAvatars(): void;
    _onfocusin(e: FocusEvent): void;
    /**
     * Returns the total width to item excluding the item width
     * RTL/LTR aware
     * @private
     * @param {HTMLElement} item
     */
    _getWidthToItem(item: HTMLElement): number;
    /**
     * Overflows items that were not able to fit the container
     * @private
     */
    _overflowItems(): void;
    _getNextBackgroundColor(): number;
    _setHiddenItems(hiddenItems: number): void;
    _getAriaHasPopup(): string | undefined;
}
export default AvatarGroup;
export type { AvatarGroupClickEventDetail, };
