import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type { ChangeInfo } from "@ui5/webcomponents-base/dist/UI5Element.js";
import ItemNavigation from "@ui5/webcomponents-base/dist/delegate/ItemNavigation.js";
import type { ITabbable } from "@ui5/webcomponents-base/dist/delegate/ItemNavigation.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import type { ResizeObserverCallback } from "@ui5/webcomponents-base/dist/delegate/ResizeHandler.js";
import BreadcrumbsDesign from "./types/BreadcrumbsDesign.js";
import BreadcrumbsSeparatorStyle from "./types/BreadcrumbsSeparatorStyle.js";
import BreadcrumbsItem from "./BreadcrumbsItem.js";
import Link from "./Link.js";
import type { LinkClickEventDetail } from "./Link.js";
import Label from "./Label.js";
import ResponsivePopover from "./ResponsivePopover.js";
import type { ListSelectionChangeEventDetail } from "./List.js";
import "@ui5/webcomponents-icons/dist/slim-arrow-down.js";
type BreadcrumbsItemClickEventDetail = {
    item: BreadcrumbsItem;
    altKey: boolean;
    ctrlKey: boolean;
    metaKey: boolean;
    shiftKey: boolean;
};
type FocusAdaptor = ITabbable & {
    getlabelWrapper: () => Element | null;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 * Enables users to navigate between items by providing a list of links to previous steps in the user's navigation path.
 * It helps the user to be aware of their location within the application and allows faster navigation.
 * <br><br>
 * The last three steps can be accessed as links directly, while the remaining links prior to them are available
 * in a drop-down menu.
 * <br><br>
 * You can choose the type of separator to be used from a number of predefined options.
 *
 * <h3>Keyboard Handling</h3>
 * The <code>ui5-breadcrumbs</code> provides advanced keyboard handling.
 * <br>
 * <ul>
 * <li>[F4, ALT+UP, ALT+DOWN, SPACE, ENTER] - If the dropdown arrow is focused - opens/closes the drop-down.</li>
 * <li>[SPACE, ENTER] - Activates the focused item and triggers the <code>item-click</code> event.</li>
 * <li>[ESC] - Closes the drop-down.</li>
 * <li>[LEFT] - If the drop-down is closed - navigates one item to the left.</li>
 * <li>[RIGHT] - If the drop-down is closed - navigates one item to the right.</li>
 * <li>[UP] - If the drop-down is open - moves focus to the next item.</li>
 * <li>[DOWN] - If the drop-down is open - moves focus to the previous item.</li>
 * <li>[HOME] - Navigates to the first item.</li>
 * <li>[END] - Navigates to the last item.</li>
 * </ul>
 * <br>
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.Breadcrumbs
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-breadcrumbs
 * @appenddocs sap.ui.webc.main.BreadcrumbsItem
 * @public
 * @since 1.0.0-rc.15
 */
declare class Breadcrumbs extends UI5Element {
    /**
     * Defines the visual indication and behavior of the breadcrumbs.
     * Available options are <code>Standard</code> (by default) and <code>NoCurrentPage</code>.
     * <br><br>
     * <b>Note:</b> The <code>Standard</code> breadcrumbs show the current page as the last item in the trail.
     * The last item contains only plain text and is not a link.
     *
     * @type {sap.ui.webc.main.types.BreadcrumbsDesign}
     * @name sap.ui.webc.main.Breadcrumbs.prototype.design
     * @defaultvalue "Standard"
     * @public
    */
    design: `${BreadcrumbsDesign}`;
    /**
     * Determines the visual style of the separator between the breadcrumb items.
     *
     * <br><br>
     * Available options are:
     * <ul>
     * <li><code>Slash</code></li>
     * <li><code>BackSlash</code></li>
     * <li><code>DoubleBackSlash</code></li>
     * <li><code>DoubleGreaterThan</code></li>
     * <li><code>DoubleSlash</code></li>
     * <li><code>GreaterThan</code></li>
     * </ul>
     *
     * @type {sap.ui.webc.main.types.BreadcrumbsSeparatorStyle}
     * @name sap.ui.webc.main.Breadcrumbs.prototype.separatorStyle
     * @defaultvalue "Slash"
     * @public
     */
    separatorStyle: `${BreadcrumbsSeparatorStyle}`;
    /**
     * Holds the number of items in the overflow.
     *
     * @type {sap.ui.webc.base.types.Integer}
     * @defaultvalue 0
     * @private
     */
    _overflowSize: number;
    /**
     * Defines the component items.
     *
     * <br><br>
     * <b>Note:</b> Use the <code>ui5-breadcrumbs-item</code> component to define the desired items.
     * @type {sap.ui.webc.main.IBreadcrumbsItem[]}
     * @name sap.ui.webc.main.Breadcrumbs.prototype.default
     * @slot items
     * @public
     */
    items: Array<BreadcrumbsItem>;
    _itemNavigation: ItemNavigation;
    _onResizeHandler: ResizeObserverCallback;
    _breadcrumbItemWidths: WeakMap<BreadcrumbsItem, number>;
    _dropdownArrowLinkWidth: number;
    responsivePopover?: ResponsivePopover;
    _labelFocusAdaptor: FocusAdaptor;
    static i18nBundle: I18nBundle;
    constructor();
    onInvalidation(changeInfo: ChangeInfo): void;
    _getItems(): BreadcrumbsItem[];
    onBeforeRendering(): void;
    onAfterRendering(): void;
    onEnterDOM(): void;
    onExitDOM(): void;
    _initItemNavigation(): void;
    /**
     * Obtains the items for navigation via keyboard
     * @private
     */
    _getFocusableItems(): ITabbable[];
    _onfocusin(e: FocusEvent): void;
    _onkeydown(e: KeyboardEvent): void;
    _onkeyup(e: KeyboardEvent): void;
    /**
     * Caches the space required to render the content
     * @private
     */
    _cacheWidths(): void;
    _updateOverflow(): void;
    _getElementWidth(element: HTMLElement): number;
    _getTotalContentWidth(): number;
    _onLinkPress(e: CustomEvent<LinkClickEventDetail>): void;
    _onLabelPress(e: MouseEvent | KeyboardEvent): void;
    _onOverflowListItemSelect(e: CustomEvent<ListSelectionChangeEventDetail>): void;
    _respPopover(): Promise<ResponsivePopover>;
    _toggleRespPopover(): Promise<void>;
    _closeRespPopover(): void;
    _openRespPopover(): Promise<void>;
    _isItemVisible(item: BreadcrumbsItem): string | boolean;
    _hasVisibleContent(item: BreadcrumbsItem): string | boolean;
    _preprocessItems(): void;
    _getItemPositionText(position: number, size: number): string;
    _getItemAccessibleName(item: BreadcrumbsItem, position: number, size: number): string;
    getCurrentLocationLabelWrapper(): HTMLElement | null;
    get _visibleItems(): BreadcrumbsItem[];
    get _endsWithCurrentLocationLabel(): boolean;
    get _currentLocationText(): string;
    get _currentLocationLabel(): Label | null;
    get _isDropdownArrowFocused(): boolean;
    get _isCurrentLocationLabelFocused(): boolean | null;
    /**
     * Returns the maximum allowed count of items in the overflow
     * with respect to the UX requirement to never overflow the last visible item
     */
    get _maxAllowedOverflowSize(): number;
    /**
     * Getter for the interactive element that opens the overflow
     * @private
     */
    get _dropdownArrowLink(): Link;
    /**
     * Getter for the list of abstract breadcrumb items to be rendered as list-items inside the overflow
     */
    get _overflowItemsData(): BreadcrumbsItem[];
    /**
     * Getter for the list of abstract breadcrumb items to be rendered as links outside the overflow
     */
    get _linksData(): BreadcrumbsItem[];
    /**
     * Getter for accessible name of the current location. Includes the position of the current location and the size of the breadcrumbs
     */
    get _currentLocationAccName(): string;
    /**
     * Getter for the list of links corresponding to the abstract breadcrumb items
     */
    get _links(): Link[];
    get _isOverflowEmpty(): boolean;
    get _ariaHasPopup(): "listbox" | undefined;
    get _isPickerOpen(): boolean;
    get _accessibleNameText(): string;
    get _dropdownArrowAccessibleNameText(): string;
    get _cancelButtonText(): string;
    static onDefine(): Promise<void>;
}
export default Breadcrumbs;
export type { BreadcrumbsItemClickEventDetail, };
