import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import type { Timeout } from "@ui5/webcomponents-base/dist/types.js";
import BusyIndicatorSize from "./types/BusyIndicatorSize.js";
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-busy-indicator</code> signals that some operation is going on and that the
 * user must wait. It does not block the current UI screen so other operations could be triggered in parallel.
 * It displays 3 dots and each dot expands and shrinks at a different rate, resulting in a cascading flow of animation.
 *
 * <h3>Usage</h3>
 * For the <code>ui5-busy-indicator</code> you can define the size, the text and whether it is shown or hidden.
 * In order to hide it, use the "active" property.
 * <br><br>
 * In order to show busy state over an HTML element, simply nest the HTML element in a <code>ui5-busy-indicator</code> instance.
 * <br>
 * <b>Note:</b> Since <code>ui5-busy-indicator</code> has <code>display: inline-block;</code> by default and no width of its own,
 * whenever you need to wrap a block-level element, you should set <code>display: block</code> to the busy indicator as well.
 *
 * <h4>When to use:</h4>
 * <ul>
 * <li>The user needs to be able to cancel the operation.</li>
 * <li>Only part of the application or a particular component is affected.</li>
 * </ul>
 *
 * <h4>When not to use:</h4>
 * <ul>
 * <li>The operation takes less than one second.</li>
 * <li>You need to block the screen and prevent the user from starting another activity.</li>
 * <li>Do not show multiple busy indicators at once.</li>
 * </ul>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/BusyIndicator";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.BusyIndicator
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-busy-indicator
 * @public
 * @since 0.12.0
 */
declare class BusyIndicator extends UI5Element {
    /**
     * Defines text to be displayed below the component. It can be used to inform the user of the current operation.
     * @type {string}
     * @name sap.ui.webc.main.BusyIndicator.prototype.text
     * @public
     * @defaultvalue ""
     * @since 1.0.0-rc.7
     */
    text: string;
    /**
     * Defines the size of the component.
     *
     * <br><br>
     * <b>Note:</b>
     *
     * <ul>
     * <li><code>Small</code></li>
     * <li><code>Medium</code></li>
     * <li><code>Large</code></li>
     * </ul>
     *
     * @type {sap.ui.webc.main.types.BusyIndicatorSize}
     * @name sap.ui.webc.main.BusyIndicator.prototype.size
     * @defaultvalue "Medium"
     * @public
     */
    size: `${BusyIndicatorSize}`;
    /**
     * Defines if the busy indicator is visible on the screen. By default it is not.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.BusyIndicator.prototype.active
     * @defaultvalue false
     * @public
     */
    active: boolean;
    /**
     * Defines the delay in milliseconds, after which the busy indicator will be visible on the screen.
     *
     * @type {sap.ui.webc.base.types.Integer}
     * @name sap.ui.webc.main.BusyIndicator.prototype.delay
     * @defaultValue 1000
     * @public
     */
    delay: number;
    /**
     * Defines if the component is currently in busy state.
     * @private
     */
    _isBusy: boolean;
    /**
     * Determines the content over which the component will appear.
     *
     * @type {Node[]}
     * @name sap.ui.webc.main.BusyIndicator.prototype.default
     * @slot
     * @public
     */
    _keydownHandler: (e: KeyboardEvent) => void;
    _preventEventHandler: (e: KeyboardEvent) => void;
    _busyTimeoutId?: Timeout;
    focusForward?: boolean;
    static i18nBundle: I18nBundle;
    constructor();
    onEnterDOM(): void;
    onExitDOM(): void;
    static onDefine(): Promise<void>;
    get ariaTitle(): string;
    get labelId(): string | undefined;
    get classes(): {
        root: {
            "ui5-busy-indicator-root": boolean;
        };
    };
    onBeforeRendering(): void;
    _handleKeydown(e: KeyboardEvent): void;
    _preventEvent(e: KeyboardEvent): void;
    /**
     * Moves the focus to busy area when coming with SHIFT + TAB
     */
    _redirectFocus(e: FocusEvent): void;
}
export default BusyIndicator;
