import type CalendarDateComponentT from "./CalendarDate.js";
import CalendarPart from "./CalendarPart.js";
import type { DayPickerChangeEventDetail } from "./DayPicker.js";
import type { MonthPickerChangeEventDetail } from "./MonthPicker.js";
import type { YearPickerChangeEventDetail } from "./YearPicker.js";
import CalendarSelectionMode from "./types/CalendarSelectionMode.js";
import CalendarPickersMode from "./types/CalendarPickersMode.js";
import "@ui5/webcomponents-localization/dist/features/calendar/Gregorian.js";
interface ICalendarPicker {
    _showPreviousPage: () => void;
    _showNextPage: () => void;
    _hasPreviousPage: () => boolean;
    _hasNextPage: () => boolean;
    _autoFocus?: boolean;
    _firstYear?: number;
    _lastYear?: number;
}
type CalendarSelectedDatesChangeEventDetail = {
    values: Array<string>;
    dates: Array<number>;
    timestamp: number | undefined;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-calendar</code> component allows users to select one or more dates.
 * <br><br>
 * Currently selected dates are represented with instances of <code>ui5-date</code> as
 * children of the <code>ui5-calendar</code>. The value property of each <code>ui5-date</code> must be a
 * date string, correctly formatted according to the <code>ui5-calendar</code>'s <code>formatPattern</code> property.
 * Whenever the user changes the date selection, <code>ui5-calendar</code> will automatically create/remove instances
 * of <code>ui5-date</code> in itself, unless you prevent this behavior by calling <code>preventDefault()</code> for the
 * <code>selected-dates-change</code> event. This is useful if you want to control the selected dates externally.
 * <br><br>
 *
 * <h3>Usage</h3>
 *
 * The user can navigate to a particular date by:
 * <br>
 * <ul>
 * <li>Pressing over a month inside the months view</li>
 * <li>Pressing over an year inside the years view</li>
 * </ul>
 * <br>
 * The user can confirm a date selection by pressing over a date inside the days view.
 * <br><br>
 *
 * <h3>Keyboard Handling</h3>
 * The <code>ui5-calendar</code> provides advanced keyboard handling.
 * When a picker is showed and focused the user can use the following keyboard
 * shortcuts in order to perform a navigation:
 * <br>
 * - Day picker: <br>
 * <ul>
 * <li>[F4] - Shows month picker</li>
 * <li>[SHIFT] + [F4] - Shows year picker</li>
 * <li>[PAGEUP] - Navigate to the previous month</li>
 * <li>[PAGEDOWN] - Navigate to the next month</li>
 * <li>[SHIFT] + [PAGEUP] - Navigate to the previous year</li>
 * <li>[SHIFT] + [PAGEDOWN] - Navigate to the next year</li>
 * <li>[CTRL] + [SHIFT] + [PAGEUP] - Navigate ten years backwards</li>
 * <li>[CTRL] + [SHIFT] + [PAGEDOWN] - Navigate ten years forwards</li>
 * <li>[HOME] - Navigate to the first day of the week</li>
 * <li>[END] - Navigate to the last day of the week</li>
 * <li>[CTRL] + [HOME] - Navigate to the first day of the month</li>
 * <li>[CTRL] + [END] - Navigate to the last day of the month</li>
 * </ul>
 * <br>
 * - Month picker: <br>
 * <ul>
 * <li>[PAGEUP] - Navigate to the previous year</li>
 * <li>[PAGEDOWN] - Navigate to the next year</li>
 * <li>[HOME] - Navigate to the first month of the current row</li>
 * <li>[END] - Navigate to the last month of the current row</li>
 * <li>[CTRL] + [HOME] - Navigate to the first month of the current year</li>
 * <li>[CTRL] + [END] - Navigate to the last month of the year</li>
 * </ul>
 * <br>
 * - Year picker: <br>
 * <ul>
 * <li>[PAGEUP] - Navigate to the previous year range</li>
 * <li>[PAGEDOWN] - Navigate the next year range</li>
 * <li>[HOME] - Navigate to the first year of the current row</li>
 * <li>[END] - Navigate to the last year of the current row</li>
 * <li>[CTRL] + [HOME] - Navigate to the first year of the current year range</li>
 * <li>[CTRL] + [END] - Navigate to the last year of the current year range</li>
 * </ul>
 * <br>
 *
 * <h4>Fast Navigation</h4>
 * This component provides a build in fast navigation group which can be used via <code>F6 / Shift + F6</code> or <code> Ctrl + Alt(Option) + Down /  Ctrl + Alt(Option) + Up</code>.
 * In order to use this functionality, you need to import the following module:
 * <code>import "@ui5/webcomponents-base/dist/features/F6Navigation.js"</code>
 * <br><br>
 *
* <h3>Calendar types</h3>
 * The component supports several calendar types - Gregorian, Buddhist, Islamic, Japanese and Persian.
 * By default the Gregorian Calendar is used. In order to use the Buddhist, Islamic, Japanese or Persian calendar,
 * you need to set the <code>primaryCalendarType</code> property and import one or more of the following modules:
 * <br><br>
 *
 * <code>import "@ui5/webcomponents-localization/dist/features/calendar/Buddhist.js";</code>
 * <br>
 * <code>import "@ui5/webcomponents-localization/dist/features/calendar/Islamic.js";</code>
 * <br>
 * <code>import "@ui5/webcomponents-localization/dist/features/calendar/Japanese.js";</code>
 * <br>
 * <code>import "@ui5/webcomponents-localization/dist/features/calendar/Persian.js";</code>
 * <br><br>
 *
 * Or, you can use the global configuration and set the <code>calendarType</code> key:
 * <br>
 * <code>
 * &lt;script data-id="sap-ui-config" type="application/json"&gt;
 * {
 *	"calendarType": "Japanese"
 * }
 * &lt;/script&gt;
 * </code>
 *
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/Calendar";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.Calendar
 * @extends sap.ui.webc.main.CalendarPart
 * @tagname ui5-calendar
 * @appenddocs sap.ui.webc.main.CalendarDate
 * @public
 * @since 1.0.0-rc.11
 */
declare class Calendar extends CalendarPart {
    /**
     * Defines the type of selection used in the calendar component.
     * Accepted property values are:<br>
     * <ul>
     * <li><code>CalendarSelectionMode.Single</code> - enables a single date selection.(default value)</li>
     * <li><code>CalendarSelectionMode.Range</code> - enables selection of a date range.</li>
     * <li><code>CalendarSelectionMode.Multiple</code> - enables selection of multiple dates.</li>
     * </ul>
     * @type {sap.ui.webc.main.types.CalendarSelectionMode}
     * @name sap.ui.webc.main.Calendar.prototype.selectionMode
     * @defaultvalue "Single"
     * @public
     */
    selectionMode: `${CalendarSelectionMode}`;
    /**
     * Defines the visibility of the week numbers column.
     * <br><br>
     *
     * <b>Note:</b> For calendars other than Gregorian,
     * the week numbers are not displayed regardless of what is set.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.Calendar.prototype.hideWeekNumbers
     * @defaultvalue false
     * @public
     */
    hideWeekNumbers: boolean;
    /**
     * Which picker is currently visible to the user: day/month/year
     */
    _currentPicker: string;
    _previousButtonDisabled: boolean;
    _nextButtonDisabled: boolean;
    _headerMonthButtonText: string;
    _headerYearButtonText: string;
    _headerYearButtonTextSecType: string;
    _pickersMode: CalendarPickersMode;
    /**
     * Defines the selected date or dates (depending on the <code>selectionMode</code> property)
     * for this calendar as instances of <code>ui5-date</code>.
     *
     * @type {sap.ui.webc.main.ICalendarDate[]}
     * @name sap.ui.webc.main.Calendar.prototype.default
     * @slot dates
     * @public
     */
    dates: Array<CalendarDateComponentT>;
    /**
     * @private
     */
    get _selectedDatesTimestamps(): Array<number>;
    /**
     * @private
     */
    _setSelectedDates(selectedDates: Array<number>): void;
    /**
     * Makes sure that _currentPicker is always set to a value, allowed by _pickersMode
     */
    _normalizeCurrentPicker(): void;
    onBeforeRendering(): void;
    onAfterRendering(): Promise<void>;
    /**
     * The user clicked the "month" button in the header
     */
    onHeaderShowMonthPress(e: CustomEvent): void;
    /**
     * The user clicked the "year" button in the header
     */
    onHeaderShowYearPress(e: CustomEvent): void;
    get _currentPickerDOM(): ICalendarPicker;
    /**
     * The year clicked the "Previous" button in the header
     */
    onHeaderPreviousPress(): void;
    /**
     * The year clicked the "Next" button in the header
     */
    onHeaderNextPress(): void;
    _setSecondaryCalendarTypeButtonText(): void;
    get secondaryCalendarTypeButtonText(): {
        yearButtonText: string;
        monthButtonText: any;
        monthButtonInfo: any;
    } | undefined;
    /**
     * The month button is hidden when the month picker or year picker is shown
     * @returns {boolean}
     * @private
     */
    get _isHeaderMonthButtonHidden(): boolean;
    get _isDayPickerHidden(): boolean;
    get _isMonthPickerHidden(): boolean;
    get _isYearPickerHidden(): boolean;
    _fireEventAndUpdateSelectedDates(selectedDates: Array<number>): void;
    onSelectedDatesChange(e: CustomEvent<DayPickerChangeEventDetail>): void;
    onSelectedMonthChange(e: CustomEvent<MonthPickerChangeEventDetail>): void;
    onSelectedYearChange(e: CustomEvent<YearPickerChangeEventDetail>): void;
    onNavigate(e: CustomEvent): void;
    _onkeydown(e: KeyboardEvent): void;
    /**
     * Returns an array of UTC timestamps, representing the selected dates.
     * @protected
     * @deprecated
     */
    get selectedDates(): Array<number>;
    /**
     * Creates instances of <code>ui5-date</code> inside this <code>ui5-calendar</code> with values, equal to the provided UTC timestamps
     * @protected
     * @deprecated
     * @param { Array<number> } selectedDates Array of UTC timestamps
     */
    set selectedDates(selectedDates: Array<number>);
}
export default Calendar;
export type { ICalendarPicker, CalendarSelectedDatesChangeEventDetail, };
