import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import ScrollEnablement from "@ui5/webcomponents-base/dist/delegate/ScrollEnablement.js";
import type { ScrollEnablementEventListenerParam } from "@ui5/webcomponents-base/dist/delegate/ScrollEnablement.js";
import type { ResizeObserverCallback } from "@ui5/webcomponents-base/dist/delegate/ResizeHandler.js";
import CarouselArrowsPlacement from "./types/CarouselArrowsPlacement.js";
import CarouselPageIndicatorStyle from "./types/CarouselPageIndicatorStyle.js";
import BackgroundDesign from "./types/BackgroundDesign.js";
import BorderDesign from "./types/BorderDesign.js";
import "@ui5/webcomponents-icons/dist/slim-arrow-left.js";
import "@ui5/webcomponents-icons/dist/slim-arrow-right.js";
type CarouselNavigateEventDetail = {
    selectedIndex: number;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 * The Carousel allows the user to browse through a set of items.
 * The component is mostly used for showing a gallery of images, but can hold any other HTML element.
 * <br>
 * There are several ways to perform navigation:
 * <ul>
 * <li>on desktop - the user can navigate using the navigation arrows or with keyboard shorcuts.</li>
 * <li>on mobile - the user can use swipe gestures.</li>
 * </ul>
 *
 * <h3>Usage</h3>
 *
 * <h4>When to use:</h4>
 *
 * <ul>
 * <li>The items you want to display are very different from each other.</li>
 * <li>You want to display the items one after the other.</li>
 * </ul>
 *
 * <h4>When not to use:</h4>
 *
 * <ul>
 * <li>The items you want to display need to be visible at the same time.</li>
 * <li>The items you want to display are uniform and very similar.</li>
 * </ul>
 *
 * <h3>Keyboard Handling</h3>
 *
 * <h4>Basic Navigation</h4>
 * When the <code>ui5-carousel</code> is focused the user can navigate between the items
 * with the following keyboard shortcuts:
 * <br>
 * <ul>
 * <li>[UP/DOWN] - Navigates to previous and next item</li>
 * <li>[LEFT/RIGHT] - Navigates to previous and next item</li>
 * </ul>
 *
 * <h3>Fast Navigation</h3>
 * This component provides a build in fast navigation group which can be used via <code>F6 / Shift + F6</code> or <code> Ctrl + Alt(Option) + Down /  Ctrl + Alt(Option) + Up</code>.
 * In order to use this functionality, you need to import the following module:
 * <code>import "@ui5/webcomponents-base/dist/features/F6Navigation.js"</code>
 * <br><br>
 *
 * <h3>CSS Shadow Parts</h3>
 *
 * <ui5-link target="_blank" href="https://developer.mozilla.org/en-US/docs/Web/CSS/::part">CSS Shadow Parts</ui5-link> allow developers to style elements inside the Shadow DOM.
 * <br>
 * The <code>ui5-carousel</code> exposes the following CSS Shadow Parts:
 * <ul>
 * <li>content - Used to style the content of the component</li>
 * </ul>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/Carousel.js";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.Carousel
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-carousel
 * @since 1.0.0-rc.6
 * @public
 */
declare class Carousel extends UI5Element {
    /**
     * Defines whether the carousel should loop, i.e show the first page after the last page is reached and vice versa.
     * @type {boolean}
     * @name sap.ui.webc.main.Carousel.prototype.cyclic
     * @defaultvalue false
     * @public
     */
    cyclic: boolean;
    /**
     * Defines the number of items per page on small size (up to 640px). One item per page shown by default.
     * @type {sap.ui.webc.base.types.Integer}
     * @name sap.ui.webc.main.Carousel.prototype.itemsPerPageS
     * @defaultvalue 1
     * @public
     */
    itemsPerPageS: number;
    /**
     * Defines the number of items per page on medium size (from 640px to 1024px). One item per page shown by default.
     * @type {sap.ui.webc.base.types.Integer}
     * @name sap.ui.webc.main.Carousel.prototype.itemsPerPageM
     * @defaultvalue 1
     * @public
     */
    itemsPerPageM: number;
    /**
     * Defines the number of items per page on large size (more than 1024px). One item per page shown by default.
     * @type {sap.ui.webc.base.types.Integer}
     * @name sap.ui.webc.main.Carousel.prototype.itemsPerPageL
     * @defaultvalue 1
     * @public
     */
    itemsPerPageL: number;
    /**
     * Defines the visibility of the navigation arrows.
     * If set to true the navigation arrows will be hidden.
     * <br><br>
     * <b>Note:</b> The navigation arrows are never displayed on touch devices.
     * In this case, the user can swipe to navigate through the items.
     * @type {boolean}
     * @name sap.ui.webc.main.Carousel.prototype.hideNavigationArrows
     * @since 1.0.0-rc.15
     * @defaultvalue false
     * @public
     */
    hideNavigationArrows: boolean;
    /**
     * Defines the visibility of the page indicator.
     * If set to true the page indicator will be hidden.
     * @type {boolean}
     * @name sap.ui.webc.main.Carousel.prototype.hidePageIndicator
     * @since 1.0.0-rc.15
     * @defaultvalue false
     * @public
     */
    hidePageIndicator: boolean;
    /**
     * Defines the style of the page indicator.
     * Available options are:
     * <ul>
     * <li><code>Default</code> - The page indicator will be visualized as dots if there are fewer than 9 pages. If there are more pages, the page indicator will switch to displaying the current page and the total number of pages. (e.g. X of Y)</li>
     * <li><code>Numeric</code> - The page indicator will display the current page and the total number of pages. (e.g. X of Y)</li>
     * </ul>
     * @type {sap.ui.webc.main.types.CarouselPageIndicatorStyle}
     * @name sap.ui.webc.main.Carousel.prototype.pageIndicatorStyle
     * @since 1.10
     * @defaultvalue "Default"
     * @public
     */
    pageIndicatorStyle: `${CarouselPageIndicatorStyle}`;
    /**
     * Defines the carousel's background design.
     * @type {sap.ui.webc.main.types.BackgroundDesign}
     * @name sap.ui.webc.main.Carousel.prototype.backgroundDesign
     * @since 1.14
     * @defaultvalue "Translucent"
     * @public
     */
    backgroundDesign: BackgroundDesign;
    /**
     * Defines the page indicator background design.
     * @type {sap.ui.webc.main.types.BackgroundDesign}
     * @name sap.ui.webc.main.Carousel.prototype.pageIndicatorBackgroundDesign
     * @since 1.14
     * @defaultvalue "Solid"
     * @public
     */
    pageIndicatorBackgroundDesign: BackgroundDesign;
    /**
     * Defines the page indicator border design.
     * @type {sap.ui.webc.main.types.BorderDesign}
     * @name sap.ui.webc.main.Carousel.prototype.pageIndicatorBorderDesign
     * @since 1.14
     * @defaultvalue "Solid"
     * @public
     */
    pageIndicatorBorderDesign: BorderDesign;
    /**
     * Defines the index of the initially selected item.
     * @type {sap.ui.webc.base.types.Integer}
     * @name sap.ui.webc.main.Carousel.prototype._selectedIndex
     * @defaultvalue 0
     * @private
     */
    _selectedIndex: number;
    /**
     * Defines the position of arrows.
     * <br><br>
     * Available options are:
     * <ul>
     * <li><code>Content</code></li>
     * <li><code>Navigation</code></li>
     * </ul>
     * <br>
     * When set to "Content", the arrows are placed on the sides of the current page.
     * <br>
     * When set to "Navigation", the arrows are placed on the sides of the page indicator.
     * @type {sap.ui.webc.main.types.CarouselArrowsPlacement}
     * @name sap.ui.webc.main.Carousel.prototype.arrowsPlacement
     * @defaultvalue "Content"
     * @public
     */
    arrowsPlacement: `${CarouselArrowsPlacement}`;
    /**
     * Defines the carousel width in pixels.
     * @private
     */
    _width?: number;
    /**
     * Defines the carousel item width in pixels.
     * @private
     */
    _itemWidth?: number;
    /**
     * If set to true navigation arrows are shown.
     * @private
     * @since 1.0.0-rc.15
     */
    _visibleNavigationArrows: boolean;
    _scrollEnablement: ScrollEnablement;
    _onResizeBound: ResizeObserverCallback;
    _resizing: boolean;
    _lastFocusedElements: Array<HTMLElement>;
    _orderOfLastFocusedPages: Array<number>;
    /**
     * Defines the content of the component.
     * @type {HTMLElement[]}
     * @slot
     * @name sap.ui.webc.main.Carousel.prototype.default
     * @public
     */
    content: Array<HTMLElement>;
    static i18nBundle: I18nBundle;
    static get pageTypeLimit(): number;
    constructor();
    onBeforeRendering(): void;
    onAfterRendering(): void;
    onEnterDOM(): void;
    onExitDOM(): void;
    validateSelectedIndex(): void;
    _onResize(): void;
    _updateScrolling(e: ScrollEnablementEventListenerParam): void;
    _onkeydown(e: KeyboardEvent): Promise<void>;
    _onfocusin(e: FocusEvent): void;
    _onmouseout(): void;
    _onmouseover(): void;
    _handleF7Key(e: KeyboardEvent): void;
    get _backgroundDesign(): string;
    get _getLastFocusedActivePageIndex(): number;
    navigateLeft(): void;
    navigateRight(): void;
    _navButtonClick(e: MouseEvent): void;
    /**
     * Changes the currently displayed page.
     * @param {Integer} itemIndex The index of the target page
     * @since 1.0.0-rc.15
     * @method
     * @name sap.ui.webc.main.Carousel#navigateTo
     * @public
     */
    navigateTo(itemIndex: number): void;
    /**
     * Assuming that all items have the same width
     * @private
     */
    get items(): {
        id: string;
        item: HTMLElement;
        tabIndex: string;
        posinset: string;
        setsize: string;
        styles: {
            width: string;
        };
        classes: string;
    }[];
    get effectiveItemsPerPage(): number;
    isItemInViewport(index: number): boolean;
    isIndexInRange(index: number): boolean;
    /**
     * @private
     */
    get renderNavigation(): boolean;
    get hasManyPages(): boolean;
    get styles(): {
        content: {
            transform: string;
        };
    };
    get classes(): {
        viewport: {
            "ui5-carousel-viewport": boolean;
            "ui5-carousel-viewport--single": boolean;
        };
        content: {
            "ui5-carousel-content": boolean;
            "ui5-carousel-content-no-animation": boolean;
            "ui5-carousel-content-has-navigation": boolean;
            "ui5-carousel-content-has-navigation-and-buttons": boolean;
        };
        navigation: {
            [x: string]: boolean;
            "ui5-carousel-navigation-wrapper": boolean;
            "ui5-carousel-navigation-with-buttons": boolean;
        };
        navPrevButton: {
            "ui5-carousel-navigation-button--hidden": boolean;
        };
        navNextButton: {
            "ui5-carousel-navigation-button--hidden": boolean;
        };
    };
    get pagesCount(): number;
    get isPageTypeDots(): boolean;
    get dots(): {
        active: boolean;
        ariaLabel: string;
    }[];
    get showArrows(): {
        content: boolean;
        navigation: boolean;
    };
    get hasPrev(): boolean;
    get hasNext(): boolean;
    get suppressAnimation(): boolean;
    get _isRTL(): boolean;
    get selectedIndexToShow(): number;
    get ofText(): string;
    get ariaActiveDescendant(): string | undefined;
    get nextPageText(): string;
    get previousPageText(): string;
    /**
     * The indices of the currently visible items of the component.
     * @public
     * @readonly
     * @since 1.0.0-rc.15
     * @returns {Integer[]} the indices of the visible items
     */
    get visibleItemsIndices(): number[];
    static onDefine(): Promise<void>;
}
export default Carousel;
export type { CarouselNavigateEventDetail, };
