import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import ItemNavigation from "@ui5/webcomponents-base/dist/delegate/ItemNavigation.js";
import ColorPaletteItem from "./ColorPaletteItem.js";
import Button from "./Button.js";
import type Dialog from "./Dialog.js";
import type ColorPaletteMoreColors from "./features/ColorPaletteMoreColors.js";
import type ColorPicker from "./ColorPicker.js";
type ColorPaletteNavigationItem = ColorPaletteItem | Button;
type ColorPaletteItemClickEventDetail = {
    color: string;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 * The <code>ui5-color-palette</code> provides the users with a range of predefined colors. The colors are fixed and do not change with the theme.
 *
 * <h3>Usage</h3>
 *
 * The <code>ui5-color-palette</code> is meant for users that need to select a color from a predefined set.
 * To define the colors, use the <code>ui5-color-palette-item</code> component inside the default slot of the <code>ui5-color-palette</code>.
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/ColorPalette.js";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.ColorPalette
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-color-palette
 * @since 1.0.0-rc.12
 * @appenddocs sap.ui.webc.main.ColorPaletteItem
 * @public
 */
declare class ColorPalette extends UI5Element {
    /**
     * Defines whether the user can see the last used colors in the bottom of the component
     * @type {boolean}
     * @private
     * @since 1.0.0-rc.15
     */
    showRecentColors: boolean;
    /**
     * Defines whether the user can choose a custom color from a color picker
     * <b>Note:</b> In order to use this property you need to import the following module: <code>"@ui5/webcomponents/dist/features/ColorPaletteMoreColors.js"</code>
     * @type {boolean}
     * @private
     * @since 1.0.0-rc.15
     */
    showMoreColors: boolean;
    /**
     * Defines whether the user can choose the default color from a button.
     * @type {boolean}
     * @defaultvalue false
     * @private
     * @since 1.0.0-rc.16
     */
    showDefaultColor: boolean;
    /**
     * Defines the default color of the color palette
     * <b>Note:</b> The default color should be a part of the ColorPalette colors</code>
     * @type {sap.ui.webc.base.types.CSSColor}
     * @private
     * @since 1.0.0-rc.16
     */
    defaultColor?: string;
    /**
     * Defines the selected color.
     * @type {sap.ui.webc.base.types.CSSColor}
     * @private
     */
    _selectedColor?: string;
    /**
     * Defines if the palette is in Popup or Embeded mode.
     * @type {sap.ui.webc.base.types.CSSColor}
     * @private
     */
    popupMode: boolean;
    /**
     * Defines the <code>ui5-color-palette-item</code> elements.
     * @type {sap.ui.webc.main.IColorPaletteItem[]}
     * @name sap.ui.webc.main.ColorPalette.prototype.default
     * @slot colors
     * @public
     */
    colors: Array<ColorPaletteItem>;
    _itemNavigation: ItemNavigation;
    _itemNavigationRecentColors: ItemNavigation;
    _recentColors: Array<string>;
    moreColorsFeature?: ColorPaletteMoreColors;
    static i18nBundle: I18nBundle;
    static onDefine(): Promise<void>;
    constructor();
    onBeforeRendering(): void;
    selectColor(item: ColorPaletteItem): void;
    _setColor(color: string): void;
    _onclick(e: MouseEvent): void;
    _onkeyup(e: KeyboardEvent): void;
    _onkeydown(e: KeyboardEvent): void;
    _onDefaultColorKeyDown(e: KeyboardEvent): void;
    _onMoreColorsKeyDown(e: KeyboardEvent): void;
    _onColorContainerKeyDown(e: KeyboardEvent): void;
    _onRecentColorsContainerKeyDown(e: KeyboardEvent): void;
    focusColorElement(element: ColorPaletteNavigationItem, itemNavigation: ItemNavigation): void;
    _chooseCustomColor(): Promise<void>;
    _closeDialog(): Promise<void>;
    _openMoreColorsDialog(): Promise<void>;
    _onDefaultColorClick(): void;
    /**
     * Returns the selected color.
     */
    get selectedColor(): string | undefined;
    get displayedColors(): ColorPaletteItem[];
    get colorContainerLabel(): string;
    get colorPaleteMoreColorsText(): string;
    get _showMoreColors(): false | ColorPaletteMoreColors | undefined;
    get rowSize(): number;
    get hasRecentColors(): string | false;
    get recentColors(): string[];
    get recentColorsElements(): Array<ColorPaletteItem>;
    get colorPaletteNavigationElements(): ColorPaletteNavigationItem[];
    get classes(): {
        colorPaletteRoot: {
            "ui5-cp-root": boolean;
            "ui5-cp-root-phone": boolean;
        };
    };
    _getDialog(): Promise<Dialog>;
    getColorPicker(): Promise<ColorPicker>;
}
export default ColorPalette;
export type { ColorPaletteItemClickEventDetail };
