import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import ResponsivePopover from "./ResponsivePopover.js";
import ColorPalette from "./ColorPalette.js";
import type { ColorPaletteItemClickEventDetail } from "./ColorPalette.js";
import type ColorPaletteItem from "./ColorPaletteItem.js";
type ColorPalettePopoverItemClickEventDetail = ColorPaletteItemClickEventDetail;
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 * Represents a predefined range of colors for easier selection.
 *
 * Overview
 * The ColorPalettePopover provides the users with a slot to predefine colors.
 *
 * You can customize them with the use of the colors property. You can specify a defaultColor and display a "Default color" button for the user to choose directly.
 * You can display a "More colors..." button that opens an additional color picker for the user to choose specific colors that are not present in the predefined range.
 *
 * <h3>Usage</h3>
 *
 * The palette is intended for users, who don't want to check and remember the different values of the colors and spend large amount of time to configure the right color through the color picker.
 *
 * For the <code>ui5-color-palette-popover</code>
 * <h3>ES6 Module Import</h3>
 *
 * <code>import @ui5/webcomponents/dist/ColorPalettePopover.js";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.ColorPalettePopover
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-color-palette-popover
 * @public
 * @since 1.0.0-rc.16
 */
declare class ColorPalettePopover extends UI5Element {
    /**
     * Defines whether the user can see the last used colors in the bottom of the component
     * @type {boolean}
     * @name sap.ui.webc.main.ColorPalettePopover.prototype.showRecentColors
     * @defaultvalue false
     * @public
     */
    showRecentColors: boolean;
    /**
     * Defines whether the user can choose a custom color from a component.
     * <b>Note:</b> In order to use this property you need to import the following module: <code>"@ui5/webcomponents/dist/features/ColorPaletteMoreColors.js"</code>
     * @type {boolean}
     * @name sap.ui.webc.main.ColorPalettePopover.prototype.showMoreColors
     * @defaultvalue false
     * @public
     */
    showMoreColors: boolean;
    /**
     * Defines whether the user can choose the default color from a button.
     * @type {boolean}
     * @name sap.ui.webc.main.ColorPalettePopover.prototype.showDefaultColor
     * @defaultvalue false
     * @public
     */
    showDefaultColor: boolean;
    /**
     * Defines the default color of the component.
     * <b>Note:</b> The default color should be a part of the ColorPalette colors</code>
     * @type {sap.ui.webc.base.types.CSSColor}
     * @name sap.ui.webc.main.ColorPalettePopover.prototype.defaultColor
     * @public
     */
    defaultColor?: string;
    /**
     * Defines the content of the component.
     * @type {sap.ui.webc.main.IColorPaletteItem[]}
     * @name sap.ui.webc.main.ColorPalettePopover.prototype.default
     * @slot colors
     * @public
     */
    colors: Array<ColorPaletteItem>;
    static i18nBundle: I18nBundle;
    responsivePopover?: ResponsivePopover;
    static onDefine(): Promise<void>;
    constructor();
    _respPopover(): ResponsivePopover;
    _colorPalette(): ColorPalette;
    /**
     * Shows the ColorPalettePopover.
     * @param {HTMLElement} opener the element that the popover is shown at
     * @public
     * @method
     * @name sap.ui.webc.main.ColorPalettePopover#showAt
     * @since 1.1.1
     */
    showAt(opener: HTMLElement): void;
    /**
     * Shows the ColorPalettePopover.
     * <b>Note:</b> The method is deprecated and will be removed in future, use <code>showAt</code> instead.
     * @param {HTMLElement} opener the element that the popover is shown at
     * @public
     * @method
     * @name sap.ui.webc.main.ColorPalettePopover#openPopover
     * @since 1.0.0-rc.16
     * @deprecated The method is deprecated in favour of <code>showAt</code>.
     */
    openPopover(opener: HTMLElement): void;
    _openPopover(opener: HTMLElement): void;
    closePopover(): void;
    onSelectedColor(e: CustomEvent<ColorPaletteItemClickEventDetail>): void;
    /**
     * Returns if the component is opened.
     *
     * @protected
     * @since 1.0.0-rc.16
     * @returns {boolean}
     */
    isOpen(): boolean;
    get colorPaletteColors(): ColorPaletteItem[];
    get _colorPaletteTitle(): string;
    get _cancelButtonLabel(): string;
}
export default ColorPalettePopover;
export type { ColorPalettePopoverItemClickEventDetail };
