import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import type { ColorRGB } from "@ui5/webcomponents-base/dist/util/ColorConversion.js";
type ColorCoordinates = {
    x: number;
    y: number;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 * The <code>ui5-color-picker</code> allows users to choose any color and provides different input options for selecting colors.
 *
 * <h3>Usage</h3>
 *
 * <h4>When to use:</h4
 * Use the color picker if:
 * <ul>
 * <li> users need to select any color freely.</li>
 * </ul>
 *
 * <h4>When not to use:</h4>
 * <ul>
 * <li> Users need to select one color from a predefined set of colors. Use the ColorPalette component instead.</li>
 * </ul>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/ColorPicker.js";</code>
 *
 * @constructor
 * @author SAP SE
 * @since 1.0.0-rc.12
 * @alias sap.ui.webc.main.ColorPicker
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-color-picker
 * @public
 */
declare class ColorPicker extends UI5Element {
    /**
     * Defines the currently selected color of the component.
     * <br><br>
     * <b>Note</b>: use HEX, RGB, RGBA, HSV formats or a CSS color name when modifying this property.
     * @type {sap.ui.webc.base.types.CSSColor}
     * @name sap.ui.webc.main.ColorPicker.prototype.color
     * @public
     */
    color: string;
    /**
     * Defines the HEX code of the currently selected color
     * *Note*: If Alpha(transperancy) is set it is not included in this property. Use <code>color</code> property.
     * @type {string}
     * @private
     */
    hex: string;
    /**
     * Defines the current main color which is selected via the hue slider and is shown in the main color square.
     * @type {string}
     * @private
     */
    _mainColor: ColorRGB;
    /**
     * Defines the currenty selected color from the main color section.
     * @private
     */
    _color: ColorRGB;
    /**
     * @private
     */
    _selectedCoordinates: ColorCoordinates;
    /**
     * @private
     */
    _alpha: number;
    /**
     * @private
     */
    _hue: number;
    /**
     * @private
     */
    _isSelectedColorChanged: boolean;
    /**
     * @private
     */
    _isHueValueChanged: boolean;
    /**
     * @private
     */
    _wrongHEX: boolean;
    selectedHue: number;
    mouseDown: boolean;
    mouseIn: boolean;
    static i18nBundle: I18nBundle;
    static onDefine(): Promise<void>;
    constructor();
    onBeforeRendering(): void;
    _handleMouseDown(e: MouseEvent): void;
    _handleMouseUp(): void;
    _handleMouseOut(e: MouseEvent): void;
    _handleMouseMove(e: MouseEvent): void;
    _handleAlphaInput(e: CustomEvent): void;
    _handleHueInput(e: CustomEvent): void;
    _handleHEXChange(e: CustomEvent | KeyboardEvent): void;
    _handleRGBInputsChange(e: CustomEvent): void;
    _setMainColor(hueValue: number): void;
    _handleAlphaChange(): void;
    _changeSelectedColor(x: number, y: number): void;
    _onkeydown(e: KeyboardEvent): void;
    _calculateColorFromCoordinates(x: number, y: number): {
        h: number;
        s: number;
        l: number;
    } | undefined;
    _setColor(color?: ColorRGB): void;
    isValidRGBColor(color: ColorRGB): boolean;
    _setHex(): void;
    _setValues(): void;
    get hueSliderLabel(): string;
    get alphaSliderLabel(): string;
    get hexInputLabel(): string;
    get redInputLabel(): string;
    get greenInputLabel(): string;
    get blueInputLabel(): string;
    get alphaInputLabel(): string;
    get inputsDisabled(): true | undefined;
    get hexInputErrorState(): "Error" | undefined;
    get styles(): {
        mainColor: {
            "background-color": string;
        };
        circle: {
            left: string;
            top: string;
        };
        colorSpan: {
            "background-color": string;
        };
    };
}
export default ColorPicker;
