import type { ClassMap } from "@ui5/webcomponents-base/dist/types.js";
import ListItem from "./ListItem.js";
/**
 * @class
 *
 * A component to be used as custom list item within the <code>ui5-list</code>
 * the same way as the standard <code>ui5-li</code>.
 *
 * The component accepts arbitrary HTML content to allow full customization.
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.CustomListItem
 * @extends sap.ui.webc.main.ListItem
 * @tagname ui5-li-custom
 * @implements sap.ui.webc.main.IListItem
 * @public
 */
declare class CustomListItem extends ListItem {
    /**
     * Defines the text alternative of the component.
     * Note: If not provided a default text alternative will be set, if present.
     *
     * @type {string}
     * @name sap.ui.webc.main.CustomListItem.prototype.accessibleName
     * @defaultvalue ""
     * @public
     * @since 1.0.0-rc.15
     */
    accessibleName: string;
    /**
     * Defines the content of the component.
     * @type {Node[]}
     * @name sap.ui.webc.main.CustomListItem.prototype.default
     * @slot
     * @public
     */
    _onkeydown(e: KeyboardEvent): void;
    _onkeyup(e: KeyboardEvent): void;
    get classes(): ClassMap;
}
export default CustomListItem;
