var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { isTabNext, isTabPrevious } from "@ui5/webcomponents-base/dist/Keys.js";
import customElement from "@ui5/webcomponents-base/dist/decorators/customElement.js";
import property from "@ui5/webcomponents-base/dist/decorators/property.js";
import ListItem from "./ListItem.js";
import CustomListItemTemplate from "./generated/templates/CustomListItemTemplate.lit.js";
// Styles
import customListItemCss from "./generated/themes/CustomListItem.css.js";
/**
 * @class
 *
 * A component to be used as custom list item within the <code>ui5-list</code>
 * the same way as the standard <code>ui5-li</code>.
 *
 * The component accepts arbitrary HTML content to allow full customization.
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.CustomListItem
 * @extends sap.ui.webc.main.ListItem
 * @tagname ui5-li-custom
 * @implements sap.ui.webc.main.IListItem
 * @public
 */
let CustomListItem = class CustomListItem extends ListItem {
    /**
     * Defines the content of the component.
     * @type {Node[]}
     * @name sap.ui.webc.main.CustomListItem.prototype.default
     * @slot
     * @public
     */
    _onkeydown(e) {
        const isTab = isTabNext(e) || isTabPrevious(e);
        if (!isTab && !this.focused) {
            return;
        }
        super._onkeydown(e);
    }
    _onkeyup(e) {
        const isTab = isTabNext(e) || isTabPrevious(e);
        if (!isTab && !this.focused) {
            return;
        }
        super._onkeyup(e);
    }
    get classes() {
        const result = super.classes;
        result.main["ui5-custom-li-root"] = true;
        return result;
    }
};
__decorate([
    property()
], CustomListItem.prototype, "accessibleName", void 0);
CustomListItem = __decorate([
    customElement({
        tag: "ui5-li-custom",
        template: CustomListItemTemplate,
        styles: [ListItem.styles, customListItemCss],
    })
], CustomListItem);
CustomListItem.define();
export default CustomListItem;
//# sourceMappingURL=CustomListItem.js.map