import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import ValueState from "@ui5/webcomponents-base/dist/types/ValueState.js";
import CalendarPickersMode from "./types/CalendarPickersMode.js";
import type FormSupportT from "./features/InputElementsFormSupport.js";
import type { IFormElement } from "./features/InputElementsFormSupport.js";
import "@ui5/webcomponents-icons/dist/appointment-2.js";
import "@ui5/webcomponents-icons/dist/decline.js";
import HasPopup from "./types/HasPopup.js";
import DateComponentBase from "./DateComponentBase.js";
import ResponsivePopover from "./ResponsivePopover.js";
import type { CalendarSelectedDatesChangeEventDetail } from "./Calendar.js";
import Input from "./Input.js";
import InputType from "./types/InputType.js";
import "@ui5/webcomponents-localization/dist/features/calendar/Gregorian.js";
type DatePickerChangeEventDetail = {
    value: string;
    valid: boolean;
};
type DatePickerInputEventDetail = {
    value: string;
    valid: boolean;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-date-picker</code> component provides an input field with assigned calendar which opens on user action.
 * The <code>ui5-date-picker</code> allows users to select a localized date using touch,
 * mouse, or keyboard input. It consists of two parts: the date input field and the
 * date picker.
 *
 * <h3>Usage</h3>
 *
 * The user can enter a date by:
 * <ul>
 * <li>Using the calendar that opens in a popup</li>
 * <li>Typing it in directly in the input field</li>
 * </ul>
 * <br><br>
 * When the user makes an entry and presses the enter key, the calendar shows the corresponding date.
 * When the user directly triggers the calendar display, the actual date is displayed.
 *
 * <h3>Formatting</h3>
 *
 * If a date is entered by typing it into
 * the input field, it must fit to the used date format.
 * <br><br>
 * Supported format options are pattern-based on Unicode LDML Date Format notation.
 * For more information, see <ui5-link target="_blank" href="http://unicode.org/reports/tr35/#Date_Field_Symbol_Table">UTS #35: Unicode Locale Data Markup Language</ui5-link>.
 * <br><br>
 * For example, if the <code>format-pattern</code> is "yyyy-MM-dd",
 * a valid value string is "2015-07-30" and the same is displayed in the input.
 *
 * <h3>Keyboard Handling</h3>
 * The <code>ui5-date-picker</code> provides advanced keyboard handling.
 * If the <code>ui5-date-picker</code> is focused,
 * you can open or close the drop-down by pressing <code>F4</code>, <code>ALT+UP</code> or <code>ALT+DOWN</code> keys.
 * Once the drop-down is opened, you can use the <code>UP</code>, <code>DOWN</code>, <code>LEFT</code>, <code>RIGHT</code> arrow keys
 * to navigate through the dates and select one by pressing the <code>Space</code> or <code>Enter</code> keys. Moreover you can
 * use TAB to reach the buttons for changing month and year.
 * <br>
 *
 * If the <code>ui5-date-picker</code> input field is focused and its corresponding picker dialog is not opened,
 * then users can increment or decrement the date referenced by <code>dateValue</code> property
 * by using the following shortcuts:
 * <br>
 * <ul>
 * <li>[PAGEDOWN] - Decrements the corresponding day of the month by one</li>
 * <li>[SHIFT] + [PAGEDOWN] - Decrements the corresponding month by one</li>
 * <li>[SHIFT] + [CTRL] + [PAGEDOWN] - Decrements the corresponding year by one</li>
 * <li>[PAGEUP] - Increments the corresponding day of the month by one</li>
 * <li>[SHIFT] + [PAGEUP] - Increments the corresponding month by one</li>
 * <li>[SHIFT] + [CTRL] + [PAGEUP] - Increments the corresponding year by one</li>
 * </ul>
 *
 * <h3>Calendar types</h3>
 * The component supports several calendar types - Gregorian, Buddhist, Islamic, Japanese and Persian.
 * By default the Gregorian Calendar is used. In order to use the Buddhist, Islamic, Japanese or Persian calendar,
 * you need to set the <code>primaryCalendarType</code> property and import one or more of the following modules:
 * <br><br>
 *
 * <code>import "@ui5/webcomponents-localization/dist/features/calendar/Buddhist.js";</code>
 * <br>
 * <code>import "@ui5/webcomponents-localization/dist/features/calendar/Islamic.js";</code>
 * <br>
 * <code>import "@ui5/webcomponents-localization/dist/features/calendar/Japanese.js";</code>
 * <br>
 * <code>import "@ui5/webcomponents-localization/dist/features/calendar/Persian.js";</code>
 * <br><br>
 *
 * Or, you can use the global configuration and set the <code>calendarType</code> key:
 * <br>
 * <pre><code>&lt;script data-id="sap-ui-config" type="application/json"&gt;
 * {
 *	"calendarType": "Japanese"
 * }
 * &lt;/script&gt;</code></pre>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/DatePicker";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.DatePicker
 * @extends sap.ui.webc.main.DateComponentBase
 * @tagname ui5-date-picker
 * @public
 */
declare class DatePicker extends DateComponentBase implements IFormElement {
    /**
     * Defines a formatted date value.
     *
     * @type {string}
     * @name sap.ui.webc.main.DatePicker.prototype.value
     * @defaultvalue ""
     * @formEvents change input
     * @formProperty
     * @public
     */
    value: string;
    /**
     * Defines the value state of the component.
     * <br><br>
     * Available options are:
     * <ul>
     * <li><code>None</code></li>
     * <li><code>Error</code></li>
     * <li><code>Warning</code></li>
     * <li><code>Success</code></li>
     * <li><code>Information</code></li>
     * </ul>
     *
     * @type {sap.ui.webc.base.types.ValueState}
     * @name sap.ui.webc.main.DatePicker.prototype.valueState
     * @defaultvalue "None"
     * @public
     */
    valueState: `${ValueState}`;
    /**
     * Defines whether the component is required.
     *
     * @since 1.0.0-rc.9
     * @type {boolean}
     * @name sap.ui.webc.main.DatePicker.prototype.required
     * @defaultvalue false
     * @public
     */
    required: boolean;
    /**
     * Determines whether the component is displayed as disabled.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.DatePicker.prototype.disabled
     * @defaultvalue false
     * @public
     */
    disabled: boolean;
    /**
     * Determines whether the component is displayed as read-only.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.DatePicker.prototype.readonly
     * @defaultvalue false
     * @public
     */
    readonly: boolean;
    /**
     * Defines a short hint, intended to aid the user with data entry when the
     * component has no value.
     *
     * <br><br>
     * <b>Note:</b> When no placeholder is set, the format pattern is displayed as a placeholder.
     * Passing an empty string as the value of this property will make the component appear empty - without placeholder or format pattern.
     *
     * @type {string}
     * @name sap.ui.webc.main.DatePicker.prototype.placeholder
     * @defaultvalue undefined
     * @public
     */
    placeholder?: string;
    /**
     * Determines the name with which the component will be submitted in an HTML form.
     *
     * <br><br>
     * <b>Important:</b> For the <code>name</code> property to have effect, you must add the following import to your project:
     * <code>import "@ui5/webcomponents/dist/features/InputElementsFormSupport.js";</code>
     *
     * <br><br>
     * <b>Note:</b> When set, a native <code>input</code> HTML element
     * will be created inside the component so that it can be submitted as
     * part of an HTML form. Do not use this property unless you need to submit a form.
     *
     * @type {string}
     * @name sap.ui.webc.main.DatePicker.prototype.name
     * @defaultvalue ""
     * @public
     */
    name: string;
    /**
     * Defines the visibility of the week numbers column.
     * <br><br>
     *
     * <b>Note:</b> For calendars other than Gregorian,
     * the week numbers are not displayed regardless of what is set.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.DatePicker.prototype.hideWeekNumbers
     * @defaultvalue false
     * @public
     * @since 1.0.0-rc.8
     */
    hideWeekNumbers: boolean;
    /**
     * Defines the aria-label attribute for the component.
     *
     * @type {string}
     * @name sap.ui.webc.main.DatePicker.prototype.accessibleName
     * @defaultvalue ""
     * @public
     * @since 1.0.0-rc.15
     */
    accessibleName: string;
    /**
     * Receives id(or many ids) of the elements that label the component.
     *
     * @type {string}
     * @name sap.ui.webc.main.DatePicker.prototype.accessibleNameRef
     * @defaultvalue ""
     * @public
     * @since 1.0.0-rc.15
     */
    accessibleNameRef: string;
    _isPickerOpen: boolean;
    _respPopoverConfig: object;
    _calendarCurrentPicker: string;
    liveValue?: string;
    /**
     * Defines the value state message that will be displayed as pop up under the component.
     * <br><br>
     *
     * <b>Note:</b> If not specified, a default text (in the respective language) will be displayed.
     * <br>
     * <b>Note:</b> The <code>valueStateMessage</code> would be displayed,
     * when the component is in <code>Information</code>, <code>Warning</code> or <code>Error</code> value state.
     * @type {HTMLElement}
     * @name sap.ui.webc.main.DatePicker.prototype.valueStateMessage
     * @since 1.0.0-rc.7
     * @slot
     * @public
     */
    valueStateMessage: Array<HTMLElement>;
    /**
     * The slot is used to render native <code>input</code> HTML element within Light DOM to enable form submit,
     * when <code>name</code> property is set.
     * @type {HTMLElement[]}
     * @slot
     * @private
     */
    formSupport: Array<HTMLElement>;
    responsivePopover?: ResponsivePopover;
    FormSupport?: typeof FormSupportT;
    static i18nBundle: I18nBundle;
    /**
     * @protected
     */
    onResponsivePopoverAfterClose(): void;
    onBeforeRendering(): void;
    /**
     * Override in derivatives to change calendar selection mode
     * @returns {string}
     * @protected
     */
    get _calendarSelectionMode(): string;
    /**
     * Used to provide a timestamp to the Calendar (to focus it to a relevant date when open) based on the component's state
     * Override in derivatives to provide the calendar a timestamp based on their properties
     * By default focus the calendar on the selected date if set, or the current day otherwise
     * @protected
     * @returns { number } the calendar timestamp
     */
    get _calendarTimestamp(): number;
    /**
     * Used to provide selectedDates to the calendar based on the component's state
     * Override in derivatives to provide different rules for setting the calendar's selected dates
     * @protected
     * @returns { array } the selected dates
     */
    get _calendarSelectedDates(): Array<string>;
    _onkeydown(e: KeyboardEvent): void;
    /**
     *
     * @param { number } amount
     * @param { string } unit
     * @protected
     */
    _modifyDateValue(amount: number, unit: string): void;
    _updateValueAndFireEvents(value: string, normalizeValue: boolean, events: Array<string>, updateValue?: boolean): void;
    _updateValueState(): void;
    _toggleAndFocusInput(): void;
    _getInput(): Input;
    /**
     * The ui5-input "submit" event handler - fire change event when the user presses enter
     * @protected
     */
    _onInputSubmit(): void;
    /**
     * The ui5-input "change" event handler - fire change event when the user focuses out of the input
     * @protected
     */
    _onInputChange(e: Event): void;
    /**
     * The ui5-input "input" event handler - fire input even when the user types
     * @protected
     */
    _onInputInput(e: KeyboardEvent): void;
    /**
     * Checks if the provided value is valid and within valid range.
     * @protected
     * @param { string } value
     * @returns { boolean }
     */
    _checkValueValidity(value: string): boolean;
    _click(e: MouseEvent): void;
    /**
     * Checks if a value is valid against the current date format of the DatePicker.
     * @public
     * @method
     * @name sap.ui.webc.main.DatePicker#isValid
     * @param { string } [value=""] A value to be tested against the current date format
     * @returns { boolean }
     */
    isValid(value?: string): boolean;
    /**
     * Checks if a date is between the minimum and maximum date.
     * @public
     * @method
     * @name sap.ui.webc.main.DatePicker#isInValidRange
     * @param { string } [value=""] A value to be checked
     * @returns { boolean }
     */
    isInValidRange(value?: string): boolean;
    /**
     * The parser understands many formats, but we need one format
     * @protected
     */
    normalizeValue(value: string): string;
    get _displayFormat(): string;
    /**
     * @protected
     */
    get _placeholder(): string;
    get _headerTitleText(): string;
    get phone(): boolean;
    get showHeader(): boolean;
    get showFooter(): boolean;
    get accInfo(): {
        ariaRoledescription: string;
        ariaHasPopup: HasPopup;
        ariaAutoComplete: string;
        ariaRequired: boolean;
        ariaLabel: string | undefined;
    };
    get openIconTitle(): string;
    get openIconName(): string;
    get dateAriaDescription(): string;
    /**
     * Defines whether the dialog on mobile should have header
     * @private
     */
    get _shouldHideHeader(): boolean;
    /**
     * Defines whether the value help icon is hidden
     * @private
     */
    get _ariaHidden(): boolean;
    _respPopover(): Promise<ResponsivePopover>;
    _canOpenPicker(): boolean;
    get _calendarPickersMode(): CalendarPickersMode;
    /**
     * The user selected a new date in the calendar
     * @param event
     * @protected
     */
    onSelectedDatesChange(e: CustomEvent<CalendarSelectedDatesChangeEventDetail>): void;
    /**
     * The user clicked the "month" button in the header
     */
    onHeaderShowMonthPress(): void;
    /**
     * The user clicked the "year" button in the header
     */
    onHeaderShowYearPress(): void;
    /**
     * Formats a Java Script date object into a string representing a locale date
     * according to the <code>formatPattern</code> property of the DatePicker instance
     * @public
     * @method
     * @name sap.ui.webc.main.DatePicker#formatValue
     * @param {Date} date A Java Script date object to be formatted as string
     * @returns {string} The date as string
     */
    formatValue(date: Date): string;
    /**
     * Closes the picker.
     * @public
     * @method
     * @name sap.ui.webc.main.DatePicker#closePicker
     */
    closePicker(): void;
    /**
     * Opens the picker.
     * @public
     * @async
     * @method
     * @name sap.ui.webc.main.DatePicker#openPicker
     * @returns {Promise} Resolves when the picker is open
     */
    openPicker(): Promise<void>;
    togglePicker(): void;
    /**
     * Checks if the picker is open.
     * @public
     * @method
     * @name sap.ui.webc.main.DatePicker#isOpen
     * @returns {boolean} true if the picker is open, false otherwise
     */
    isOpen(): boolean;
    /**
     * Currently selected date represented as a Local JavaScript Date instance.
     *
     * @public
     * @readonly
     * @name sap.ui.webc.main.DatePicker.prototype.dateValue
     * @type { Date }
     */
    get dateValue(): Date | null;
    get dateValueUTC(): Date | null;
    get styles(): {
        main: {
            width: string;
        };
    };
    get type(): InputType;
}
export default DatePicker;
export type { DatePickerChangeEventDetail, DatePickerInputEventDetail, };
