/// <reference types="openui5" />
import DatePicker from "./DatePicker.js";
import CalendarPickersMode from "./types/CalendarPickersMode.js";
import type { DatePickerChangeEventDetail as DateRangePickerChangeEventDetail, DatePickerInputEventDetail as DateRangePickerInputEventDetail } from "./DatePicker.js";
import type { CalendarSelectedDatesChangeEventDetail } from "./Calendar.js";
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 * The DateRangePicker enables the users to enter a localized date range using touch, mouse, keyboard input, or by selecting a date range in the calendar.
 *
 * <h3>Usage</h3>
 * The user can enter a date by:
 * Using the calendar that opens in a popup or typing it in directly in the input field (not available for mobile devices).
 * For the <code>ui5-daterange-picker</code>
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/DateRangePicker.js";</code>
 *
 * <h3>Keyboard Handling</h3>
 * The <code>ui5-daterange-picker</code> provides advanced keyboard handling.
 * <br>
 *
 * When the <code>ui5-daterange-picker</code> input field is focused the user can
 * increment or decrement respectively the range start or end date, depending on where the cursor is.
 * The following shortcuts are available:
 * <br>
 * <ul>
 * <li>[PAGEDOWN] - Decrements the corresponding day of the month by one</li>
 * <li>[SHIFT] + [PAGEDOWN] - Decrements the corresponding month by one</li>
 * <li>[SHIFT] + [CTRL] + [PAGEDOWN] - Decrements the corresponding year by one</li>
 * <li>[PAGEUP] - Increments the corresponding day of the month by one</li>
 * <li>[SHIFT] + [PAGEUP] - Increments the corresponding month by one</li>
 * <li>[SHIFT] + [CTRL] + [PAGEUP] - Increments the corresponding year by one</li>
 * </ul>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.DateRangePicker
 * @extends sap.ui.webc.main.DatePicker
 * @tagname ui5-daterange-picker
 * @since 1.0.0-rc.8
 * @public
 */
declare class DateRangePicker extends DatePicker {
    /**
    * Determines the symbol which separates the dates.
    * If not supplied, the default time interval delimiter for the current locale will be used.
    *
    * @type {string}
    * @name sap.ui.webc.main.DateRangePicker.prototype.delimiter
    * @defaultvalue "-"
    * @public
    */
    delimiter: string;
    /**
    * The first date in the range during selection (this is a temporary value, not the first date in the value range)
    *
    * @private
    */
    _tempValue: string;
    private _prevDelimiter;
    constructor();
    /**
     * <b>Note:</b> The getter method is inherited and not supported. If called it will return an empty value.
     *
     * @readonly
     * @type {Date}
     * @public
     * @name sap.ui.webc.main.DateRangePicker.prototype.dateValue
     */
    get dateValue(): null;
    /**
     * <b>Note:</b> The getter method is inherited and not supported. If called it will return an empty value.
     *
     * @readonly
     * @type {Date}
     * @public
     * @name sap.ui.webc.main.DateRangePicker.prototype.dateValueUTC
     */
    get dateValueUTC(): null;
    get _startDateTimestamp(): number | undefined;
    get _endDateTimestamp(): number | undefined;
    get _tempTimestamp(): number | "";
    /**
     * Required by DatePicker.js
     * @override
     */
    get _calendarSelectionMode(): string;
    /**
     * Required by DatePicker.js - set the calendar focus on the first selected date (or today if not set)
     * @override
     */
    get _calendarTimestamp(): number;
    /**
     * Required by DatePicker.js
     * @override
     */
    get _calendarSelectedDates(): string[];
    /**
     * Returns the start date of the currently selected range as JavaScript Date instance.
     *
     * @readonly
     * @type {Date}
     * @public
     * @name sap.ui.webc.main.DateRangePicker.prototype.startDateValue
     */
    get startDateValue(): Date | import("sap/ui/core/date/UI5Date").default;
    /**
     * Returns the end date of the currently selected range as JavaScript Date instance.
     *
     * @readonly
     * @type {Date}
     * @public
     * @name sap.ui.webc.main.DateRangePicker.prototype.endDateValue
     */
    get endDateValue(): Date | import("sap/ui/core/date/UI5Date").default;
    /**
     * @override
     */
    get _placeholder(): string;
    get dateAriaDescription(): string;
    /**
     * @override
     */
    _onInputSubmit(): Promise<void>;
    /**
     * @override
     */
    onResponsivePopoverAfterClose(): void;
    /**
     * @override
     */
    isValid(value: string): boolean;
    /**
     * @override
     */
    isInValidRange(value: string): boolean;
    /**
     * Extract both dates as timestamps, flip if necessary, and build (which will use the desired format so we enforce the format too)
     * @override
     */
    normalizeValue(value: string): string;
    /**
     * @override
     */
    onSelectedDatesChange(event: CustomEvent<CalendarSelectedDatesChangeEventDetail>): void;
    /**
     * @override
     */
    _modifyDateValue(amount: number, unit: string): Promise<void>;
    get _effectiveDelimiter(): string;
    _splitValueByDelimiter(value: string): string[];
    /**
     * Returns a UTC timestamp, representing the first date in the value string or undefined if the value is empty
     * @private
     */
    _extractFirstTimestamp(value: string): number | undefined;
    /**
     * Returns a UTC timestamp, representing the last date in the value string or undefined if the value is empty or there is just one date
     * @private
     */
    _extractLastTimestamp(value: string): number | undefined;
    /**
     * Builds a string value out of two UTC timestamps - this method is the counterpart to _extractFirstTimestamp/_extractLastTimestamp
     * @private
     */
    _buildValue(firstDateTimestamp: number | undefined, lastDateTimestamp: number | undefined): string;
    /**
     * @override
     */
    get _calendarPickersMode(): CalendarPickersMode;
}
export default DateRangePicker;
export type { DateRangePickerChangeEventDetail, DateRangePickerInputEventDetail, };
