import ValueState from "@ui5/webcomponents-base/dist/types/ValueState.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import Popup from "./Popup.js";
import type { PopupBeforeCloseEventDetail as DialogBeforeCloseEventDetail } from "./Popup.js";
import "@ui5/webcomponents-icons/dist/resize-corner.js";
import "@ui5/webcomponents-icons/dist/error.js";
import "@ui5/webcomponents-icons/dist/alert.js";
import "@ui5/webcomponents-icons/dist/sys-enter-2.js";
import "@ui5/webcomponents-icons/dist/information.js";
/**
 * @class
 * <h3 class="comment-api-title">Overview</h3>
 * The <code>ui5-dialog</code> component is used to temporarily display some information in a
 * size-limited window in front of the regular app screen.
 * It is used to prompt the user for an action or a confirmation.
 * The <code>ui5-dialog</code> interrupts the current app processing as it is the only focused UI element and
 * the main screen is dimmed/blocked.
 * The dialog combines concepts known from other technologies where the windows have
 * names such as dialog box, dialog window, pop-up, pop-up window, alert box, or message box.
 * <br><br>
 * The <code>ui5-dialog</code> is modal, which means that an user action is required before it is possible to return to the parent window.
 * To open multiple dialogs, each dialog element should be separate in the markup. This will ensure the correct modal behavior. Avoid nesting dialogs within each other.
 * The content of the <code>ui5-dialog</code> is fully customizable.
 *
 * <h3>Structure</h3>
 * A <code>ui5-dialog</code> consists of a header, content, and a footer for action buttons.
 * The <code>ui5-dialog</code> is usually displayed at the center of the screen.
 * Its position can be changed by the user. To enable this, you need to set the property <code>draggable</code> accordingly.

 *
 * <h3>Responsive Behavior</h3>
 * The <code>stretch</code> property can be used to stretch the
 * <code>ui5-dialog</code> on full screen.
 *
 * <h3>CSS Shadow Parts</h3>
 *
 * <ui5-link target="_blank" href="https://developer.mozilla.org/en-US/docs/Web/CSS/::part">CSS Shadow Parts</ui5-link> allow developers to style elements inside the Shadow DOM.
 * <br>
 * The <code>ui5-dialog</code> exposes the following CSS Shadow Parts:
 * <ul>
 * <li>header - Used to style the header of the component</li>
 * <li>content - Used to style the content of the component</li>
 * <li>footer - Used to style the footer of the component</li>
 * </ul>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/Dialog";</code>
 *
 * <b>Note:</b> We don't recommend nesting popup-like components (<code>ui5-dialog</code>, <code>ui5-popover</code>) inside <code>ui5-dialog</code>.
 * Ideally you should create all popups on the same level inside your HTML page and just open them from one another, rather than nesting them.
 *
 * <b>Note:</b> We don't recommend nesting popup-like components (<code>ui5-dialog</code>, <code>ui5-popover</code>) inside other components containing z-index.
 * This might break z-index management.
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.Dialog
 * @extends sap.ui.webc.main.Popup
 * @tagname ui5-dialog
 * @public
 */
declare class Dialog extends Popup {
    /**
     * Defines the header text.
     * <br><br>
     * <b>Note:</b> If <code>header</code> slot is provided, the <code>headerText</code> is ignored.
     *
     * @type {string}
     * @name sap.ui.webc.main.Dialog.prototype.headerText
     * @defaultvalue ""
     * @public
     */
    headerText: string;
    /**
     * Determines whether the component should be stretched to fullscreen.
     * <br><br>
     * <b>Note:</b> The component will be stretched to approximately
     * 90% of the viewport.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.Dialog.prototype.stretch
     * @defaultvalue false
     * @public
     */
    stretch: boolean;
    /**
     * Determines whether the component is draggable.
     * If this property is set to true, the Dialog will be draggable by its header.
     * <br><br>
     * <b>Note:</b> The component can be draggable only in desktop mode.
     * <br><br>
     * <b>Note:</b> This property overrides the default HTML "draggable" attribute native behavior.
     * When "draggable" is set to true, the native browser "draggable"
     * behavior is prevented and only the Dialog custom logic ("draggable by its header") works.
     * @type {boolean}
     * @name sap.ui.webc.main.Dialog.prototype.draggable
     * @defaultvalue false
     * @since 1.0.0-rc.9
     * @public
     */
    draggable: boolean;
    /**
     * Configures the component to be resizable.
     * If this property is set to true, the Dialog will have a resize handle in its bottom right corner in LTR languages.
     * In RTL languages, the resize handle will be placed in the bottom left corner.
     * <br><br>
     * <b>Note:</b> The component can be resizable only in desktop mode.
     * <br>
     * <b>Note:</b> Upon resizing, externally defined height and width styling will be ignored.
     * @type {boolean}
     * @name sap.ui.webc.main.Dialog.prototype.resizable
     * @defaultvalue false
     * @since 1.0.0-rc.10
     * @public
     */
    resizable: boolean;
    /**
     * Defines the state of the <code>Dialog</code>.
     * <br><br>
     * Available options are: <code>"None"</code> (by default), <code>"Success"</code>, <code>"Warning"</code>, <code>"Information"</code> and <code>"Error"</code>.
     * <br><br>
     * <b>Note:</b> If <code>"Error"</code> and <code>"Warning"</code> state is set, it will change the
     * accessibility role to "alertdialog", if the accessibleRole property is set to <code>"Dialog"</code>.
     * @type {sap.ui.webc.base.types.ValueState}
     * @name sap.ui.webc.main.Dialog.prototype.state
     * @defaultvalue "None"
     * @public
     * @since 1.0.0-rc.15
     */
    state: `${ValueState}`;
    /**
     * @private
     */
    onPhone: boolean;
    /**
     * @private
     */
    onDesktop: boolean;
    _screenResizeHandler: () => void;
    _dragMouseMoveHandler: (e: MouseEvent) => void;
    _dragMouseUpHandler: (e: MouseEvent) => void;
    _resizeMouseMoveHandler: (e: MouseEvent) => void;
    _resizeMouseUpHandler: (e: MouseEvent) => void;
    _dragStartHandler: (e: DragEvent) => void;
    _y?: number;
    _x?: number;
    _isRTL?: boolean;
    _screenResizeHandlerAttached?: boolean;
    _initialX?: number;
    _initialY?: number;
    _initialWidth?: number;
    _initialHeight?: number;
    _initialTop?: number;
    _initialLeft?: number;
    _minWidth?: number;
    _cachedMinHeight?: number;
    _draggedOrResized: boolean;
    /**
     * Defines the header HTML Element.
     * <br><br>
     * <b>Note:</b> If <code>header</code> slot is provided, the labelling of the dialog is a responsibility of the application developer.
     * <code>accessibleName</code> should be used.
     *
     * @type {HTMLElement[]}
     * @name sap.ui.webc.main.Dialog.prototype.header
     * @slot
     * @public
     */
    header: Array<HTMLElement>;
    /**
     * Defines the footer HTML Element.
     *
     * @type {HTMLElement[]}
     * @name sap.ui.webc.main.Dialog.prototype.footer
     * @slot
     * @public
     */
    footer: Array<HTMLElement>;
    static i18nBundle: I18nBundle;
    constructor();
    static onDefine(): Promise<void>;
    static _isHeader(element: HTMLElement): boolean;
    /**
     * Shows the dialog.
     *
     * @param {boolean} [preventInitialFocus=false] Prevents applying the focus inside the popup
     * @public
     * @method
     * @name sap.ui.webc.main.Dialog#show
     * @async
     * @returns {Promise} Resolves when the dialog is open
     */
    show(preventInitialFocus?: boolean): Promise<void>;
    get isModal(): boolean;
    get shouldHideBackdrop(): boolean;
    get _ariaLabelledBy(): string | undefined;
    get ariaRoleDescriptionHeaderText(): string | undefined;
    get effectiveAriaDescribedBy(): string | undefined;
    get ariaDescribedByHeaderTextResizable(): string;
    get ariaDescribedByHeaderTextDraggable(): string;
    get ariaDescribedByHeaderTextDraggableAndResizable(): string;
    get _displayProp(): string;
    /**
     * Determines if the header should be shown.
     */
    get _displayHeader(): string | number | boolean;
    get _movable(): boolean;
    get _headerTabIndex(): "0" | undefined;
    get _showResizeHandle(): boolean;
    get _minHeight(): number;
    get hasValueState(): boolean;
    get _dialogStateIcon(): string;
    get _role(): string | undefined;
    _show(): void;
    onBeforeRendering(): void;
    onAfterRendering(): void;
    onEnterDOM(): void;
    onExitDOM(): void;
    /**
     * @override
     */
    _resize(): void;
    _screenResize(): void;
    _attachScreenResizeHandler(): void;
    _detachScreenResizeHandler(): void;
    _center(): void;
    _revertSize: () => void;
    /**
     * Event handlers
     */
    _onDragMouseDown(e: DragEvent): void;
    _onDragMouseMove(e: MouseEvent): void;
    _onDragMouseUp(): void;
    _onDragOrResizeKeyDown(e: KeyboardEvent): void;
    _dragWithEvent(e: KeyboardEvent): void;
    _resizeWithEvent(e: KeyboardEvent): void;
    _attachMouseDragHandlers(): void;
    _detachMouseDragHandlers(): void;
    _onResizeMouseDown(e: MouseEvent): void;
    _onResizeMouseMove(e: MouseEvent): void;
    _onResizeMouseUp(): void;
    _handleDragStart(e: DragEvent): void;
    _attachMouseResizeHandlers(): void;
    _detachMouseResizeHandlers(): void;
}
export default Dialog;
export type { DialogBeforeCloseEventDetail, };
