import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import ValueState from "@ui5/webcomponents-base/dist/types/ValueState.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import Input from "./Input.js";
import Popover from "./Popover.js";
import type { IFormElement } from "./features/InputElementsFormSupport.js";
type FileUploaderChangeEventDetail = {
    files: FileList | null;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-file-uploader</code> opens a file explorer dialog and enables users to upload files.
 * The component consists of input field, but you can provide an HTML element by your choice
 * to trigger the file upload, by using the default slot.
 * Furthermore, you can set the property "hideInput" to "true" to hide the input field.
 * <br>
 * To get all selected files, you can simply use the read-only "files" property.
 * To restrict the types of files the user can select, you can use the "accept" property.
 * <br>
 * And, similar to all input based components, the FileUploader supports "valueState", "placeholder", "name", and "disabled" properties.
 *
 * For the <code>ui5-file-uploader</code>
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/FileUploader.js";</code>
 *
 * @constructor
 * @since 1.0.0-rc.6
 * @author SAP SE
 * @alias sap.ui.webc.main.FileUploader
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-file-uploader
 * @public
 */
declare class FileUploader extends UI5Element implements IFormElement {
    /**
     * Comma-separated list of file types that the component should accept.
     * <br><br>
     * <b>Note:</b> Please make sure you are adding the <code>.</code> in front on the file type, e.g. <code>.png</code> in case you want to accept png's only.
     * @type {string}
     * @name sap.ui.webc.main.FileUploader.prototype.accept
     * @defaultvalue ""
     * @public
     */
    accept: string;
    /**
     * If set to "true", the input field of component will not be rendered. Only the default slot that is passed will be rendered.
     * @type {boolean}
     * @name sap.ui.webc.main.FileUploader.prototype.hideInput
     * @defaultvalue false
     * @public
     */
    hideInput: boolean;
    /**
     * Defines whether the component is in disabled state.
     * <br><br>
     * <b>Note:</b> A disabled component is completely noninteractive.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.FileUploader.prototype.disabled
     * @defaultvalue false
     * @public
     */
    disabled: boolean;
    /**
     * Allows multiple files to be chosen.
     * @type {boolean}
     * @name sap.ui.webc.main.FileUploader.prototype.multiple
     * @defaultvalue false
     * @public
     */
    multiple: boolean;
    /**
     * Determines the name with which the component will be submitted in an HTML form.
     *
     * <br><br>
     * <b>Important:</b> For the <code>name</code> property to have effect, you must add the following import to your project:
     * <code>import "@ui5/webcomponents/dist/features/InputElementsFormSupport.js";</code>
     *
     * <br><br>
     * <b>Note:</b> When set, a native <code>input</code> HTML element
     * will be created inside the component so that it can be submitted as
     * part of an HTML form. Do not use this property unless you need to submit a form.
     *
     * @type {string}
     * @name sap.ui.webc.main.FileUploader.prototype.name
     * @defaultvalue ""
     * @public
     */
    name: string;
    /**
     * Defines a short hint intended to aid the user with data entry when the component has no value.
     * @type {string}
     * @name sap.ui.webc.main.FileUploader.prototype.placeholder
     * @defaultvalue ""
     * @public
     */
    placeholder: string;
    /**
     * Defines the name/names of the file/files to upload.
     * @type {string}
     * @name sap.ui.webc.main.FileUploader.prototype.value
     * @defaultvalue ""
     * @formEvents change
     * @formProperty
     * @public
     */
    value: string;
    /**
     * Defines the value state of the component.
     * <br><br>
     * Available options are:
     * <ul>
     * <li><code>None</code></li>
     * <li><code>Error</code></li>
     * <li><code>Warning</code></li>
     * <li><code>Success</code></li>
     * <li><code>Information</code></li>
     * </ul>
     *
     * @type {sap.ui.webc.base.types.ValueState}
     * @name sap.ui.webc.main.FileUploader.prototype.valueState
     * @defaultvalue "None"
     * @public
     */
    valueState: `${ValueState}`;
    /**
     * @private
     */
    focused: boolean;
    /**
     * By default the component contains a single input field. With this slot you can pass any content that you wish to add. See the samples for more information.
     *
     * @type {HTMLElement[]}
     * @name sap.ui.webc.main.FileUploader.prototype.default
     * @slot content
     * @public
     */
    content: Array<HTMLElement>;
    /**
     * Defines the value state message that will be displayed as pop up under the component.
     * <br><br>
     *
     * <b>Note:</b> If not specified, a default text (in the respective language) will be displayed.
     * <br>
     * <b>Note:</b> The <code>valueStateMessage</code> would be displayed,
     * when the component is in <code>Information</code>, <code>Warning</code> or <code>Error</code> value state.
     * @type {HTMLElement[]}
     * @name sap.ui.webc.main.FileUploader.prototype.valueStateMessage
     * @since 1.0.0-rc.9
     * @slot
     * @public
     */
    valueStateMessage: Array<HTMLElement>;
    /**
     * The slot is used to render native <code>input</code> HTML element within Light DOM to enable form submit,
     * when <code>name</code> property is set.
     * @type {HTMLElement[]}
     * @slot
     * @private
     */
    formSupport: Array<HTMLElement>;
    _internals: ElementInternals;
    static emptyInput: HTMLInputElement;
    static i18nBundle: I18nBundle;
    static get formAssociated(): boolean;
    constructor();
    _onmouseover(): void;
    _onmouseout(): void;
    _onclick(e: MouseEvent): void;
    _onkeydown(e: KeyboardEvent): void;
    _onkeyup(e: KeyboardEvent): void;
    _onfocusin(): void;
    _onfocusout(): void;
    /**
     * FileList of all selected files.
     * @readonly
     * @type {FileList}
     * @public
     * @name sap.ui.webc.main.FileUploader.prototype.files
     */
    get files(): FileList | null;
    onBeforeRendering(): void;
    onAfterRendering(): void;
    _enableFormSupport(): void;
    _onChange(e: Event): void;
    _updateValue(files: FileList | null): void;
    _setFormValue(): void;
    toggleValueStatePopover(open: boolean): void;
    openValueStatePopover(): Promise<void>;
    closeValueStatePopover(): Promise<void>;
    _getPopover(): Promise<Popover>;
    /**
     * in case when the component is not placed in the DOM, return empty FileList, like native input would do
     * @private
     */
    static get _emptyFilesList(): FileList | null;
    get browseText(): string;
    get titleText(): string;
    get _canUseNativeFormSupport(): boolean;
    get _keepInputInShadowDOM(): boolean;
    get _input(): HTMLInputElement;
    get valueStateTextMappings(): Record<string, string>;
    get valueStateText(): string;
    get hasValueState(): boolean;
    get hasValueStateText(): boolean;
    get valueStateMessageText(): Node[];
    get shouldDisplayDefaultValueStateMessage(): boolean;
    get shouldOpenValueStateMessagePopover(): boolean;
    /**
     * This method is relevant for sap_horizon theme only
     */
    get _valueStateMessageInputIcon(): string;
    get classes(): {
        popoverValueState: {
            "ui5-valuestatemessage-root": boolean;
            "ui5-valuestatemessage--success": boolean;
            "ui5-valuestatemessage--error": boolean;
            "ui5-valuestatemessage--warning": boolean;
            "ui5-valuestatemessage--information": boolean;
        };
    };
    get styles(): {
        popoverHeader: {
            width: string;
        };
    };
    get ui5Input(): Input | null;
    static onDefine(): Promise<void>;
}
export default FileUploader;
export type { FileUploaderChangeEventDetail, };
