import type { PassiveEventListenerObject } from "@ui5/webcomponents-base/dist/types.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import "@ui5/webcomponents-icons/dist/decline.js";
import "@ui5/webcomponents-icons/dist/edit.js";
import ListItemType from "./types/ListItemType.js";
import ListMode from "./types/ListMode.js";
import ListItemBase from "./ListItemBase.js";
import HasPopup from "./types/HasPopup.js";
import "@ui5/webcomponents-icons/dist/slim-arrow-right.js";
interface IAccessibleListItem {
    accessibleName?: string;
    accessibleNameRef?: string;
}
type SelectionRequestEventDetail = {
    item: ListItemBase;
    selectionComponentPressed: boolean;
    selected?: boolean;
    key?: string;
};
type PressEventDetail = {
    item: ListItem;
    selected: boolean;
    key: string;
};
type AccInfo = {
    role: string;
    ariaExpanded?: boolean;
    ariaLevel?: number;
    ariaLabel: string;
    ariaLabelRadioButton: string;
    ariaSelectedText?: string;
    ariaHaspopup?: `${HasPopup}`;
    posinset?: number;
    setsize?: number;
    ariaSelected?: boolean;
    ariaChecked?: boolean;
    listItemAriaLabel?: string;
    ariaOwns?: string;
};
/**
 * @class
 * A class to serve as a base
 * for the <code>StandardListItem</code> and <code>CustomListItem</code> classes.
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.ListItem
 * @extends sap.ui.webc.main.ListItemBase
 * @public
 */
declare abstract class ListItem extends ListItemBase {
    /**
     * Defines the visual indication and behavior of the list items.
     * Available options are <code>Active</code> (by default), <code>Inactive</code>, <code>Detail</code> and <code>Navigation</code>.
     * <br><br>
     * <b>Note:</b> When set to <code>Active</code> or <code>Navigation</code>, the item will provide visual response upon press and hover,
     * while with type <code>Inactive</code> and <code>Detail</code> - will not.
     *
     * @type {sap.ui.webc.main.types.ListItemType}
     * @name sap.ui.webc.main.ListItem.prototype.type
     * @defaultvalue "Active"
     * @public
    */
    type: `${ListItemType}`;
    /**
     * The navigated state of the list item.
     * If set to <code>true</code>, a navigation indicator is displayed at the end of the list item.
     *
     * @public
     * @type {boolean}
     * @name sap.ui.webc.main.ListItem.prototype.navigated
     * @since 1.10.0
     */
    navigated: boolean;
    /**
     * Indicates if the list item is active, e.g pressed down with the mouse or the keyboard keys.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.ListItem.prototype.active
     * @private
    */
    active: boolean;
    /**
     * Defines the tooltip of the component.
     * @type {string}
     * @name sap.ui.webc.main.ListItem.prototype.title
     * @defaultvalue ""
     * @private
     * @since 1.0.0-rc.15
     */
    title: string;
    /**
     * Indicates if the list item is actionable, e.g has hover and pressed effects.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.ListItem.prototype.actionable
     * @private
    */
    actionable: boolean;
    /**
     * Used to define the role of the list item.
     *
     * @private
     * @type {string}
     * @name sap.ui.webc.main.ListItem.prototype.role
     * @defaultvalue "listitem"
     * @since 1.0.0-rc.9
     *
     */
    role: string;
    /**
     * Defines the description for the accessible role of the component.
     * @protected
     * @type {string}
     * @name sap.ui.webc.main.ListItem.prototype.accessibleRoleDescription
     * @defaultvalue undefined
     * @since 1.10.0
     */
    accessibleRoleDescription?: string;
    /**
     * Used to define the role of the list item.
     *
     * @private
     * @type {string}
     * @name sap.ui.webc.main.ListItem.prototype.accessibleRole
     * @defaultvalue ""
     * @since 1.3.0
     *
     */
    accessibleRole: string;
    _mode: `${ListMode}`;
    /**
     * Defines the availability and type of interactive popup element that can be triggered by the component on which the property is set.
     * @type {sap.ui.webc.main.types.HasPopup}
     * @name sap.ui.webc.main.ListItem.prototype.ariaHaspopup
     * @since 1.10.0
     * @private
     */
    ariaHaspopup?: `${HasPopup}`;
    _level?: number;
    /**
     * Used in UploadCollectionItem
     * @private
     */
    disableDeleteButton: boolean;
    /**
     * Defines the delete button, displayed in "Delete" mode.
     * <b>Note:</b> While the slot allows custom buttons, to match
     * design guidelines, please use the <code>ui5-button</code> component.
     * <b>Note:</b> When the slot is not present, a built-in delete button will be displayed.
     * @type {sap.ui.webc.main.IButton}
     * @name sap.ui.webc.main.ListItem.prototype.deleteButton
     * @since 1.9.0
     * @slot
     * @public
     */
    deleteButton: Array<HTMLElement>;
    deactivateByKey: (e: KeyboardEvent) => void;
    deactivate: () => void;
    _ontouchstart: PassiveEventListenerObject;
    accessibleName?: string;
    indeterminate?: boolean;
    static i18nBundle: I18nBundle;
    constructor();
    onBeforeRendering(): void;
    onEnterDOM(): void;
    onExitDOM(): void;
    _onkeydown(e: KeyboardEvent): void;
    _onkeyup(e: KeyboardEvent): void;
    _onmousedown(e: MouseEvent): void;
    _onmouseup(e: MouseEvent): void;
    _ontouchend(e: TouchEvent): void;
    _onfocusout(): void;
    _onclick(e: MouseEvent): void;
    onMultiSelectionComponentPress(e: MouseEvent): void;
    onSingleSelectionComponentPress(e: MouseEvent): void;
    activate(): void;
    onDelete(): void;
    onDetailClick(): void;
    fireItemPress(e: Event): void;
    get isInactive(): boolean;
    get placeSelectionElementBefore(): boolean;
    get placeSelectionElementAfter(): boolean;
    get modeSingleSelect(): boolean;
    get modeMultiSelect(): boolean;
    get modeDelete(): boolean;
    /**
     * Used in UploadCollectionItem
     */
    get renderDeleteButton(): boolean;
    /**
     * End
     */
    get typeDetail(): boolean;
    get typeNavigation(): boolean;
    get typeActive(): boolean;
    get _ariaSelected(): boolean | undefined;
    get ariaSelectedText(): string | undefined;
    get deleteText(): string;
    get hasDeleteButtonSlot(): boolean;
    get _accessibleNameRef(): string;
    get _accInfo(): AccInfo;
    get hasConfigurableMode(): boolean;
    static onDefine(): Promise<void>;
}
export default ListItem;
export type { IAccessibleListItem, SelectionRequestEventDetail, PressEventDetail, };
