import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import "@ui5/webcomponents-icons/dist/slim-arrow-right.js";
import ResponsivePopover from "./ResponsivePopover.js";
import type { ResponsivePopoverBeforeCloseEventDetail } from "./ResponsivePopover.js";
import type MenuItem from "./MenuItem.js";
import type { ListItemClickEventDetail } from "./List.js";
type CurrentItem = {
    item: MenuItem;
    position: number;
    ariaHasPopup: string | undefined;
};
type MenuItemClickEventDetail = {
    item: MenuItem;
    text: string;
};
type MenuBeforeOpenEventDetail = {
    item?: MenuItem;
};
type MenuBeforeCloseEventDetail = {
    escPressed: boolean;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * <code>ui5-menu</code> component represents a hierarchical menu structure.
 *
 * <h3>Usage</h3>
 *
 * <code>ui5-menu</code> contains <code>ui5-menu-item</code> components.
 * An arbitrary hierarchy structure can be represented by recursively nesting menu items.
 *
 * <h3>Keyboard Handling</h3>
 *
 * The <code>ui5-menu</code> provides advanced keyboard handling.
 * The user can use the following keyboard shortcuts in order to navigate trough the tree:
 * <ul>
 * <li><code>Arrow Up</code> / <code>Arrow Down</code> - Navigates up and down the menu items that are currently visible.</li>
 * <li><code>Arrow Right</code>, <code>Space</code> or <code>Enter</code> - Opens a sub-menu if there are menu items nested
 * in the currently clicked menu item.</li>
 * <li><code>Arrow Left</code> or <code>Escape</code> - Closes the currently opened sub-menu.</li>
 * </ul>
 * Note: if the text ditrection is set to Right-to-left (RTL), <code>Arrow Right</code> and <code>Arrow Left</code> functionality is swapped.
 * <br>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/Menu.js";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.Menu
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-menu
 * @appenddocs sap.ui.webc.main.MenuItem
 * @since 1.3.0
 * @public
 */
declare class Menu extends UI5Element {
    /**
     * Defines the header text of the menu (displayed on mobile).
     *
     * @name sap.ui.webc.main.Menu.prototype.headerText
     * @type {string}
     * @defaultvalue ""
     * @public
     */
    headerText: string;
    /**
     * Indicates if the menu is open
     *
     * @name sap.ui.webc.main.Menu.prototype.open
     * @public
     * @type {boolean}
     * @defaultvalue false
     * @since 1.10.0
     */
    open: boolean;
    /**
     * Defines if a loading indicator would be displayed inside the corresponding ui5-menu popover.
     *
     * @name sap.ui.webc.main.Menu.prototype.busy
     * @type {boolean}
     * @defaultvalue false
     * @public
     * @since 1.13.0
     */
    busy: boolean;
    /**
     * Defines the delay in milliseconds, after which the busy indicator will be displayed inside the corresponding ui5-menu popover..
     *
     * @name sap.ui.webc.main.Menu.prototype.busyDelay
     * @type {sap.ui.webc.base.types.Integer}
     * @defaultValue 1000
     * @public
     * @since 1.13.0
     */
    busyDelay: number;
    /**
     * Defines the ID or DOM Reference of the element that the menu is shown at
     *
     * @name sap.ui.webc.main.Menu.prototype.opener
     * @public
     * @type {sap.ui.webc.base.types.DOMReference}
     * @defaultvalue ""
     * @since 1.10.0
     */
    opener: HTMLElement | string;
    /**
     * Defines if the menu is sub-menu (not first-level).
     * @type {boolean}
     * @defaultvalue false
     * @private
     */
    _isSubMenu: boolean;
    /**
     * Stores id of a list item that opened sub-menu.
     * @type {string}
     * @private
     */
    _subMenuOpenerId: string;
    /**
     * Defines the currently available menu items.
     * (in case of non-phone devices these are the items of the menu,
     * but for phone devices the items of the currently opened sub-menu
     * will be populated here)
     * @type {array}
     * @private
     */
    _currentItems: Array<CurrentItem>;
    /**
     * Stores a list of parent menu items for each sub-menu (on phone).
     * @type {array}
     * @private
     */
    _parentItemsStack: Array<MenuItem>;
    /**
     * Stores the ResponsivePopover instance
     */
    _popover?: ResponsivePopover;
    /**
     * Stores parent menu item (if there is such).
     */
    _parentMenuItem?: MenuItem;
    /**
     * Stores menu item that have sub-menu opened.
     */
    _openedSubMenuItem?: MenuItem;
    /**
     * Defines the items of this component.
     * <br><br>
     * <b>Note:</b> Use <code>ui5-menu-item</code> for the intended design.
     *
     * @name sap.ui.webc.main.Menu.prototype.default
     * @type {sap.ui.webc.main.IMenuItem[]}
     * @slot items
     * @public
     */
    items: Array<MenuItem>;
    static i18nBundle: I18nBundle;
    static onDefine(): Promise<void>;
    get itemsWithChildren(): boolean;
    get itemsWithIcon(): boolean;
    get isRtl(): boolean;
    get placementType(): "Left" | "Right" | "Bottom";
    get verticalAlign(): "Bottom" | "Top";
    get labelBack(): string;
    get labelClose(): string;
    get isPhone(): boolean;
    get isSubMenuOpened(): boolean;
    get menuHeaderTextPhone(): string;
    onBeforeRendering(): void;
    onAfterRendering(): void;
    /**
     * Shows the Menu near the opener element.
     * @param {HTMLElement} opener the element that the popover is shown at
     * @public
     * @method
     * @name sap.ui.webc.main.Menu#showAt
     */
    showAt(opener: HTMLElement): Promise<void>;
    /**
     * Closes the Menu.
     * @public
     * @method
     * @name sap.ui.webc.main.Menu#close
     */
    close(): void;
    _createPopover(): Promise<ResponsivePopover>;
    _navigateBack(): void;
    _prepareCurrentItems(items: Array<MenuItem>): void;
    _createSubMenu(item: MenuItem, openerId: string): void;
    _cloneItems(item: MenuItem, menu: Menu): void;
    _openItemSubMenu(item: MenuItem, opener: HTMLElement, actionId: string): void;
    _closeItemSubMenu(item: MenuItem, forceClose?: boolean): void;
    _closeSubMenuPopover(subMenu: Menu, forceClose?: boolean): void;
    _prepareSubMenuDesktopTablet(item: MenuItem, opener: HTMLElement, actionId: string): void;
    _prepareSubMenuPhone(item: MenuItem): void;
    _itemMouseOver(e: MouseEvent): void;
    _busyMouseOver(): void;
    _itemMouseOut(e: MouseEvent): void;
    _itemKeyDown(e: KeyboardEvent): void;
    _itemClick(e: CustomEvent<ListItemClickEventDetail>): void;
    _findMainMenu(item: MenuItem): Menu;
    _beforePopoverOpen(e: CustomEvent): void;
    _afterPopoverOpen(): void;
    _beforePopoverClose(e: CustomEvent<ResponsivePopoverBeforeCloseEventDetail>): void;
    _afterPopoverClose(): void;
}
export default Menu;
export type { MenuItemClickEventDetail, MenuBeforeCloseEventDetail, MenuBeforeOpenEventDetail, };
