import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type { ClassMap } from "@ui5/webcomponents-base/dist/types.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import "@ui5/webcomponents-icons/dist/decline.js";
import "@ui5/webcomponents-icons/dist/information.js";
import "@ui5/webcomponents-icons/dist/sys-enter-2.js";
import "@ui5/webcomponents-icons/dist/error.js";
import "@ui5/webcomponents-icons/dist/alert.js";
import MessageStripDesign from "./types/MessageStripDesign.js";
import Icon from "./Icon.js";
declare enum DesignClassesMapping {
    Information = "ui5-message-strip-root--info",
    Positive = "ui5-message-strip-root--positive",
    Negative = "ui5-message-strip-root--negative",
    Warning = "ui5-message-strip-root--warning"
}
declare enum IconMapping {
    Information = "information",
    Positive = "sys-enter-2",
    Negative = "error",
    Warning = "alert"
}
type DesignTypeAnnouncemnt = Record<MessageStripDesign, string>;
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-message-strip</code> component enables the embedding of app-related messages.
 * It displays 4 designs of messages, each with corresponding semantic color and icon: Information, Positive, Warning and Negative.
 * Each message can have a Close button, so that it can be removed from the UI, if needed.
 *
 * <h3>Usage</h3>
 *
 * For the <code>ui5-message-strip</code> component, you can define whether it displays
 * an icon in the beginning and a close button. Moreover, its size and background
 * can be controlled with CSS.
 *
 * <h3>Keyboard Handling</h3>
 *
 * <h4>Fast Navigation</h4>
 * This component provides a build in fast navigation group which can be used via <code>F6 / Shift + F6</code> or <code> Ctrl + Alt(Option) + Down /  Ctrl + Alt(Option) + Up</code>.
 * In order to use this functionality, you need to import the following module:
 * <code>import "@ui5/webcomponents-base/dist/features/F6Navigation.js"</code>
 * <br><br>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/MessageStrip";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.MessageStrip
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-message-strip
 * @public
 * @since 0.9.0
 */
declare class MessageStrip extends UI5Element {
    /**
     * Defines the component type.
     * <br><br>
     * <b>Note:</b> Available options are <code>"Information"</code>, <code>"Positive"</code>, <code>"Negative"</code>,
     * and <code>"Warning"</code>.
     *
     * @type {sap.ui.webc.main.types.MessageStripDesign}
     * @name sap.ui.webc.main.MessageStrip.prototype.design
     * @defaultvalue "Information"
     * @public
     * @since 1.0.0-rc.15
     */
    design: `${MessageStripDesign}`;
    /**
     * Defines whether the MessageStrip will show an icon in the beginning.
     * You can directly provide an icon with the <code>icon</code> slot. Otherwise, the default icon for the type will be used.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.MessageStrip.prototype.hideIcon
     * @defaultvalue false
     * @public
     * @since 1.0.0-rc.15
     */
    hideIcon: boolean;
    /**
     * Defines whether the MessageStrip renders close button.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.MessageStrip.prototype.hideCloseButton
     * @defaultvalue false
     * @public
     */
    hideCloseButton: boolean;
    /**
     * Defines the text of the component.
     * <br><br>
     * <b>Note:</b> Although this slot accepts HTML Elements, it is strongly recommended that you only use text in order to preserve the intended design.
     *
     * @type {Node[]}
     * @name sap.ui.webc.main.MessageStrip.prototype.default
     * @slot
     * @public
     */
    /**
     * Defines the content to be displayed as graphical element within the component.
     * <br><br>
     * <b>Note:</b> If no icon is given, the default icon for the component type will be used.
     * The SAP-icons font provides numerous options.
     * <br><br>
     *
     * See all the available icons in the <ui5-link target="_blank" href="https://sdk.openui5.org/test-resources/sap/m/demokit/iconExplorer/webapp/index.html">Icon Explorer</ui5-link>.
     *
     * @type {sap.ui.webc.main.IIcon}
     * @name sap.ui.webc.main.MessageStrip.prototype.icon
     * @slot
     * @public
     */
    icon: Array<Icon>;
    static i18nBundle: I18nBundle;
    _closeClick(): void;
    static onDefine(): Promise<void>;
    static designAnnouncementMappings(): DesignTypeAnnouncemnt;
    get hiddenText(): string;
    get _closeButtonText(): string;
    get _closableText(): string;
    get classes(): ClassMap;
    get iconProvided(): boolean;
    get standardIconName(): IconMapping;
    get designClasses(): DesignClassesMapping;
}
export default MessageStrip;
