import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type { ClassMap, Timeout } from "@ui5/webcomponents-base/dist/types.js";
import type { ResizeObserverCallback } from "@ui5/webcomponents-base/dist/delegate/ResizeHandler.js";
import ValueState from "@ui5/webcomponents-base/dist/types/ValueState.js";
import "@ui5/webcomponents-icons/dist/slim-arrow-down.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import "@ui5/webcomponents-icons/dist/decline.js";
import "@ui5/webcomponents-icons/dist/multiselect-all.js";
import "@ui5/webcomponents-icons/dist/not-editable.js";
import "@ui5/webcomponents-icons/dist/error.js";
import "@ui5/webcomponents-icons/dist/alert.js";
import "@ui5/webcomponents-icons/dist/sys-enter-2.js";
import "@ui5/webcomponents-icons/dist/information.js";
import MultiComboBoxItem from "./MultiComboBoxItem.js";
import Tokenizer from "./Tokenizer.js";
import type { TokenizerTokenDeleteEventDetail } from "./Tokenizer.js";
import Icon from "./Icon.js";
import Popover from "./Popover.js";
import ResponsivePopover from "./ResponsivePopover.js";
import List from "./List.js";
import type { ListSelectionChangeEventDetail } from "./List.js";
import ComboBoxFilter from "./types/ComboBoxFilter.js";
import type FormSupportT from "./features/InputElementsFormSupport.js";
import type ListItemBase from "./ListItemBase.js";
interface IMultiComboBoxItem extends UI5Element {
    text: string;
    selected: boolean;
    isGroupItem?: boolean;
    stableDomRef: string;
}
type ValueStateAnnouncement = Record<Exclude<ValueState, ValueState.None>, string>;
type ValueStateTypeAnnouncement = Record<Exclude<ValueState, ValueState.None>, string>;
type MultiComboBoxSelectionChangeEventDetail = {
    items: Array<MultiComboBoxItem>;
};
type MultiComboboxItemWithSelection = {
    ref: IMultiComboBoxItem;
    selected: boolean;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-multi-combobox</code> component consists of a list box with items and a text field allowing the user to either type a value directly into the text field, or choose from the list of existing items.
 *
 * The drop-down list is used for selecting and filtering values, it enables users to select one or more options from a predefined list. The control provides an editable input field to filter the list, and a dropdown arrow to expand/collapse the list of available options.
 * The options in the list have checkboxes that permit multi-selection. Entered values are displayed as tokens.
 * <h3>Structure</h3>
 * The <code>ui5-multi-combobox</code> consists of the following elements:
 * <ul>
 * <li> Tokenizer - a list of tokens with selected options.</li>
 * <li> Input field - displays the selected option/s as token/s. Users can type to filter the list.</li>
 * <li> Drop-down arrow - expands\collapses the option list.</li>
 * <li> Option list - the list of available options.</li>
 * </ul>
 * <h3>Keyboard Handling</h3>
 *
 * The <code>ui5-multi-combobox</code> provides advanced keyboard handling.
 *
 * <h4>Picker</h4>
 * If the <code>ui5-multi-combobox</code> is focused,
 * you can open or close the drop-down by pressing <code>F4</code>, <code>ALT+UP</code> or <code>ALT+DOWN</code> keys.
 * Once the drop-down is opened, you can use the <code>UP</code> and <code>DOWN</code> arrow keys
 * to navigate through the available options and select one by pressing the <code>Space</code> or <code>Enter</code> keys.
 * <br>
 *
 * <h4>Tokens</h4>
 * <ul>
 * <li> Left/Right arrow keys - moves the focus selection form the currently focused token to the previous/next one (if available). </li>
 * <li> Delete -  deletes the token and focuses the previous token. </li>
 * <li> Backspace -  deletes the token and focus the next token. </li>
 * </ul>
 *
 * <h3>CSS Shadow Parts</h3>
 *
 * <ui5-link target="_blank" href="https://developer.mozilla.org/en-US/docs/Web/CSS/::part">CSS Shadow Parts</ui5-link> allow developers to style elements inside the Shadow DOM.
 * <br>
 * The <code>ui5-multi-combobox</code> exposes the following CSS Shadow Parts:
 * <ul>
 * <li>token-{index} - Used to style each token(where <code>token-0</code> corresponds to the first item)</li>
 * </ul>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/MultiComboBox";</code>
 *
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.MultiComboBox
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-multi-combobox
 * @public
 * @appenddocs sap.ui.webc.main.MultiComboBoxItem sap.ui.webc.main.MultiComboBoxGroupItem
 * @since 0.11.0
 */
declare class MultiComboBox extends UI5Element {
    /**
     * Defines the value of the component.
     * <br><br>
     * <b>Note:</b> The property is updated upon typing.
     *
     * @type {string}
     * @name sap.ui.webc.main.MultiComboBox.prototype.value
     * @defaultvalue ""
     * @formEvents change input
     * @formProperty
     * @public
     */
    value: string;
    /**
     * Defines whether the value will be autcompleted to match an item
     *
     * @type {boolean}
     * @name sap.ui.webc.main.MultiComboBox.prototype.noTypeahead
     * @defaultvalue false
     * @public
     * @since 1.4.0
     */
    noTypeahead: boolean;
    /**
     * Defines a short hint intended to aid the user with data entry when the
     * component has no value.
     * @type {string}
     * @name sap.ui.webc.main.MultiComboBox.prototype.placeholder
     * @defaultvalue ""
     * @public
     */
    placeholder: string;
    /**
     * Defines if the user input will be prevented, if no matching item has been found
     *
     * @type {boolean}
     * @name sap.ui.webc.main.MultiComboBox.prototype.allowCustomValues
     * @defaultvalue false
     * @public
     */
    allowCustomValues: boolean;
    /**
     * Defines whether the component is in disabled state.
     * <br><br>
     * <b>Note:</b> A disabled component is completely noninteractive.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.MultiComboBox.prototype.disabled
     * @defaultvalue false
     * @public
     */
    disabled: boolean;
    /**
     * Defines the value state of the component.
     * <br><br>
     * Available options are:
     * <ul>
     * <li><code>None</code></li>
     * <li><code>Error</code></li>
     * <li><code>Warning</code></li>
     * <li><code>Success</code></li>
     * <li><code>Information</code></li>
     * </ul>
     *
     * @type {sap.ui.webc.base.types.ValueState}
     * @name sap.ui.webc.main.MultiComboBox.prototype.valueState
     * @defaultvalue "None"
     * @public
     */
    valueState: `${ValueState}`;
    /**
     * Defines whether the component is read-only.
     * <br><br>
     * <b>Note:</b> A read-only component is not editable,
     * but still provides visual feedback upon user interaction.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.MultiComboBox.prototype.readonly
     * @defaultvalue false
     * @public
     */
    readonly: boolean;
    /**
     * Defines whether the component is required.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.MultiComboBox.prototype.required
     * @defaultvalue false
     * @public
     * @since 1.0.0-rc.5
     */
    required: boolean;
    /**
     * Defines the filter type of the component.
     * Available options are: <code>StartsWithPerTerm</code>, <code>StartsWith</code>, <code>Contains</code> and <code>None</code>.
     *
     * @type {sap.ui.webc.main.types.ComboBoxFilter}
     * @name sap.ui.webc.main.MultiComboBox.prototype.filter
     * @defaultvalue "StartsWithPerTerm"
     * @public
     */
    filter: `${ComboBoxFilter}`;
    /**
     * Indicates whether the dropdown is open. True if the dropdown is open, false otherwise.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.MultiComboBox.prototype.open
     * @defaultvalue false
     * @readonly
     * @since 1.0.0-rc.5
     * @public
     */
    open: boolean;
    /**
     * Defines the accessible ARIA name of the component.
     *
     * @type {string}
     * @name sap.ui.webc.main.MultiComboBox.prototype.accessibleName
     * @defaultvalue: ""
     * @public
     * @since 1.4.0
     */
    accessibleName: string;
    /**
     * Receives id(or many ids) of the elements that label the component.
     *
     * @type {string}
     * @name sap.ui.webc.main.MultiComboBox.prototype.accessibleNameRef
     * @defaultvalue ""
     * @public
     * @since 1.4.0
     */
    accessibleNameRef: string;
    _filteredItems: Array<IMultiComboBoxItem>;
    filterSelected: boolean;
    focused: boolean;
    _tokenizerFocused: boolean;
    _iconPressed: boolean;
    _inputWidth: number;
    _listWidth: number;
    _performingSelectionTwice: boolean;
    /**
     * Indicates whether the tokenizer has tokens
     * @private
     */
    tokenizerAvailable: boolean;
    /**
     * Defines the component items.
     *
     * @type {sap.ui.webc.main.IMultiComboBoxItem[]}
     * @name sap.ui.webc.main.MultiComboBox.prototype.default
     * @slot items
     * @public
     */
    items: Array<IMultiComboBoxItem>;
    /**
    * Defines the icon to be displayed in the component.
    *
    * @type {sap.ui.webc.main.IIcon[]}
    * @name sap.ui.webc.main.MultiComboBox.prototype.icon
    * @slot
    * @public
    * @since 1.0.0-rc.9
    */
    icon: Array<Icon>;
    /**
     * Defines the value state message that will be displayed as pop up under the component.
     * <br><br>
     *
     * <b>Note:</b> If not specified, a default text (in the respective language) will be displayed.
     * <br>
     * <b>Note:</b> The <code>valueStateMessage</code> would be displayed,
     * when the component is in <code>Information</code>, <code>Warning</code> or <code>Error</code> value state.
     * @type {HTMLElement[]}
     * @name sap.ui.webc.main.MultiComboBox.prototype.valueStateMessage
     * @since 1.0.0-rc.9
     * @slot
     * @public
     */
    valueStateMessage: Array<HTMLElement>;
    selectedValues: Array<IMultiComboBoxItem>;
    _inputLastValue: string;
    _valueBeforeOpen: string;
    _deleting: boolean;
    _validationTimeout: Timeout | null;
    _handleResizeBound: ResizeObserverCallback;
    valueBeforeAutoComplete: string;
    currentItemIdx: number;
    _lastValue: string;
    _shouldFilterItems?: boolean;
    _showMorePressed?: boolean;
    allItemsPopover?: ResponsivePopover;
    valueStateHeader?: HTMLElement;
    list?: List;
    _shouldAutocomplete?: boolean;
    _preventTokenizerToggle?: boolean;
    _isOpenedByKeyboard?: boolean;
    _itemToFocus?: IMultiComboBoxItem;
    _itemsBeforeOpen: Array<MultiComboboxItemWithSelection>;
    selectedItems?: Array<IMultiComboBoxItem>;
    FormSupport?: typeof FormSupportT;
    static i18nBundle: I18nBundle;
    constructor();
    onEnterDOM(): void;
    onExitDOM(): void;
    _handleResize(): void;
    _inputChange(): void;
    togglePopover(): void;
    togglePopoverByDropdownIcon(): void;
    _showFilteredItems(): void;
    filterSelectedItems(e: MouseEvent): void;
    get _showAllItemsButtonPressed(): boolean;
    get _inputDom(): HTMLInputElement;
    _inputLiveChange(e: InputEvent): void;
    _tokenDelete(e: CustomEvent<TokenizerTokenDeleteEventDetail>): void;
    get _getPlaceholder(): string;
    _handleArrowLeft(): void;
    _tokenizerFocusOut(e: FocusEvent): void;
    _tokenizerFocusIn(): void;
    _onkeydown(e: KeyboardEvent): void;
    _handlePaste(): Promise<void>;
    _handleShow(e: KeyboardEvent): void;
    _handlePageUp(e: KeyboardEvent): void;
    _handlePageDown(e: KeyboardEvent): void;
    _handleBackspace(e: KeyboardEvent): void;
    _handleEscape(): void;
    _handleHome(e: KeyboardEvent): void;
    _handleEnd(e: KeyboardEvent): void;
    _handleTab(): void;
    _handleSelectAll(): void;
    _onValueStateKeydown(e: KeyboardEvent): void;
    _onItemKeydown(e: KeyboardEvent): Promise<void>;
    _handleArrowCtrl(e: KeyboardEvent): void;
    _onItemTab(): void;
    _handleArrowNavigation(e: KeyboardEvent, isDownControl: boolean): Promise<void>;
    _handleArrowDown(): void;
    _handleItemRangeSelection(e: KeyboardEvent): void;
    _navigateToNextItem(): void;
    _navigateToPrevItem(): void;
    _handleEnter(): void;
    _resetValueState(valueState: `${ValueState}`, callback?: () => void): void;
    _onTokenizerKeydown(e: KeyboardEvent): void;
    _filterItems(str: string): IMultiComboBoxItem[];
    /**
     * Returns true if the group header should be shown (if there is a filtered suggestion item for this group item)
     *
     * @private
     */
    static _groupItemFilter(item: IMultiComboBoxItem, idx: number, allItems: Array<IMultiComboBoxItem>, filteredItems: Array<IMultiComboBoxItem>): boolean | undefined;
    _afterOpenPicker(): void;
    _toggle(): void;
    _getSelectedItems(): Array<MultiComboBoxItem>;
    _listSelectionChange(e: CustomEvent<ListSelectionChangeEventDetail>): void;
    syncItems(listItems: Array<ListItemBase>): void;
    fireSelectionChange(): void;
    _getRespPopover(): Promise<void>;
    _getList(): Promise<List>;
    _click(): void;
    _afterClosePicker(): void;
    _beforeOpen(): void;
    _handleTypeAhead(item: IMultiComboBoxItem, filterValue: string): void;
    _getFirstMatchingItem(current: string): IMultiComboBoxItem | undefined;
    _startsWithMatchingItems(str: string): IMultiComboBoxItem[];
    onBeforeRendering(): void;
    onAfterRendering(): Promise<void>;
    get _isPhone(): boolean;
    _onIconMousedown(): void;
    storeResponsivePopoverWidth(): void;
    toggle(isToggled: boolean): void;
    handleCancel(): void;
    handleOK(): void;
    openPopover(): Promise<void>;
    _forwardFocusToInner(): void;
    closePopover(): Promise<void>;
    _getPopover(): Promise<Popover>;
    _getResponsivePopover(): Promise<ResponsivePopover>;
    _setValueStateHeader(): Promise<void>;
    get _tokenizer(): Tokenizer;
    inputFocusIn(e: FocusEvent): void;
    inputFocusOut(e: FocusEvent): void;
    get editable(): boolean;
    get _isFocusInside(): boolean;
    get selectedItemsListMode(): "None" | "MultiSelect";
    get _listItemsType(): "Inactive" | "Active";
    get hasValueState(): boolean;
    get hasValueStateMessage(): boolean;
    get ariaValueStateHiddenText(): string | undefined;
    get valueStateDefaultText(): string;
    get valueStateTextId(): "ui5-multi-combobox-valueStateDesc" | undefined;
    get valueStateMessageText(): Node[];
    get ariaLabelText(): string | undefined;
    /**
     * This method is relevant for sap_horizon theme only
     */
    get _valueStateMessageIcon(): string;
    get _tokensCountText(): string | undefined;
    get _tokensCountTextId(): string;
    get _selectedTokensCount(): number;
    get ariaDescribedByText(): string;
    get shouldDisplayDefaultValueStateMessage(): boolean;
    get shouldDisplayOnlyValueStateMessage(): boolean;
    get valueStateTypeMappings(): ValueStateTypeAnnouncement;
    get valueStateTextMappings(): ValueStateAnnouncement;
    get _innerInput(): HTMLInputElement;
    get _headerTitleText(): string;
    get _iconAccessibleNameText(): string;
    get _dialogOkButton(): string;
    get _tokenizerExpanded(): boolean;
    get _valueStatePopoverHorizontalAlign(): "Left" | "Right";
    get iconsCount(): number;
    get classes(): ClassMap;
    get styles(): {
        popoverValueStateMessage: {
            width: string;
            display: string;
        };
        popoverHeader: {
            "max-width": string;
        };
        suggestionsPopover: {
            "min-width": string;
            "max-width": string;
        };
    };
    static onDefine(): Promise<void>;
}
export default MultiComboBox;
export type { IMultiComboBoxItem, MultiComboBoxSelectionChangeEventDetail, };
