import Popup from "./Popup.js";
import type { PopupBeforeCloseEventDetail as PopoverBeforeCloseEventDetail } from "./Popup.js";
import PopoverPlacementType from "./types/PopoverPlacementType.js";
import PopoverVerticalAlign from "./types/PopoverVerticalAlign.js";
import PopoverHorizontalAlign from "./types/PopoverHorizontalAlign.js";
type PopoverSize = {
    width: number;
    height: number;
};
type ArrowPosition = {
    x: number;
    y: number;
};
type CalculatedPlacement = {
    arrow: ArrowPosition;
    top: number;
    left: number;
    placementType: `${PopoverPlacementType}`;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-popover</code> component displays additional information for an object
 * in a compact way and without leaving the page.
 * The Popover can contain various UI elements, such as fields, tables, images, and charts.
 * It can also include actions in the footer.
 *
 * <h3>Structure</h3>
 *
 * The popover has three main areas:
 * <ul>
 * <li>Header (optional)</li>
 * <li>Content</li>
 * <li>Footer (optional)</li>
 * </ul>
 *
 * <b>Note:</b> The <code>ui5-popover</code> is closed when the user clicks
 * or taps outside the popover
 * or selects an action within the popover. You can prevent this with the
 * <code>modal</code> property.
 *
 * <h3>CSS Shadow Parts</h3>
 *
 * <ui5-link target="_blank" href="https://developer.mozilla.org/en-US/docs/Web/CSS/::part">CSS Shadow Parts</ui5-link> allow developers to style elements inside the Shadow DOM.
 * <br>
 * The <code>ui5-popover</code> exposes the following CSS Shadow Parts:
 * <ul>
 * <li>header - Used to style the header of the component</li>
 * <li>content - Used to style the content of the component</li>
 * <li>footer - Used to style the footer of the component</li>
 * </ul>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/Popover.js";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.Popover
 * @extends sap.ui.webc.main.Popup
 * @tagname ui5-popover
 * @since 1.0.0-rc.6
 * @public
 */
declare class Popover extends Popup {
    /**
     * Defines the header text.
     * <br><br>
     * <b>Note:</b> If <code>header</code> slot is provided, the <code>headerText</code> is ignored.
     *
     * @type {string}
     * @name sap.ui.webc.main.Popover.prototype.headerText
     * @defaultvalue ""
     * @public
     */
    headerText: string;
    /**
     * Determines on which side the component is placed at.
     * <br><br>
     * Available options are:
     * <ul>
     * <li><code>Left</code></li>
     * <li><code>Right</code></li>
     * <li><code>Top</code></li>
     * <li><code>Bottom</code></li>
     * </ul>
     *
     * @type {sap.ui.webc.main.types.PopoverPlacementType}
     * @name sap.ui.webc.main.Popover.prototype.placementType
     * @defaultvalue "Right"
     * @public
     */
    placementType: `${PopoverPlacementType}`;
    /**
     * Determines the horizontal alignment of the component.
     * <br><br>
     * Available options are:
     * <ul>
     * <li><code>Center</code></li>
     * <li><code>Left</code></li>
     * <li><code>Right</code></li>
     * <li><code>Stretch</code></li>
     * </ul>
     *
     * @type {sap.ui.webc.main.types.PopoverHorizontalAlign}
     * @name sap.ui.webc.main.Popover.prototype.horizontalAlign
     * @defaultvalue "Center"
     * @public
     */
    horizontalAlign: `${PopoverHorizontalAlign}`;
    /**
     * Determines the vertical alignment of the component.
     * <br><br>
     * Available options are:
     * <ul>
     * <li><code>Center</code></li>
     * <li><code>Top</code></li>
     * <li><code>Bottom</code></li>
     * <li><code>Stretch</code></li>
     * </ul>
     *
     * @type {sap.ui.webc.main.types.PopoverVerticalAlign}
     * @name sap.ui.webc.main.Popover.prototype.verticalAlign
     * @defaultvalue "Center"
     * @public
     */
    verticalAlign: `${PopoverVerticalAlign}`;
    /**
     * Defines whether the component should close when
     * clicking/tapping outside of the popover.
     * If enabled, it blocks any interaction with the background.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.Popover.prototype.modal
     * @defaultvalue false
     * @public
     */
    modal: boolean;
    /**
     * Defines whether the block layer will be shown if modal property is set to true.
     * @type {boolean}
     * @name sap.ui.webc.main.Popover.prototype.hideBackdrop
     * @defaultvalue false
     * @public
     * @since 1.0.0-rc.10
     */
    hideBackdrop: boolean;
    /**
     * Determines whether the component arrow is hidden.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.Popover.prototype.hideArrow
     * @defaultvalue false
     * @public
     * @since 1.0.0-rc.15
     */
    hideArrow: boolean;
    /**
     * Determines if there is no enough space, the component can be placed
     * over the target.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.Popover.prototype.allowTargetOverlap
     * @defaultvalue false
     * @public
     */
    allowTargetOverlap: boolean;
    /**
     * Defines the ID or DOM Reference of the element that the popover is shown at
     * @public
     * @type {sap.ui.webc.base.types.DOMReference}
     * @name sap.ui.webc.main.Popover.prototype.opener
     * @defaultvalue undefined
     * @since 1.2.0
     */
    opener?: HTMLElement | string;
    /**
     * Defines whether the content is scrollable.
     *
     * @type {boolean}
     * @defaultvalue false
     * @private
     */
    disableScrolling: boolean;
    /**
     * Sets the X translation of the arrow
     *
     * @private
     */
    arrowTranslateX: number;
    /**
     * Sets the Y translation of the arrow
     *
     * @private
     */
    arrowTranslateY: number;
    /**
     * Returns the calculated placement depending on the free space
     *
     * @private
     */
    actualPlacementType: `${PopoverPlacementType}`;
    _maxHeight?: number;
    _maxWidth?: number;
    /**
     * Defines the header HTML Element.
     *
     * @type {HTMLElement[]}
     * @name sap.ui.webc.main.Popover.prototype.header
     * @slot
     * @public
     */
    header: Array<HTMLElement>;
    /**
     * Defines the footer HTML Element.
     *
     * @type {HTMLElement[]}
     * @name sap.ui.webc.main.Popover.prototype.footer
     * @slot
     * @public
     */
    footer: Array<HTMLElement>;
    _opener?: HTMLElement;
    _openerRect?: DOMRect;
    _preventRepositionAndClose?: boolean;
    _top?: number;
    _left?: number;
    _oldPlacement?: CalculatedPlacement;
    _width?: string;
    static get VIEWPORT_MARGIN(): number;
    constructor();
    onAfterRendering(): void;
    isOpenerClicked(e: MouseEvent): boolean;
    /**
     * Shows the popover.
     * @param {HTMLElement} opener the element that the popover is shown at
     * @param {boolean} [preventInitialFocus=false] prevents applying the focus inside the popover
     * @public
     * @async
     * @method
     * @name sap.ui.webc.main.Popover#showAt
     * @async
     * @returns {Promise} Resolved when the popover is open
     */
    showAt(opener: HTMLElement, preventInitialFocus?: boolean): Promise<void>;
    /**
     * Override for the _addOpenedPopup hook, which would otherwise just call addOpenedPopup(this)
     * @private
     */
    _addOpenedPopup(): void;
    /**
     * Override for the _removeOpenedPopup hook, which would otherwise just call removeOpenedPopup(this)
     * @private
     */
    _removeOpenedPopup(): void;
    shouldCloseDueToOverflow(placement: `${PopoverPlacementType}`, openerRect: DOMRect): boolean;
    shouldCloseDueToNoOpener(openerRect: DOMRect): boolean;
    isOpenerOutsideViewport(openerRect: DOMRect): boolean;
    /**
     * @override
     */
    _resize(): void;
    reposition(): void;
    _show(): void;
    /**
     * Adjust the desired top position to compensate for shift of the screen
     * caused by opened keyboard on iOS which affects all elements with position:fixed.
     * @private
     * @param {int} top The target top in px.
     * @returns {int} The adjusted top in px.
     */
    _adjustForIOSKeyboard(top: number): number;
    getPopoverSize(): PopoverSize;
    get arrowDOM(): Element;
    /**
     * @private
     */
    calcPlacement(targetRect: DOMRect, popoverSize: PopoverSize): CalculatedPlacement;
    /**
     * Calculates the position for the arrow.
     * @private
     * @param targetRect BoundingClientRect of the target element
     * @param {{width: number, height: number}} popoverSize Width and height of the popover
     * @param left Left offset of the popover
     * @param top Top offset of the popover
     * @param isVertical If the popover is positioned vertically to the target element
     * @param {number} borderRadius Value of the border-radius property
     * @returns {{x: number, y: number}} Arrow's coordinates
     */
    getArrowPosition(targetRect: DOMRect, popoverSize: PopoverSize, left: number, top: number, isVertical: boolean, borderRadius: number): ArrowPosition;
    /**
     * Fallbacks to new placement, prioritizing <code>Left</code> and <code>Right</code> placements.
     * @private
     */
    fallbackPlacement(clientWidth: number, clientHeight: number, targetRect: DOMRect, popoverSize: PopoverSize): PopoverPlacementType | undefined;
    getActualPlacementType(targetRect: DOMRect, popoverSize: PopoverSize): `${PopoverPlacementType}`;
    getVerticalLeft(targetRect: DOMRect, popoverSize: PopoverSize): number;
    getHorizontalTop(targetRect: DOMRect, popoverSize: PopoverSize): number;
    get isModal(): boolean;
    get shouldHideBackdrop(): boolean;
    get _ariaLabelledBy(): "ui5-popup-header" | undefined;
    get styles(): {
        root: {
            "max-height": string;
            "max-width": string;
        };
        arrow: {
            transform: string;
        };
        content: {};
        blockLayer: {
            zIndex: string | number;
        };
    };
    get classes(): import("@ui5/webcomponents-base/dist/types.js").ClassMap;
    /**
     * Hook for descendants to hide header.
     */
    get _displayHeader(): boolean;
    /**
     * Hook for descendants to hide footer.
     */
    get _displayFooter(): boolean;
    get _actualHorizontalAlign(): "Left" | "Right" | PopoverHorizontalAlign.Left | PopoverHorizontalAlign.Right | "Center" | "Stretch";
}
declare const instanceOfPopover: (object: any) => object is Popover;
export default Popover;
export { instanceOfPopover };
export type { PopoverBeforeCloseEventDetail, };
