import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import ValueState from "@ui5/webcomponents-base/dist/types/ValueState.js";
import "@ui5/webcomponents-icons/dist/slim-arrow-down.js";
import "@ui5/webcomponents-icons/dist/error.js";
import "@ui5/webcomponents-icons/dist/alert.js";
import "@ui5/webcomponents-icons/dist/sys-enter-2.js";
import "@ui5/webcomponents-icons/dist/information.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import "@ui5/webcomponents-icons/dist/decline.js";
import type { Timeout } from "@ui5/webcomponents-base/dist/types.js";
import type { ListItemClickEventDetail } from "./List.js";
import Option from "./Option.js";
import ResponsivePopover from "./ResponsivePopover.js";
import Popover from "./Popover.js";
import type { IFormElement } from "./features/InputElementsFormSupport.js";
import type ListItemBase from "./ListItemBase.js";
type SelectChangeEventDetail = {
    selectedOption: Option;
};
interface IOption extends UI5Element {
    selected: boolean;
    _focused: boolean;
    icon?: string | undefined;
    value: string;
    textContent: string | null;
    title: string;
    additionalText: string;
    id: string;
    stableDomRef: string;
}
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 * The <code>ui5-select</code> component is used to create a drop-down list.
 * The items inside the <code>ui5-select</code> define the available options by using the <code>ui5-option</code> component.
 *
 * <h3>Keyboard Handling</h3>
 * The <code>ui5-select</code> provides advanced keyboard handling.
 * <br>
 * <ul>
 * <li>[F4, ALT+UP, ALT+DOWN, SPACE, ENTER] - Opens/closes the drop-down.</li>
 * <li>[UP, DOWN] - If the drop-down is closed - changes selection to the next or the previous option. If the drop-down is opened - moves focus to the next or the previous option.</li>
 * <li>[SPACE, ENTER] - If the drop-down is opened - selects the focused option.</li>
 * <li>[ESC] - Closes the drop-down without changing the selection.</li>
 * <li>[HOME] - Navigates to first option</li>
 * <li>[END] - Navigates to the last option</li>
 * </ul>
 * <br>
 *
 * <h3>ES6 Module Import</h3>
 * <code>import "@ui5/webcomponents/dist/Select";</code>
 * <br>
 * <code>import "@ui5/webcomponents/dist/Option";</code> (comes with <code>ui5-select</code>)
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.Select
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-select
 * @appenddocs sap.ui.webc.main.Option
 * @public
 * @since 0.8.0
 */
declare class Select extends UI5Element implements IFormElement {
    static i18nBundle: I18nBundle;
    /**
     * Defines whether the component is in disabled state.
     * <br><br>
     * <b>Note:</b> A disabled component is noninteractive.
     *
     * @type {boolean}
     * @defaultvalue false
     * @name sap.ui.webc.main.Select.prototype.disabled
     * @public
     */
    disabled: boolean;
    /**
     * Determines the name with which the component will be submitted in an HTML form.
     * The value of the component will be the value of the currently selected <code>ui5-option</code>.
     *
     * <br><br>
     * <b>Important:</b> For the <code>name</code> property to have effect, you must add the following import to your project:
     * <code>import "@ui5/webcomponents/dist/features/InputElementsFormSupport.js";</code>
     *
     * <br><br>
     * <b>Note:</b> When set, a native <code>input</code> HTML element
     * will be created inside the <code>ui5-select</code> so that it can be submitted as
     * part of an HTML form. Do not use this property unless you need to submit a form.
     *
     * @type {string}
     * @defaultvalue ""
     * @name sap.ui.webc.main.Select.prototype.name
     * @public
     */
    name: string;
    /**
     * Defines the value state of the component.
     * <br><br>
     * Available options are:
     * <ul>
     * <li><code>None</code></li>
     * <li><code>Error</code></li>
     * <li><code>Warning</code></li>
     * <li><code>Success</code></li>
     * <li><code>Information</code></li>
     * </ul>
     *
     * @type {sap.ui.webc.base.types.ValueState}
     * @defaultvalue "None"
     * @name sap.ui.webc.main.Select.prototype.valueState
     * @public
     */
    valueState: `${ValueState}`;
    /**
     * Defines whether the component is required.
     *
     * @since 1.0.0-rc.9
     * @type {boolean}
     * @defaultvalue false
     * @name sap.ui.webc.main.Select.prototype.required
     * @public
     */
    required: boolean;
    /**
     * Defines the accessible ARIA name of the component.
     *
     * @type {string}
     * @since 1.0.0-rc.9
     * @public
     * @defaultvalue ""
     * @name sap.ui.webc.main.Select.prototype.accessibleName
     * @since 1.0.0-rc.15
     */
    accessibleName: string;
    /**
     * Receives id(or many ids) of the elements that label the select.
     *
     * @type {string}
     * @defaultvalue ""
     * @name sap.ui.webc.main.Select.prototype.accessibleNameRef
     * @public
     * @since 1.0.0-rc.15
     */
    accessibleNameRef: string;
    /**
     * @private
     */
    _text?: string | null;
    /**
     * @private
     */
    _iconPressed: boolean;
    /**
     * @private
     */
    opened: boolean;
    /**
     * @type {sap.ui.webc.base.types.Integer}
     * @private
     */
    _listWidth: number;
    /**
     * @private
     */
    focused: boolean;
    _syncedOptions: Array<IOption>;
    _selectedIndex: number;
    _selectedIndexBeforeOpen: number;
    _escapePressed: boolean;
    _lastSelectedOption: Option | null;
    _typedChars: string;
    _typingTimeoutID?: Timeout | number;
    responsivePopover: ResponsivePopover;
    selectedItem?: string | null;
    popover?: Popover;
    value: string;
    /**
     * Defines the component options.
     *
     * <br><br>
     * <b>Note:</b> Only one selected option is allowed.
     * If more than one option is defined as selected, the last one would be considered as the selected one.
     *
     * <br><br>
     * <b>Note:</b> Use the <code>ui5-option</code> component to define the desired options.
     * @type {sap.ui.webc.main.ISelectOption[]}
     * @slot options
     * @name sap.ui.webc.main.Select.prototype.default
     * @public
     */
    options: Array<Option>;
    /**
     * The slot is used to render native <code>input</code> HTML element within Light DOM to enable form submit,
     * when <code>name</code> property is set.
     * @type {HTMLElement[]}
     * @slot
     * @private
     */
    formSupport: Array<HTMLElement>;
    /**
     * Defines the value state message that will be displayed as pop up under the component.
     * <br><br>
     *
     * <b>Note:</b> If not specified, a default text (in the respective language) will be displayed.
     * <br><br>
     * <b>Note:</b> The <code>valueStateMessage</code> would be displayed,
     * when the component is in <code>Information</code>, <code>Warning</code> or <code>Error</code> value state.
     * <br><br>
     * <b>Note:</b> If the component has <code>suggestionItems</code>,
     * the <code>valueStateMessage</code> would be displayed as part of the same popover, if used on desktop, or dialog - on phone.
     * @type {HTMLElement[]}
     * @name sap.ui.webc.main.Select.prototype.valueStateMessage
     * @slot
     * @public
    */
    valueStateMessage: Array<HTMLElement>;
    constructor();
    onBeforeRendering(): void;
    onAfterRendering(): void;
    _onfocusin(): void;
    _onfocusout(): void;
    get _isPickerOpen(): boolean;
    _respPopover(): Promise<ResponsivePopover>;
    /**
     * Currently selected <code>ui5-option</code> element.
     * @readonly
     * @type {sap.ui.webc.main.ISelectOption}
     * @name sap.ui.webc.main.Select.prototype.selectedOption
     * @public
     */
    get selectedOption(): Option | undefined;
    _toggleRespPopover(): Promise<void>;
    _attachRealDomRefs(): Promise<void>;
    _syncSelection(): void;
    _enableFormSupport(): void;
    _onkeydown(e: KeyboardEvent): void;
    _handleKeyboardNavigation(e: KeyboardEvent): void;
    _selectTypedItem(text: string): void;
    _searchNextItemByText(text: string): Option | undefined;
    _handleHomeKey(e: KeyboardEvent): void;
    _handleEndKey(e: KeyboardEvent): void;
    _onkeyup(e: KeyboardEvent): void;
    _getSelectedItemIndex(item: ListItemBase): number;
    _select(index: number): void;
    /**
     * The user clicked on an item from the list
     * @private
     */
    _handleItemPress(e: CustomEvent<ListItemClickEventDetail>): void;
    _itemMousedown(e: MouseEvent): void;
    _onclick(): void;
    /**
     * The user selected an item with Enter or Space
     * @private
     */
    _handleSelectionChange(index?: number): void;
    _handleArrowNavigation(e: KeyboardEvent): void;
    _changeSelectedItem(oldIndex: number, newIndex: number): void;
    _getNextOptionIndex(): number;
    _getPreviousOptionIndex(): number;
    _beforeOpen(): void;
    _afterOpen(): void;
    _afterClose(): void;
    _fireChangeEvent(selectedOption: Option): void;
    get valueStateTextMappings(): {
        Success: string;
        Information: string;
        Error: string;
        Warning: string;
    };
    get valueStateTypeMappings(): {
        Success: string;
        Information: string;
        Error: string;
        Warning: string;
    };
    get valueStateText(): string;
    get valueStateDefaultText(): string;
    get valueStateTypeText(): string;
    get hasValueState(): boolean;
    get valueStateTextId(): string | undefined;
    get isDisabled(): true | undefined;
    get _headerTitleText(): string;
    get _currentlySelectedOption(): Option;
    get _effectiveTabIndex(): "0" | "-1";
    /**
    * This method is relevant for sap_horizon theme only
    */
    get _valueStateMessageInputIcon(): string;
    get iconsCount(): number;
    get classes(): {
        popoverValueState: {
            "ui5-valuestatemessage-root": boolean;
            "ui5-valuestatemessage--success": boolean;
            "ui5-valuestatemessage--error": boolean;
            "ui5-valuestatemessage--warning": boolean;
            "ui5-valuestatemessage--information": boolean;
        };
        popover: {
            "ui5-select-popover-valuestate": boolean;
        };
    };
    get styles(): {
        popoverHeader: {
            "max-width": string;
        };
        responsivePopoverHeader: {
            display: string;
            width: string;
        };
        responsivePopover: {
            "min-width": string;
        };
    };
    get ariaLabelText(): string | undefined;
    get valueStateMessageText(): Node[];
    get shouldDisplayDefaultValueStateMessage(): boolean;
    get hasValueStateText(): boolean;
    get shouldOpenValueStateMessagePopover(): boolean;
    get _ariaRoleDescription(): string;
    get _isPhone(): boolean;
    get _filteredItems(): Option[];
    itemSelectionAnnounce(): void;
    openValueStatePopover(): Promise<void>;
    closeValueStatePopover(): void;
    toggleValueStatePopover(open: boolean): void;
    get selectedOptionIcon(): string | undefined;
    _getPopover(): Promise<Popover | null>;
    static onDefine(): Promise<void>;
}
export default Select;
export type { SelectChangeEventDetail, IOption, };
