var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var SplitButton_1;
import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import customElement from "@ui5/webcomponents-base/dist/decorators/customElement.js";
import event from "@ui5/webcomponents-base/dist/decorators/event.js";
import property from "@ui5/webcomponents-base/dist/decorators/property.js";
import slot from "@ui5/webcomponents-base/dist/decorators/slot.js";
import { isEscape, isSpace, isEnter, isDown, isUp, isDownAlt, isUpAlt, isF4, isShift, } from "@ui5/webcomponents-base/dist/Keys.js";
import { getI18nBundle } from "@ui5/webcomponents-base/dist/i18nBundle.js";
import { getEventMark } from "@ui5/webcomponents-base/dist/MarkedEvents.js";
import litRender from "@ui5/webcomponents-base/dist/renderer/LitRenderer.js";
import "@ui5/webcomponents-icons/dist/slim-arrow-down.js";
import ButtonDesign from "./types/ButtonDesign.js";
import Button from "./Button.js";
import { SPLIT_BUTTON_DESCRIPTION, SPLIT_BUTTON_KEYBOARD_HINT, } from "./generated/i18n/i18n-defaults.js";
// Template
import SplitButtonTemplate from "./generated/templates/SplitButtonTemplate.lit.js";
// Styles
import SplitButtonCss from "./generated/themes/SplitButton.css.js";
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * <code>ui5-split-button</code> enables users to trigger actions. It is constructed of two separate actions -
 * default action and arrow action that can be activated by clicking or tapping, or by
 * pressing certain keyboard keys - <code>Space</code> or <code>Enter</code> for default action,
 * and <code>Arrow Down</code> or <code>Arrow Up</code> for arrow action.
 *
 * <h3>Usage</h3>
 *
 * <code>ui5-split-button</code> consists two separate buttons:
 * <ul>
 * <li>for the first one (default action) you can define some <code>text</code> or an <code>icon</code>, or both.
 * Also, it is possible to define different icon for active state of this button - <code>activeIcon</code>.</li>
 * <li>the second one (arrow action) contains only <code>slim-arrow-down</code> icon.</li>
 * </ul>
 * You can choose a <code>design</code> from a set of predefined types (the same as for ui5-button) that offer
 * different styling to correspond to the triggered action. Both text and arrow actions have the same design.
 * <br><br>
 * You can set the <code>ui5-split-button</code> as enabled or disabled. Both parts of an enabled
 * <code>ui5-split-button</code> can be pressed by clicking or tapping it, or by certain keys, which changes
 * the style to provide visual feedback to the user that it is pressed or hovered over with
 * the mouse cursor. A disabled <code>ui5-split-button</code> appears inactive and any of the two buttons
 * cannot be pressed.
 *
 * <h3>Keyboard Handling</h3>
 * <ul>
 * <li><code>Space</code> or <code>Enter</code> - triggers the default action</li>
 * <li><code>Shift</code> or <code>Escape</code> - if <code>Space</code> is pressed, releases the default action button without triggering the click event.</li>
 * <li><code>Arrow Down</code>, <code>Arrow Up</code>, <code>Alt</code>+<code>Arrow Down</code>, <code>Alt</code>+<code>Arrow Up</code>, or <code>F4</code> - triggers the arrow action</li>
 * There are separate events that are fired on activating of <code>ui5-split-button</code> parts:
 * <ul>
 * <li><code>click</code> for the first button (default action)</li>
 * <li><code>arrow-click</code> for the second button (arrow action)</li>
 * </ul>
 * </ul>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/SplitButton.js";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.SplitButton
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-split-button
 * @public
 * @since 1.1.0
 */
let SplitButton = SplitButton_1 = class SplitButton extends UI5Element {
    static async onDefine() {
        SplitButton_1.i18nBundle = await getI18nBundle("@ui5/webcomponents");
    }
    constructor() {
        super();
        const handleTouchStartEvent = () => {
            this._textButtonActive = true;
            this.focused = false;
            this._setTabIndexValue();
        };
        this._textButtonPress = {
            handleEvent: handleTouchStartEvent,
            passive: true,
        };
    }
    onBeforeRendering() {
        this._textButtonIcon = this.textButton && this.activeIcon !== "" && (this._textButtonActive) && !this._shiftOrEscapePressed ? this.activeIcon : this.icon;
        if (this.disabled) {
            this._tabIndex = "-1";
        }
    }
    _onFocusOut(e) {
        if (this.disabled || getEventMark(e)) {
            return;
        }
        this._shiftOrEscapePressed = false;
        this.focused = false;
        this._setTabIndexValue();
    }
    _onFocusIn(e) {
        if (this.disabled || getEventMark(e)) {
            return;
        }
        this._shiftOrEscapePressed = false;
        this.focused = true;
    }
    _onKeyDown(e) {
        if (isDown(e) || isUp(e) || isDownAlt(e) || isUpAlt(e) || isF4(e)) {
            e.preventDefault();
            this._arrowButtonActive = true;
            this._fireArrowClick();
        }
        else if (isSpace(e) || isEnter(e)) {
            e.preventDefault();
            this._textButtonActive = true;
            if (isEnter(e)) {
                this._fireClick();
            }
            else {
                this._spacePressed = true;
            }
        }
        if (this._spacePressed && (isEscape(e) || isShift(e))) {
            this._shiftOrEscapePressed = true;
            this._textButtonActive = false;
        }
        this._setTabIndexValue();
    }
    _onKeyUp(e) {
        if (isDown(e) || isUp(e) || isDownAlt(e) || isUpAlt(e) || isF4(e)) {
            this._arrowButtonActive = false;
        }
        else if (isSpace(e) || isEnter(e)) {
            this._textButtonActive = false;
            if (isSpace(e)) {
                e.preventDefault();
                e.stopPropagation();
                this._fireClick();
                this._spacePressed = false;
            }
        }
        this._setTabIndexValue();
    }
    _fireClick(e) {
        e?.stopPropagation();
        if (!this._shiftOrEscapePressed) {
            this.fireEvent("click");
        }
        this._shiftOrEscapePressed = false;
    }
    _fireArrowClick(e) {
        e?.stopPropagation();
        this.fireEvent("arrow-click");
    }
    _textButtonRelease() {
        this._textButtonActive = false;
        this._textButtonIcon = this.textButton && this.activeIcon !== "" && (this._textButtonActive) && !this._shiftOrEscapePressed ? this.activeIcon : this.icon;
        this._setTabIndexValue();
    }
    _setTabIndexValue() {
        const textButton = this.textButton, arrowButton = this.arrowButton, buttonsAction = (textButton && (textButton.focused || textButton.active))
            || (arrowButton && (arrowButton.focused || arrowButton.active));
        this._tabIndex = this.disabled || buttonsAction ? "-1" : "0";
    }
    get textButtonAccText() {
        return this.textContent;
    }
    get isTextButton() {
        return !!this.textContent;
    }
    get textButton() {
        return this.getDomRef()?.querySelector(".ui5-split-text-button");
    }
    get arrowButton() {
        return this.getDomRef()?.querySelector(".ui5-split-arrow-button");
    }
    get accessibilityInfo() {
        return {
            // affects arrow button
            ariaExpanded: this._splitButtonAccInfo && this._splitButtonAccInfo.ariaExpanded,
            ariaHaspopup: this._splitButtonAccInfo && this._splitButtonAccInfo.ariaHaspopup,
            // affects root element
            description: SplitButton_1.i18nBundle.getText(SPLIT_BUTTON_DESCRIPTION),
            keyboardHint: SplitButton_1.i18nBundle.getText(SPLIT_BUTTON_KEYBOARD_HINT),
        };
    }
    get ariaLabelText() {
        return [SplitButton_1.i18nBundle.getText(SPLIT_BUTTON_DESCRIPTION), SplitButton_1.i18nBundle.getText(SPLIT_BUTTON_KEYBOARD_HINT)].join(" ");
    }
};
__decorate([
    property()
], SplitButton.prototype, "icon", void 0);
__decorate([
    property()
], SplitButton.prototype, "activeIcon", void 0);
__decorate([
    property({ type: ButtonDesign, defaultValue: ButtonDesign.Default })
], SplitButton.prototype, "design", void 0);
__decorate([
    property({ type: Boolean })
], SplitButton.prototype, "disabled", void 0);
__decorate([
    property({ defaultValue: undefined })
], SplitButton.prototype, "accessibleName", void 0);
__decorate([
    property({ type: Boolean })
], SplitButton.prototype, "focused", void 0);
__decorate([
    property({ type: Object })
], SplitButton.prototype, "_splitButtonAccInfo", void 0);
__decorate([
    property({ defaultValue: "0", noAttribute: true })
], SplitButton.prototype, "_tabIndex", void 0);
__decorate([
    property({ type: Boolean, noAttribute: true })
], SplitButton.prototype, "_spacePressed", void 0);
__decorate([
    property({ type: Boolean, noAttribute: true })
], SplitButton.prototype, "_shiftOrEscapePressed", void 0);
__decorate([
    property({ type: Boolean, noAttribute: true })
], SplitButton.prototype, "_textButtonActive", void 0);
__decorate([
    property({ noAttribute: true })
], SplitButton.prototype, "_textButtonIcon", void 0);
__decorate([
    property({ type: Boolean, noAttribute: true })
], SplitButton.prototype, "_arrowButtonActive", void 0);
__decorate([
    slot({ type: Node, "default": true })
], SplitButton.prototype, "text", void 0);
SplitButton = SplitButton_1 = __decorate([
    customElement({
        tag: "ui5-split-button",
        renderer: litRender,
        styles: SplitButtonCss,
        template: SplitButtonTemplate,
        dependencies: [Button],
    })
    /**
     * Fired when the user clicks on the default action.
     * @event sap.ui.webc.main.SplitButton#click
     * @public
     */
    ,
    event("click")
    /**
     * Fired when the user clicks on the arrow action.
     * @event sap.ui.webc.main.SplitButton#arrow-click
     * @public
     */
    ,
    event("arrow-click")
], SplitButton);
SplitButton.define();
export default SplitButton;
//# sourceMappingURL=SplitButton.js.map