import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type { ResizeObserverCallback } from "@ui5/webcomponents-base/dist/delegate/ResizeHandler.js";
import ItemNavigation from "@ui5/webcomponents-base/dist/delegate/ItemNavigation.js";
import type { ITabbable } from "@ui5/webcomponents-base/dist/delegate/ItemNavigation.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import TableGrowingMode from "./types/TableGrowingMode.js";
import type { TableRowClickEventDetail, TableRowSelectionRequestedEventDetail, TableRowF7PressEventDetail, TableRowForwardBeforeEventDetail, TableRowForwardAfterEventDetail } from "./TableRow.js";
import type TableCell from "./TableCell.js";
import type TableColumn from "./TableColumn.js";
import type TableColumnPopinDisplay from "./types/TableColumnPopinDisplay.js";
import TableMode from "./types/TableMode.js";
interface ITableRow extends UI5Element {
    mode: `${TableMode}`;
    selected: boolean;
    _busy: boolean;
    _tabIndex: string;
    _ariaPosition: string;
    _columnsInfoString: string;
    _columnsInfo: Array<TableColumnInfo>;
    _tabbables: Array<HTMLElement>;
}
type TableColumnInfo = {
    cell?: TableCell;
    index?: number;
    text?: string | null;
    visible?: boolean;
    demandPopin?: boolean;
    popinText?: string;
    popinDisplay?: `${TableColumnPopinDisplay}`;
    popinDisplayInline?: boolean;
    classes?: string;
    minWidth?: number;
};
type TableColumnHeaderInfo = ITabbable;
type TableSelectionChangeEventDetail = {
    selectedRows: Array<ITableRow>;
    previouslySelectedRows: Array<ITableRow>;
};
type TablePopinChangeEventDetail = {
    poppedColumns: Array<TableColumnInfo>;
};
declare enum TableFocusTargetElement {
    Row = "tableRow",
    GroupRow = "tableGroupRow",
    ColumnHeader = "columnHeader",
    MoreButton = "moreButton"
}
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-table</code> component provides a set of sophisticated and convenient functions for responsive table design.
 * It provides a comprehensive set of features for displaying and dealing with vast amounts of data.
 * <br><br>
 * To render the <code>Table</code> properly, the order of the <code>columns</code> should match with the
 * order of the item <code>cells</code> in the <code>rows</code>.
 * <br><br>
 * Desktop and tablet devices are supported.
 * On tablets, special consideration should be given to the number of visible columns
 * and rows due to the limited performance of some devices.
 *
 * <h3>Selection</h3>
 * To benefit from the selection mechanism of <code>ui5-table</code> component, you can use the available selection modes:
 * <code>SingleSelect</code> and <code>MultiSelect</code>.
 * <br>
 * In additition to the used mode, you can also specify the <code>ui5-table-row</code> type choosing between
 * <code>Active</code> or <code>Inactive</code>.
 * <br><br>
 * In <code>SingleSelect</code> mode, you can select both an <code>Active</code> and <code>Inactive</code> row via mouse or
 * by pressing the <code>Space</code> or <code>Enter</code> keys.
 * <br>
 * In <code>MultiSelect</code> mode, you can select both an <code>Active</code> and <code>Inactive</code> row by pressing the
 * <code>Space</code> key when a row is on focus or via mouse click over the selection checkbox of the row.
 * In order to select all the available rows at once, you can use the selection checkbox presented in the table's header.
 * <br><br>
 * <b>Note:</b> Currently, when a column is shown as a pop-in, the visual indication for selection is not presented over it.
 *
 * <h3>Keyboard Handling</h3>
 *
 * <h4>Fast Navigation</h4>
 * This component provides a build in fast navigation group which can be used via <code>F6 / Shift + F6</code> or <code> Ctrl + Alt(Option) + Down /  Ctrl + Alt(Option) + Up</code>.
 * In order to use this functionality, you need to import the following module:
 * <code>import "@ui5/webcomponents-base/dist/features/F6Navigation.js"</code>
 * <br><br>
 * Furthermore, you can interact with <code>ui5-table</code> via the following keys.
 * <br>
 *
 * <ul>
 * <li>[F7] - If focus is on an interactive control inside an item, moves focus to the corresponding item.</li>
 * <li>[CTRL]+[A] - Selects all items, if MultiSelect mode is enabled.</li>
 * <li>[HOME]/[END] - Focuses the first/last item.</li>
 * <li>[PAGEUP]/[PAGEDOWN] - Moves focus up/down by page size (20 items by default).</li>
 * <li>[ALT]+[DOWN]/[UP] - Switches focus between header, last focused item, and More button (if applies) in either direction.</li>
 * <li>[SHIFT]+[DOWN]/[UP] - Selects the next/previous item in a MultiSelect table, if the current item is selected (Range selection). Otherwise, deselects them (Range deselection).</li>
 * <li>[SHIFT]+[HOME]/[END] - Range selection to the first/last item of the List.</li>
 * <li>[CTRL]+[HOME]/[END] - Same behavior as HOME & END.</li>
 * </ul>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/Table.js";</code>
 * <br>
 * <code>import "@ui5/webcomponents/dist/TableColumn.js";</code> (for <code>ui5-table-column</code>)
 * <br>
 * <code>import "@ui5/webcomponents/dist/TableRow.js";</code> (for <code>ui5-table-row</code>)
 * <br>
 * <code>import "@ui5/webcomponents/dist/TableCell.js";</code> (for <code>ui5-table-cell</code>)
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.Table
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-table
 * @appenddocs sap.ui.webc.main.TableColumn sap.ui.webc.main.TableRow sap.ui.webc.main.TableGroupRow sap.ui.webc.main.TableCell
 * @public
 */
declare class Table extends UI5Element {
    /**
     * Defines the text that will be displayed when there is no data and <code>hideNoData</code> is not present.
     *
     * @type {string}
     * @name sap.ui.webc.main.Table.prototype.noDataText
     * @defaultvalue ""
     * @public
     */
    noDataText: string;
    /**
     * Defines the text that will be displayed inside the growing button at the bottom of the table,
     * meant for loading more rows upon press.
     *
     * <br><br>
     * <b>Note:</b> If not specified a built-in text will be displayed.
     * <br>
     * <b>Note:</b> This property takes effect if <code>growing</code> is set to <code>Button</code>.
     *
     * @type {string}
     * @name sap.ui.webc.main.Table.prototype.growingButtonText
     * @defaultvalue ""
     * @since 1.0.0-rc.15
     * @public
     */
    growingButtonText: string;
    /**
     * Defines the subtext that will be displayed under the <code>growingButtonText</code>.
     *
     * <br><br>
     * <b>Note:</b> This property takes effect if <code>growing</code> is set to <code>Button</code>.
     *
     * @type {string}
     * @name sap.ui.webc.main.Table.prototype.growingButtonSubtext
     * @defaultvalue ""
     * @since 1.0.0-rc.15
     * @public
     */
    growingButtonSubtext: string;
    /**
     * Defines if the value of <code>noDataText</code> will be diplayed when there is no rows present in the table.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.Table.prototype.hideNoData
     * @defaultvalue false
     * @public
     * @since 1.0.0-rc.15
     */
    hideNoData: boolean;
    /**
     * Defines whether the table will have growing capability either by pressing a <code>More</code> button,
     * or via user scroll. In both cases <code>load-more</code> event is fired.
     * <br><br>
     *
     * Available options:
     * <br><br>
     * <code>Button</code> - Shows a <code>More</code> button at the bottom of the table, pressing of which triggers the <code>load-more</code> event.
     * <br>
     * <code>Scroll</code> - The <code>load-more</code> event is triggered when the user scrolls to the bottom of the table;
     * <br>
     * <code>None</code> (default) - The growing is off.
     * <br><br>
     *
     * <b>Restrictions:</b> <code>growing="Scroll"</code> is not supported for Internet Explorer,
     * and the component will fallback to <code>growing="Button"</code>.
     * @type {sap.ui.webc.main.types.TableGrowingMode}
     * @name sap.ui.webc.main.Table.prototype.growing
     * @defaultvalue "None"
     * @since 1.0.0-rc.12
     * @public
     */
    growing: `${TableGrowingMode}`;
    /**
     * Defines if the table is in busy state.
     * <b>
     *
     * In this state the component's opacity is reduced
     * and busy indicator is displayed at the bottom of the table.
     * @type {boolean}
     * @name sap.ui.webc.main.Table.prototype.busy
     * @defaultvalue false
     * @since 1.0.0-rc.12
     * @public
     */
    busy: boolean;
    /**
     * Defines the delay in milliseconds, after which the busy indicator will show up for this component.
     *
     * @type {sap.ui.webc.base.types.Integer}
     * @name sap.ui.webc.main.Table.prototype.busyDelay
     * @defaultValue 1000
     * @public
     */
    busyDelay: number;
    /**
     * Determines whether the column headers remain fixed at the top of the page during
     * vertical scrolling as long as the Web Component is in the viewport.
     * <br><br>
     * <b>Restrictions:</b>
     * <ul>
     * <li>Browsers that do not support this feature:
     * <ul>
     * <li>Internet Explorer</li>
     * <li>Microsoft Edge lower than version 41 (EdgeHTML 16)</li>
     * <li>Mozilla Firefox lower than version 59</li>
     * </ul>
     * </li>
     * <li>Scrolling behavior:
     * <ul>
     * <li>If the Web Component is placed in layout containers that have the <code>overflow: hidden</code>
     * or <code>overflow: auto</code> style definition, this can
     * prevent the sticky elements of the Web Component from becoming fixed at the top of the viewport.</li>
     * </ul>
     * </li>
     * </ul>
     *
     * @type {boolean}
     * @name sap.ui.webc.main.Table.prototype.stickyColumnHeader
     * @defaultvalue false
     * @public
     */
    stickyColumnHeader: boolean;
    /**
     * Defines the mode of the component.
     * <br><br>
     * Available options are:
     * <ul>
     * <li><code>MultiSelect</code></li>
     * <li><code>SingleSelect</code></li>
     * <li><code>None</code></li>
     * <ul>
     * @type {sap.ui.webc.main.types.TableMode}
     * @name sap.ui.webc.main.Table.prototype.mode
     * @defaultvalue "None"
     * @since 1.0.0-rc.15
     * @public
     */
    mode: `${TableMode}`;
    /**
     * Defines the accessible ARIA name of the component.
     *
     * @type {string}
     * @name sap.ui.webc.main.Table.prototype.accessibleName
     * @defaultvalue: ""
     * @public
     * @since 1.3.0
     */
    accessibleName?: string;
    /**
     * Receives id(or many ids) of the elements that label the component.
     *
     * @type {string}
     * @name sap.ui.webc.main.Table.prototype.accessibleNameRef
     * @defaultvalue ""
     * @public
     * @since 1.3.0
     */
    accessibleNameRef: string;
    _hiddenColumns: Array<TableColumnInfo>;
    _noDataDisplayed: boolean;
    /**
     * Defines the active state of the <code>More</code> button.
     * @private
     */
    _loadMoreActive: boolean;
    /**
     * Used to represent the table column header for the purpose of the item navigation as it does not work with DOM objects directly
     * @private
     */
    _columnHeader: TableColumnHeaderInfo;
    /**
     * Defines if the entire table is in view port.
     * @private
     */
    _inViewport: boolean;
    /**
     * Defines whether all rows are selected or not when table is in MultiSelect mode.
     * @type {boolean}
     * @defaultvalue false
     * @since 1.0.0-rc.15
     * @private
     */
    _allRowsSelected: boolean;
    /**
     * Defines the component rows.
     * <br><br>
     * <b>Note:</b> Use <code>ui5-table-row</code> for the intended design.
     *
     * @type {sap.ui.webc.main.ITableRow[]}
     * @name sap.ui.webc.main.Table.prototype.default
     * @slot rows
     * @public
     */
    rows: Array<ITableRow>;
    /**
     * Defines the configuration for the columns of the component.
     * <br><br>
     * <b>Note:</b> Use <code>ui5-table-column</code> for the intended design.
     *
     * @type {sap.ui.webc.main.ITableColumn[]}
     * @name sap.ui.webc.main.Table.prototype.columns
     * @slot
     * @public
     */
    columns: Array<TableColumn>;
    static onDefine(): Promise<void>;
    static i18nBundle: I18nBundle;
    fnHandleF7: (e: CustomEvent) => void;
    fnOnRowFocused: (e: CustomEvent) => void;
    _handleResize: ResizeObserverCallback;
    moreDataText?: string;
    tableEndObserved: boolean;
    visibleColumns: Array<TableColumn>;
    visibleColumnsCount?: number;
    lastFocusedElement: HTMLElement | null;
    growingIntersectionObserver?: IntersectionObserver | null;
    _forwardingFocus: boolean;
    _prevNestedElementIndex: number;
    _itemNavigation: ItemNavigation;
    _prevFocusedRow?: ITableRow;
    _afterElement?: HTMLElement;
    _beforeElement?: HTMLElement;
    constructor();
    onBeforeRendering(): void;
    onAfterRendering(): void;
    onEnterDOM(): void;
    onExitDOM(): void;
    _onkeydown(e: KeyboardEvent): void;
    _handleTab(e: KeyboardEvent): false | void;
    _focusNextElement(): void;
    _handleArrowNav(e: KeyboardEvent): void;
    _handleHomeEndSelection(e: KeyboardEvent): void;
    /**
     * Handles Alt + Up/Down.
     * Switches focus between column header, last focused item, and "More" button (if applicable).
     * @private
     * @param { KeyboardEvent } e
     */
    _handleArrowAlt(e: KeyboardEvent): void | Promise<void>;
    /**
     * Determines the type of the currently focused element.
     * @private
     * @param {object} element The DOM element
     * @returns {("columnHeader"|"tableRow"|"tableGroupRow"|"moreButton")} A string identifier
     */
    getFocusedElementType(element: HTMLElement): TableFocusTargetElement | undefined;
    /**
     * Toggles focus between the table row's root and the last focused nested element.
     * @private
     * @param { CustomEvent } e "ui5-f7-pressed"
     */
    _handleF7(e: CustomEvent<TableRowF7PressEventDetail>): void;
    _onfocusin(e: FocusEvent): void;
    _onForwardBefore(e: CustomEvent<TableRowForwardBeforeEventDetail>): void;
    _onForwardAfter(e: CustomEvent<TableRowForwardAfterEventDetail>): void;
    _focusForwardElement(isAfter: boolean): void;
    _isForwardElement(element: HTMLElement): boolean;
    _getForwardElement(isAfter: boolean): HTMLElement | null;
    _getAfterForwardElement(): HTMLElement;
    _getBeforeForwardElement(): HTMLElement;
    onRowFocused(e: CustomEvent): void;
    _onColumnHeaderFocused(): void;
    _onColumnHeaderClick(e: MouseEvent | KeyboardEvent): void;
    _onColumnHeaderKeydown(e: KeyboardEvent): void;
    _onLoadMoreKeydown(e: KeyboardEvent): void;
    _onLoadMoreKeyup(e: KeyboardEvent): void;
    _onLoadMoreClick(): void;
    observeTableEnd(): void;
    onInteresection(entries: Array<IntersectionObserverEntry>): void;
    loadMore(): void;
    _handleSingleSelect(e: CustomEvent<TableRowSelectionRequestedEventDetail>): void;
    _handleMultiSelect(e: CustomEvent<TableRowSelectionRequestedEventDetail>): void;
    _handleSelect(e: CustomEvent<TableRowSelectionRequestedEventDetail>): void;
    _selectAll(): void;
    getRowParent(child: HTMLElement): ITableRow | undefined;
    get columnHeader(): HTMLElement | null;
    get morеBtn(): HTMLElement | null;
    handleResize(): void;
    checkTableInViewport(): void;
    popinContent(): void;
    /**
     * Gets settings to be propagated from columns to rows.
     *
     * @returns { array }
     * @memberof Table
     */
    getColumnPropagationSettings(): Array<TableColumnInfo>;
    getIntersectionObserver(): IntersectionObserver;
    get styles(): {
        busy: {
            position: string;
        };
    };
    get growsWithButton(): boolean;
    get growsOnScroll(): boolean;
    get _growingButtonText(): string;
    get ariaLabelText(): string;
    get tableAriaLabelText(): string | undefined;
    get ariaLabelSelectAllText(): string;
    get loadMoreAriaLabelledBy(): string;
    get tableEndDOM(): Element;
    get busyIndPosition(): string;
    get isMultiSelect(): boolean;
    get isSingleSelect(): boolean;
    get selectedRows(): Array<ITableRow>;
    get currentItemIdx(): number;
    get currentItem(): ITableRow;
    get currentElement(): HTMLElement | undefined;
    get columnHeaderTabbables(): Array<HTMLElement>;
    get columnHeaderLastElement(): HTMLElement | null;
}
export default Table;
export type { ITableRow, TableColumnInfo, TableRowClickEventDetail, TableSelectionChangeEventDetail, TablePopinChangeEventDetail, };
