import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import type { PassiveEventListenerObject } from "@ui5/webcomponents-base/dist/types.js";
import type { ITabbable } from "@ui5/webcomponents-base/dist/delegate/ItemNavigation.js";
import type TableCell from "./TableCell.js";
import type { ITableRow, TableColumnInfo } from "./Table.js";
import TableMode from "./types/TableMode.js";
import TableRowType from "./types/TableRowType.js";
type TableRowClickEventDetail = {
    row: TableRow;
};
type TableRowSelectionRequestedEventDetail = {
    row: TableRow;
};
type TableRowForwardBeforeEventDetail = {
    target: HTMLElement;
};
type TableRowForwardAfterEventDetail = {
    target: HTMLElement;
};
type TableRowF7PressEventDetail = {
    row: TableRow;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-table-row</code> component represents a row in the <code>ui5-table</code>.
 *
 * <h3>CSS Shadow Parts</h3>
 *
 * <ui5-link target="_blank" href="https://developer.mozilla.org/en-US/docs/Web/CSS/::part">CSS Shadow Parts</ui5-link> allow developers to style elements inside the Shadow DOM.
 * <br>
 * The <code>ui5-table-row</code> exposes the following CSS Shadow Parts:
 * <ul>
 * <li>row - Used to style the native <code>tr</code> element</li>
 * <li>popin-row - Used to style the <code>tr</code> element when a row pops in</li>
 * </ul>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.TableRow
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-table-row
 * @implements sap.ui.webc.main.ITableRow
 * @public
 */
declare class TableRow extends UI5Element implements ITableRow, ITabbable {
    /**
     * Defines the visual indication and behavior of the component.
     * <br><br>
     * Available options are:
     * <ul>
     * <li><code>Active</code></li>
     * <li><code>Inactive</code></li>
     * </ul>
     * <br><br>
     * <b>Note:</b> When set to <code>Active</code>, the item will provide visual response upon press,
     * while with type <code>Inactive</code> - will not.
     *
     * @type {sap.ui.webc.main.types.TableRowType}
     * @name sap.ui.webc.main.TableRow.prototype.type
     * @defaultvalue "Inactive"
     * @since 1.0.0-rc.15
     * @public
     */
    type: `${TableRowType}`;
    /**
     * Defines the row's selected state.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.TableRow.prototype.selected
     * @defaultvalue false
     * @since 1.0.0-rc.15
     * @public
     */
    selected: boolean;
    /**
     * Indicates if the table row is navigated.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.TableRow.prototype.navigated
     * @defaultvalue false
     * @since 1.9.0
     * @public
     */
    navigated: boolean;
    /**
     * Defines the mode of the row (None, SingleSelect, MultiSelect).
     * @type {sap.ui.webc.main.types.TableMode}
     * @defaultvalue "None"
     * @since 1.0.0-rc.15
     * @private
     */
    mode: `${TableMode}`;
    /**
     * Indicates if the table row is active.
     *
     * @type {boolean}
     * @defaultvalue false
     * @since 1.0.0-rc.15
     * @private
     */
    active: boolean;
    _columnsInfo: Array<TableColumnInfo>;
    _tabIndex: string;
    _busy: boolean;
    _ariaPosition: string;
    /**
     * Defines the cells of the component.
     * <br><br>
     * <b>Note:</b> Use <code>ui5-table-cell</code> for the intended design.
     *
     * @type {sap.ui.webc.main.ITableCell[]}
     * @name sap.ui.webc.main.TableRow.prototype.default
     * @slot cells
     * @public
     */
    cells: Array<TableCell>;
    static i18nBundle: I18nBundle;
    visibleCells: Array<TableCell>;
    popinCells: Array<TableColumnInfo>;
    _ontouchstart: PassiveEventListenerObject;
    _tabbables: Array<HTMLElement>;
    _columnsInfoString: string;
    constructor();
    _onmouseup(): void;
    _onkeydown(e: KeyboardEvent): void;
    _onkeyup(e: KeyboardEvent): void;
    _ontouchend(): void;
    _onfocusout(): void;
    _onfocusin(e: FocusEvent, forceSelfFocus?: boolean): void;
    _onrowclick(e: MouseEvent): void;
    _handleSelection(): void;
    _activeElementHasAttribute(attr: string): boolean;
    get _ariaCurrent(): true | undefined;
    activate(): void;
    deactivate(): void;
    get shouldPopin(): number;
    get allColumnsPoppedIn(): boolean;
    onBeforeRendering(): void;
    get visibleCellsCount(): number;
    get ariaLabelText(): string;
    get ariaLabelRowSelection(): string;
    get isSingleSelect(): boolean;
    get isMultiSelect(): boolean;
    get root(): HTMLElement;
    getCellText(cell: TableCell): string;
    getColumnTextByIdx(index: number): string;
    getNormilzedTextContent(textContent: string): string;
    static onDefine(): Promise<void>;
}
export default TableRow;
export type { TableRowClickEventDetail, TableRowSelectionRequestedEventDetail, TableRowForwardBeforeEventDetail, TableRowForwardAfterEventDetail, TableRowF7PressEventDetail, };
