import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import ValueState from "@ui5/webcomponents-base/dist/types/ValueState.js";
import type { ResizeObserverCallback } from "@ui5/webcomponents-base/dist/delegate/ResizeHandler.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import Popover from "./Popover.js";
import "@ui5/webcomponents-icons/dist/error.js";
import "@ui5/webcomponents-icons/dist/alert.js";
import "@ui5/webcomponents-icons/dist/sys-enter-2.js";
import "@ui5/webcomponents-icons/dist/information.js";
import type FormSupportT from "./features/InputElementsFormSupport.js";
import type { IFormElement } from "./features/InputElementsFormSupport.js";
type TokenizedText = Array<string>;
type IndexedTokenizedText = Array<{
    text: string;
    last: boolean;
}>;
type ExceededText = {
    exceededText?: string;
    leftCharactersCount?: number;
    calcedMaxLength?: number;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-textarea</code> component is used to enter multiple lines of text.
 * <br><br>
 * When empty, it can hold a placeholder similar to a <code>ui5-input</code>.
 * You can define the rows of the <code>ui5-textarea</code> and also determine specific behavior when handling long texts.
 *
 * <h3>CSS Shadow Parts</h3>
 *
 * <ui5-link target="_blank" href="https://developer.mozilla.org/en-US/docs/Web/CSS/::part">CSS Shadow Parts</ui5-link> allow developers to style elements inside the Shadow DOM.
 * <br>
 * The <code>ui5-textarea</code> exposes the following CSS Shadow Parts:
 * <ul>
 * <li>textarea - Used to style the native textarea</li>
 * </ul>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/TextArea";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.TextArea
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-textarea
 * @public
 */
declare class TextArea extends UI5Element implements IFormElement {
    /**
     * Defines the value of the component.
     *
     * @type {string}
     * @name sap.ui.webc.main.TextArea.prototype.value
     * @defaultvalue ""
     * @public
         */
    value: string;
    /**
     * Indicates whether the user can interact with the component or not.
     * <br><br>
     * <b>Note:</b> A disabled component is completely noninteractive.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.TextArea.prototype.disabled
     * @defaultvalue false
     * @public
     */
    disabled: boolean;
    /**
     * Defines whether the component is read-only.
     * <br><br>
     * <b>Note:</b> A read-only component is not editable,
     * but still provides visual feedback upon user interaction.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.TextArea.prototype.readonly
     * @defaultvalue false
     * @public
     */
    readonly: boolean;
    /**
     * Defines whether the component is required.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.TextArea.prototype.required
     * @defaultvalue false
     * @public
     * @since 1.0.0-rc.3
     */
    required: boolean;
    /**
     * Defines a short hint intended to aid the user with data entry when the component has no value.
     *
     * @type {string}
     * @name sap.ui.webc.main.TextArea.prototype.placeholder
     * @defaultvalue ""
     * @public
     */
    placeholder: string;
    /**
     * Defines the value state of the component.
     * <br><br>
     * Available options are:
     * <ul>
     * <li><code>None</code></li>
     * <li><code>Error</code></li>
     * <li><code>Warning</code></li>
     * <li><code>Success</code></li>
     * <li><code>Information</code></li>
     * </ul>
     * <br><br>
     * <b>Note:</b> If <code>maxlength</code> property is set,
     * the component turns into "Warning" state once the characters exceeds the limit.
     * In this case, only the "Error" state is considered and can be applied.
     * @type {sap.ui.webc.base.types.ValueState}
     * @name sap.ui.webc.main.TextArea.prototype.valueState
     * @defaultvalue "None"
     * @since 1.0.0-rc.7
     * @public
     */
    valueState: `${ValueState}`;
    /**
     * Defines the number of visible text lines for the component.
     * <br><br>
     * <b>Notes:</b>
     * <ul>
     * <li>If the <code>growing</code> property is enabled, this property defines the minimum rows to be displayed
     * in the textarea.</li>
     * <li>The CSS <code>height</code> property wins over the <code>rows</code> property, if both are set.</li>
     * </ul>
     *
     * @type {sap.ui.webc.base.types.Integer}
     * @name sap.ui.webc.main.TextArea.prototype.rows
     * @defaultvalue 0
     * @public
     */
    rows: number;
    /**
     * Defines the maximum number of characters that the <code>value</code> can have.
     *
     * @type {sap.ui.webc.base.types.Integer}
     * @name sap.ui.webc.main.TextArea.prototype.maxlength
     * @defaultValue null
     * @public
     */
    maxlength?: number;
    /**
     * Determines whether the characters exceeding the maximum allowed character count are visible
     * in the component.
     * <br><br>
     * If set to <code>false</code>, the user is not allowed to enter more characters than what is set in the
     * <code>maxlength</code> property.
     * If set to <code>true</code> the characters exceeding the <code>maxlength</code> value are selected on
     * paste and the counter below the component displays their number.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.TextArea.prototype.showExceededText

     * @defaultvalue false
     * @public
     */
    showExceededText: boolean;
    /**
     * Enables the component to automatically grow and shrink dynamically with its content.
     * <br><br>
     * @type {boolean}
     * @name sap.ui.webc.main.TextArea.prototype.growing
     * @defaultvalue false
     * @public
     */
    growing: boolean;
    /**
     * Defines the maximum number of lines that the component can grow.
     *
     * @type {sap.ui.webc.base.types.Integer}
     * @name sap.ui.webc.main.TextArea.prototype.growingMaxLines
     * @defaultvalue 0
     * @public
     */
    growingMaxLines: number;
    /**
     * Determines the name with which the component will be submitted in an HTML form.
     *
     * <br><br>
     * <b>Important:</b> For the <code>name</code> property to have effect, you must add the following import to your project:
     * <code>import "@ui5/webcomponents/dist/features/InputElementsFormSupport.js";</code>
     *
     * <br><br>
     * <b>Note:</b> When set, a native <code>input</code> HTML element
     * will be created inside the component so that it can be submitted as
     * part of an HTML form. Do not use this property unless you need to submit a form.
     *
     * @type {string}
     * @name sap.ui.webc.main.TextArea.prototype.name
     * @defaultvalue ""
     * @public
     */
    name: string;
    /**
     * Defines the accessible ARIA name of the component.
     *
     * @type {string}
     * @name sap.ui.webc.main.TextArea.prototype.accessibleName
     * @public
     * @since 1.0.0-rc.15
     */
    accessibleName: string;
    /**
     * Receives id(or many ids) of the elements that label the textarea.
     *
     * @type {string}
     * @name sap.ui.webc.main.TextArea.prototype.accessibleNameRef
     * @defaultvalue ""
     * @public
     * @since 1.0.0-rc.15
     */
    accessibleNameRef: string;
    /**
     * @private
     */
    focused: boolean;
    /**
     * @private
     */
    exceeding: boolean;
    /**
     * @private
     */
    _mirrorText: IndexedTokenizedText;
    /**
     * @private
     */
    _maxHeight: string;
    /**
     * @private
     */
    _width?: number;
    /**
     * Defines the value state message that will be displayed as pop up under the component.
     *
     * <br><br>
     * <b>Note:</b> If not specified, a default text (in the respective language) will be displayed.
     *
     * <br><br>
     * <b>Note:</b> The <code>valueStateMessage</code> would be displayed if the component has
     * <code>valueState</code> of type <code>Information</code>, <code>Warning</code> or <code>Error</code>.
     * @type {HTMLElement[]}
     * @name sap.ui.webc.main.TextArea.prototype.valueStateMessage
     * @since 1.0.0-rc.7
     * @slot
     * @public
     */
    valueStateMessage: Array<HTMLElement>;
    /**
     * The slot is used to render native <code>input</code> HTML element within Light DOM to enable form submit,
     * when <code>name</code> property is set.
     * @type {HTMLElement[]}
     * @name sa.ui.webc.main.TextArea.prototype.formSupport
     * @slot
     * @private
     */
    formSupport: Array<HTMLElement>;
    _fnOnResize: ResizeObserverCallback;
    _firstRendering: boolean;
    _openValueStateMsgPopover: boolean;
    _exceededTextProps: ExceededText;
    _keyDown?: boolean;
    FormSupport?: typeof FormSupportT;
    previousValue: string;
    popover?: Popover;
    static i18nBundle: I18nBundle;
    static onDefine(): Promise<void>;
    constructor();
    onEnterDOM(): void;
    onExitDOM(): void;
    onBeforeRendering(): void;
    onAfterRendering(): void;
    getInputDomRef(): HTMLTextAreaElement;
    _onkeydown(e: KeyboardEvent): void;
    _onkeyup(): void;
    _onfocusin(): void;
    _onfocusout(e: FocusEvent): void;
    _onchange(): void;
    _oninput(e: InputEvent): void;
    _onResize(): void;
    _setCSSParams(): void;
    toggleValueStateMessage(toggle: boolean): void;
    openPopover(): Promise<void>;
    closePopover(): Promise<void>;
    _getPopover(): Promise<Popover>;
    _tokenizeText(value: string): {
        text: string;
        last: boolean;
    }[];
    _mapTokenizedTextToObject(tokenizedText: TokenizedText): {
        text: string;
        last: boolean;
    }[];
    _calcExceededText(): {
        exceededText: string | undefined;
        leftCharactersCount: number | undefined;
        calcedMaxLength: number | undefined;
    };
    get classes(): {
        root: {
            "ui5-textarea-root": boolean;
            "ui5-content-native-scrollbars": boolean;
        };
        valueStateMsg: {
            "ui5-valuestatemessage--error": boolean;
            "ui5-valuestatemessage--warning": boolean;
            "ui5-valuestatemessage--information": boolean;
        };
    };
    get styles(): {
        valueStateMsgPopover: {
            "max-width": string;
        };
    };
    get tabIndex(): 0 | -1;
    get ariaLabelText(): string | undefined;
    get ariaDescribedBy(): string | undefined;
    get ariaValueStateHiddenText(): string | undefined;
    get valueStateDefaultText(): string;
    get ariaInvalid(): "true" | null;
    get openValueStateMsgPopover(): boolean;
    get displayValueStateMessagePopover(): boolean;
    get hasCustomValueState(): boolean;
    get hasValueState(): boolean;
    get valueStateMessageText(): Node[];
    get _valueStatePopoverHorizontalAlign(): "Left" | "Right";
    /**
     * This method is relevant for sap_horizon theme only
     */
    get _valueStateMessageIcon(): string;
    get valueStateTextMappings(): {
        Success: string;
        Information: string;
        Error: string;
        Warning: string;
    };
    get valueStateTypeMappings(): {
        Success: string;
        Information: string;
        Error: string;
        Warning: string;
    };
}
export default TextArea;
