/// <reference types="openui5" />
import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import ValueState from "@ui5/webcomponents-base/dist/types/ValueState.js";
import "@ui5/webcomponents-localization/dist/features/calendar/Gregorian.js";
import "@ui5/webcomponents-icons/dist/time-entry-request.js";
import ResponsivePopover from "./ResponsivePopover.js";
import Input from "./Input.js";
import type { TimeSelectionChangeEventDetail } from "./TimeSelection.js";
type TimePickerBaseChangeInputEventDetail = {
    value: string;
    valid: boolean;
};
type TimePickerBaseChangeEventDetail = TimePickerBaseChangeInputEventDetail;
type TimePickerBaseInputEventDetail = TimePickerBaseChangeInputEventDetail;
/**
 * @class
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.TimePickerBase
 * @extends sap.ui.webc.base.UI5Element
 * @public
 * @since 1.0.0-rc.6
 */
declare class TimePickerBase extends UI5Element {
    /**
     * Defines a formatted time value.
     *
     * @type {string}
     * @name sap.ui.webc.main.TimePickerBase.prototype.value
     * @defaultvalue undefined
     * @formEvents change input
     * @formProperty
     * @public
     */
    value?: string;
    /**
     * Defines the value state of the <code>ui5-time-picker</code>.
     * <br><br>
     * Available options are:
     * <ul>
     * <li><code>None</code></li>
     * <li><code>Error</code></li>
     * <li><code>Warning</code></li>
     * <li><code>Success</code></li>
     * <li><code>Information</code></li>
     * </ul>
     *
     * @type {sap.ui.webc.base.types.ValueState}
     * @name sap.ui.webc.main.TimePickerBase.prototype.valueState
     * @defaultvalue "None"
     * @public
     */
    valueState: `${ValueState}`;
    /**
     * Determines whether the <code>ui5-time-picker</code> is displayed as disabled.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.TimePickerBase.prototype.disabled
     * @defaultvalue false
     * @public
     */
    disabled: boolean;
    /**
     * Determines whether the <code>ui5-time-picker</code> is displayed as readonly.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.TimePickerBase.prototype.readonly
     * @defaultvalue false
     * @public
     */
    readonly: boolean;
    _isPickerOpen: boolean;
    /**
     * Defines the value state message that will be displayed as pop up under the <code>ui5-time-picker</code>.
     * <br><br>
     *
     * <b>Note:</b> If not specified, a default text (in the respective language) will be displayed.
     * <br>
     * <b>Note:</b> The <code>valueStateMessage</code> would be displayed,
     * when the <code>ui5-time-picker</code> is in <code>Information</code>, <code>Warning</code> or <code>Error</code> value state.
     * @type {HTMLElement}
     * @name sap.ui.webc.main.TimePickerBase.prototype.valueStateMessage
     * @since 1.0.0-rc.8
     * @slot
     * @public
     */
    valueStateMessage: Array<HTMLElement>;
    tempValue?: string;
    static i18nBundle: I18nBundle;
    static onDefine(): Promise<void>;
    constructor();
    /**
     * @abstract
     * @protected
     */
    get _placeholder(): string | undefined;
    /**
     * @abstract
     * @protected
     */
    get _formatPattern(): string | undefined;
    get _effectiveValue(): string | undefined;
    get _timeSelectionValue(): string | undefined;
    onTimeSelectionChange(e: CustomEvent<TimeSelectionChangeEventDetail>): void;
    submitPickers(): void;
    onResponsivePopoverAfterClose(): void;
    _handleInputClick(): Promise<void>;
    _updateValueAndFireEvents(value: string, normalizeValue: boolean, eventsNames: Array<string>): void;
    _updateValueState(): void;
    _handleInputChange(e: CustomEvent): void;
    _handleInputLiveChange(e: CustomEvent): void;
    /**
     * Closes the picker
     * @public
     * @method
     * @name sap.ui.webc.main.TimePickerBase#closePicker
     */
    closePicker(): Promise<void>;
    /**
     * Opens the picker.
     * @async
     * @public
     * @method
     * @name sap.ui.webc.main.TimePickerBase#openPicker
     * @returns {Promise} Resolves when the picker is open
     */
    openPicker(): Promise<void>;
    togglePicker(): void;
    /**
     * Checks if the picker is open
     * @public
     * @method
     * @name sap.ui.webc.main.TimePickerBase#isOpen
     * @returns {boolean}
     */
    isOpen(): boolean;
    _canOpenPicker(): boolean;
    _getPopover(): Promise<ResponsivePopover>;
    _getInput(): Input;
    _getInputField(): Promise<HTMLInputElement | Input | null>;
    _onkeydown(e: KeyboardEvent): void;
    get _isPattern(): boolean;
    getFormat(): import("sap/ui/core/format/DateFormat").default;
    /**
     * Formats a Java Script date object into a string representing a locale date and time
     * according to the <code>formatPattern</code> property of the TimePicker instance
     * @param {Date} date A Java Script date object to be formatted as string
     * @public
     * @method
     * @name sap.ui.webc.main.TimePickerBase#formatValue
     * @returns {string}
     */
    formatValue(date: Date): string;
    /**
     * Checks if a value is valid against the current <code>formatPattern</code> value.
     *
     * <br><br>
     * <b>Note:</b> an empty string is considered as valid value.
     * @param {string} value The value to be tested against the current date format
     * @public
     * @method
     * @name sap.ui.webc.main.TimePickerBase#isValid
     * @returns {boolean}
     */
    isValid(value: string | undefined): boolean;
    normalizeValue(value: string): string;
    _modifyValueBy(amount: number, unit: string): void;
    /**
     *
     * @param {event} e Wheel Event
     * @private
     *
     * The listener for this event can't be passive as it calls preventDefault()
     */
    _handleWheel(e: WheelEvent): void;
    get submitButtonLabel(): string;
    get cancelButtonLabel(): string;
    /**
     * @protected
     */
    get openIconName(): string;
}
export default TimePickerBase;
export type { TimeSelectionChangeEventDetail, TimePickerBaseChangeEventDetail, TimePickerBaseInputEventDetail, };
