import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import ToastPlacement from "./types/ToastPlacement.js";
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-toast</code> is a small, non-disruptive popup for success or information messages that
 * disappears automatically after a few seconds.
 *
 *
 * <h3>Usage</h3>
 *
 * <h4>When to use:</h4>
 * <ul>
 * <li>You want to display a short success or information message.</li>
 * <li>You do not want to interrupt users while they are performing an action.</li>
 * <li>You want to confirm a successful action.</li>
 * </ul>
 * <h4>When not to use:</h4>
 * <ul>
 * <li>You want to display error or warning message.</li>
 * <li>You want to interrupt users while they are performing an action.</li>
 * <li>You want to make sure that users read the message before they leave the page.</li>
 * <li>You want users to be able to copy some part of the message text.</li>
 * </ul>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/Toast";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.Toast
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-toast
 * @public
 * @since 1.0.0-rc.6
 */
declare class Toast extends UI5Element {
    /**
     * Defines the duration in milliseconds for which component
     * remains on the screen before it's automatically closed.
     * <br><br>
     * <b>Note:</b> The minimum supported value is <code>500</code> ms
     * and even if a lower value is set, the duration would remain <code>500</code> ms.
     *
     * @type {sap.ui.webc.base.types.Integer}
     * @name sap.ui.webc.main.Toast.prototype.duration
     * @defaultvalue 3000
     * @public
     */
    duration: number;
    /**
     * Defines the placement of the component.
     * <br><br>
     * Available options are:
     * <ul>
     * <li><code>TopStart</code></li>
     * <li><code>TopCenter</code></li>
     * <li><code>TopEnd</code></li>
     * <li><code>MiddleStart</code></li>
     * <li><code>MiddleCenter</code></li>
     * <li><code>MiddleEnd</code></li>
     * <li><code>BottomStart</code></li>
     * <li><code>BottomCenter</code></li>
     * <li><code>BottomEnd</code></li>
     * </ul>
     *
     * @type {sap.ui.webc.main.types.ToastPlacement}
     * @name sap.ui.webc.main.Toast.prototype.placement
     * @defaultvalue "BottomCenter"
     * @public
     */
    placement: `${ToastPlacement}`;
    /**
     * Indicates whether the component is open (visible).
     * @type {boolean}
     * @private
     */
    open: boolean;
    /**
     * Indicates whether the component is hovered.
     * @type {boolean}
     * @private
     */
    hover: boolean;
    /**
     * Indicates whether the component DOM is rendered.
     * @type {boolean}
     * @private
     */
    domRendered: boolean;
    /**
     * Defines the text of the component.
     * <br><br>
     * <b>Note:</b> Although this slot accepts HTML Elements, it is strongly recommended that you only use text in order to preserve the intended design.
     *
     * @type {Node[]}
     * @slot
     * @public
     * @name sap.ui.webc.main.Toast.prototype.default
     */
    _reopen: boolean;
    constructor();
    onAfterRendering(): void;
    /**
     * Shows the component.
     * @public
     */
    show(): void;
    /**
     * If the minimum duration is lower than 500ms, we force
     * it to be 500ms, as described in the documentation.
     * @private
     * @returns {*}
     */
    get effectiveDuration(): number;
    get styles(): {
        root: {
            "transition-duration": string;
            "transition-delay": string;
            opacity: string;
            "z-index": number | undefined;
        };
    };
    _initiateOpening(): void;
    _ontransitionend(): void;
    _onmouseover(): void;
    _onmouseleave(): void;
}
export default Toast;
