import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import "@ui5/webcomponents-icons/dist/decline.js";
import "@ui5/webcomponents-icons/dist/sys-cancel.js";
import type { ITabbable } from "@ui5/webcomponents-base/dist/delegate/ItemNavigation.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
type TokenDeleteEventDetail = {
    backSpace: boolean;
    delete: boolean;
};
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * Tokens are small items of information (similar to tags) that mainly serve to visualize previously selected items.
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/Token.js";</code>
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.Token
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-token
 * @since 1.0.0-rc.9
 * @implements sap.ui.webc.main.IToken
 * @public
 */
declare class Token extends UI5Element implements ITabbable {
    /**
     * Defines the text of the token.
     *
     * @type {string}
     * @name sap.ui.webc.main.Token.prototype.text
     * @defaultvalue ""
     * @public
     */
    text: string;
    /**
     * Defines whether the component is read-only.
     * <br><br>
     * <b>Note:</b> A read-only component can not be deleted or selected,
     * but still provides visual feedback upon user interaction.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.Token.prototype.readonly
     * @defaultvalue false
     * @public
     */
    readonly: boolean;
    /**
     * Defines whether the component is selected or not.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.Token.prototype.selected
     * @defaultvalue false
     * @public
     */
    selected: boolean;
    /**
     * Set by the tokenizer when a token is in the "more" area (overflowing)
     * @type {boolean}
     * @defaultvalue false
     * @private
     */
    overflows: boolean;
    /**
     * Defines whether the component is focused or not.
     *
     * @type {boolean}
     * @defaultvalue false
     * @private
     */
    focused: boolean;
    /**
     * Defines whether the token is being deleted
     * This flag is used in the ui5-multi-combobox
     *
     * @type {boolean}
     * @defaultvalue false
     * @private
     */
    toBeDeleted: boolean;
    /**
     * Defines the tabIndex of the component.
     * @type {string}
     * @private
     */
    _tabIndex: string;
    /**
     * Defines the close icon for the token. If nothing is provided to this slot, the default close icon will be used.
     * Accepts <code>ui5-icon</code>.
     *
     * @type {sap.ui.webc.main.IIcon[]}
     * @name sap.ui.webc.main.Token.prototype.closeIcon
     * @slot closeIcon
     * @public
     * @since 1.0.0-rc.9
     */
    closeIcon: Array<HTMLElement>;
    static i18nBundle: I18nBundle;
    _handleSelect(): void;
    _focusin(): void;
    _focusout(): void;
    _mousedown(): void;
    _delete(): void;
    _keydown(e: KeyboardEvent): void;
    onBeforeRendering(): void;
    get tokenDeletableText(): string;
    get iconURI(): "sys-cancel" | "decline";
    static onDefine(): Promise<void>;
}
export default Token;
export type { TokenDeleteEventDetail };
