/**
 * Different types of AvatarSize.
 *
 * @readonly
 * @enum {string}
 * @public
 * @author SAP SE
 * @alias sap.ui.webc.main.types.AvatarSize
 */
declare enum AvatarSize {
    /**
     * component size - 2rem
     * font size - 1rem
     * @public
     * @type { XS }
     */
    XS = "XS",
    /**
     * component size - 3rem
     * font size - 1.5rem
     * @public
     * @type { S }
     */
    S = "S",
    /**
     * component size - 4rem
     * font size - 2rem
     * @public
     * @type { M }
     */
    M = "M",
    /**
     * component size - 5rem
     * font size - 2.5rem
     * @public
     * @type { L }
     */
    L = "L",
    /**
     * component size - 7rem
     * font size - 3rem
     * @public
     * @type { XL }
     */
    XL = "XL"
}
export default AvatarSize;
