import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import type { ITabbable } from "@ui5/webcomponents-base/dist/delegate/ItemNavigation.js";
import type { ResizeObserverCallback } from "@ui5/webcomponents-base/dist/delegate/ResizeHandler.js";
import AvatarSize from "./types/AvatarSize.js";
import AvatarShape from "./types/AvatarShape.js";
import AvatarColorScheme from "./types/AvatarColorScheme.js";
import "@ui5/webcomponents-icons/dist/employee.js";
import "@ui5/webcomponents-icons/dist/alert.js";
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * An image-like component that has different display options for representing images and icons
 * in different shapes and sizes, depending on the use case.
 *
 * The shape can be circular or square. There are several predefined sizes, as well as an option to
 * set a custom size.
 *
 * <br><br>
 * <h3>Keyboard Handling</h3>
 *
 * <ul>
 * <li>[SPACE, ENTER, RETURN] - Fires the <code>click</code> event if the <code>interactive</code> property is set to true.</li>
 * <li>[SHIFT] - If [SPACE] is pressed, pressing [SHIFT] releases the component without triggering the click event.</li>
 * </ul>
 * <br><br>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/Avatar.js";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.Avatar
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-avatar
 * @since 1.0.0-rc.6
 * @implements sap.ui.webc.main.IAvatar
 * @public
 */
declare class Avatar extends UI5Element implements ITabbable {
    /**
     * Defines whether the component is disabled.
     * A disabled component can't be pressed or
     * focused, and it is not in the tab chain.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.Avatar.prototype.disabled
     * @defaultvalue false
     * @public
     */
    disabled: boolean;
    /**
     * Defines if the avatar is interactive (focusable and pressable).
     * <b>Note:</b> This property won't have effect if the <code>disabled</code>
     * property is set to <code>true</code>.
     * @type {boolean}
     * @name sap.ui.webc.main.Avatar.prototype.interactive
     * @defaultValue false
     * @public
     */
    interactive: boolean;
    /**
     * Indicates if the elements is on focus
     * @private
     */
    focused: boolean;
    /**
     * Indicates if the elements is pressed
     * @private
     */
    pressed: boolean;
    /**
     * Defines the name of the UI5 Icon, that will be displayed.
     * <br>
     * <b>Note:</b> If <code>image</code> slot is provided, the property will be ignored.
     * <br>
     * <b>Note:</b> You should import the desired icon first, then use its name as "icon".
     * <br><br>
     * import "@ui5/webcomponents-icons/dist/{icon_name}.js"
     * <br>
     * <pre>&lt;ui5-avatar icon="employee"></pre>
     * <br>
     * <b>Note:</b> If no icon or an empty one is provided, by default the "employee" icon should be displayed.
     *
     * See all the available icons in the <ui5-link target="_blank" href="https://sdk.openui5.org/test-resources/sap/m/demokit/iconExplorer/webapp/index.html">Icon Explorer</ui5-link>.
     * @type {string}
     * @name sap.ui.webc.main.Avatar.prototype.icon
     * @defaultvalue ""
     * @public
     */
    icon: string;
    /**
     * Defines the name of the fallback icon, which should be displayed in the following cases:
     * <ul>
     * 	<li>If the initials are not valid (more than 3 letters, unsupported languages or empty initials).</li>
     * 	<li>If there are three initials and they do not fit in the shape (e.g. WWW for some of the sizes).</li>
     * 	<li>If the image src is wrong.</li>
     * </ul>
     *
     * <br>
     * <b>Note:</b> If not set, a default fallback icon "employee" is displayed.
     * <br>
     * <b>Note:</b> You should import the desired icon first, then use its name as "fallback-icon".
     * <br><br>
     * import "@ui5/webcomponents-icons/dist/{icon_name}.js"
     * <br>
     * <pre>&lt;ui5-avatar fallback-icon="alert"></pre>
     * <br>
     *
     * See all the available icons in the <ui5-link target="_blank" href="https://sdk.openui5.org/test-resources/sap/m/demokit/iconExplorer/webapp/index.html">Icon Explorer</ui5-link>.
     * @type {string}
     * @name sap.ui.webc.main.Avatar.prototype.fallbackIcon
     * @defaultvalue ""
     * @public
     */
    fallbackIcon: string;
    /**
     * Defines the displayed initials.
     * <br>
     * Up to three Latin letters can be displayed as initials.
     *
     * @type {string}
     * @name sap.ui.webc.main.Avatar.prototype.initials
     * @defaultvalue ""
     * @public
     */
    initials: string;
    /**
     * Defines the shape of the component.
     *
     * @type {sap.ui.webc.main.types.AvatarShape}
     * @name sap.ui.webc.main.Avatar.prototype.shape
     * @defaultvalue "Circle"
     * @public
     */
    shape: `${AvatarShape}`;
    /**
     * Defines predefined size of the component.
     *
     * @type {sap.ui.webc.main.types.AvatarSize}
     * @name sap.ui.webc.main.Avatar.prototype.size
     * @defaultvalue "S"
     * @public
     */
    size: `${AvatarSize}`;
    /**
     * @private
     */
    _size: AvatarSize;
    /**
     * Defines the background color of the desired image.
     *
     * @type {sap.ui.webc.main.types.AvatarColorScheme}
     * @name sap.ui.webc.main.Avatar.prototype.colorScheme
     * @defaultvalue "Accent6"
     * @public
     */
    colorScheme: `${AvatarColorScheme}`;
    /**
     * @private
     */
    _colorScheme: AvatarColorScheme;
    /**
     * Defines the text alternative of the component.
     * If not provided a default text alternative will be set, if present.
     *
     * @type {string}
     * @name sap.ui.webc.main.Avatar.prototype.accessibleName
     * @defaultvalue ""
     * @public
     * @since 1.0.0-rc.7
     */
    accessibleName: string;
    /**
     * Defines the aria-haspopup value of the component when <code>interactive</code> property is <code>true</code>.
     * <br><br>
     * @type String
     * @since 1.0.0-rc.15
     * @protected
     */
    ariaHaspopup: string;
    _tabIndex: string;
    _hasImage: boolean;
    /**
     * Receives the desired <code>&lt;img&gt;</code> tag
     *
     * <b>Note:</b> If you experience flickering of the provided image, you can hide the component until it is being defined with the following CSS:
     * <br /> <br />
     * <code>
     *		ui5-avatar:not(:defined) { <br />
     *			&nbsp;visibility: hidden; <br />
     *		} <br />
     * </code>
     * @type {HTMLElement}
     * @name sap.ui.webc.main.Avatar.prototype.default
     * @slot image
     * @public
     * @since 1.0.0-rc.15
     */
    image: Array<HTMLElement>;
    /**
     * Defines the optional badge that will be used for visual affordance.
     * <b>Note:</b> While the slot allows for custom badges, to achieve
     * the Fiori design, please use <code>ui5-badge</code> with <code>ui5-icon</code>
     * in the corresponding <code>icon</code> slot, without text nodes.
     * <br><br>
     * Example:
     * <br><br>
     * &lt;ui5-avatar><br>
     * &nbsp;&nbsp;&nbsp;&nbsp;&lt;ui5-badge slot="badge"><br>
     * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;ui5-icon slot="icon" name="employee">&lt;/ui5-icon><br>
     * &nbsp;&nbsp;&nbsp;&nbsp;&lt;/ui5-badge><br>
     * &lt;/ui5-avatar>
     * <br><br>
     * <ui5-avatar initials="AB" color-scheme="Accent1">
     * <ui5-badge slot="badge">
     * <ui5-icon slot="icon" name="accelerated"></ui5-icon>
     * </ui5-badge>
     * </ui5-avatar>
     *
     * @type {HTMLElement}
     * @name sap.ui.webc.main.Avatar.prototype.badge
     * @slot badge
     * @public
     * @since 1.7.0
     */
    badge: Array<HTMLElement>;
    _onclick?: (e: MouseEvent) => void;
    static i18nBundle: I18nBundle;
    _handleResizeBound: ResizeObserverCallback;
    constructor();
    static onDefine(): Promise<void>;
    get tabindex(): string;
    /**
     * Returns the effective avatar size.
     * @readonly
     * @type {string}
     * @defaultValue "S"
     * @private
     */
    get _effectiveSize(): AvatarSize;
    /**
     * Returns the effective background color.
     * @readonly
     * @type {string}
     * @defaultValue "Accent6"
     * @private
     */
    get _effectiveBackgroundColor(): string;
    get _role(): "button" | "img";
    get _ariaHasPopup(): string | undefined;
    get _fallbackIcon(): string;
    get _interactive(): boolean;
    get validInitials(): string | null;
    get accessibleNameText(): string | undefined;
    get hasImage(): boolean;
    get initialsContainer(): HTMLObjectElement | null;
    onBeforeRendering(): void;
    onAfterRendering(): Promise<void>;
    onEnterDOM(): void;
    onExitDOM(): void;
    handleResize(): void;
    _checkInitials(): void;
    _onClickHandler(e: MouseEvent): void;
    _onkeydown(e: KeyboardEvent): void;
    _onkeyup(e: KeyboardEvent): void;
    _fireClick(): void;
    _onfocusout(): void;
    _onfocusin(): void;
    _getAriaHasPopup(): string | undefined;
}
export default Avatar;
