import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type { PassiveEventListenerObject } from "@ui5/webcomponents-base/dist/types.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import type { I18nText } from "@ui5/webcomponents-base/dist/i18nBundle.js";
import type { IFormElement } from "./features/InputElementsFormSupport.js";
import ButtonDesign from "./types/ButtonDesign.js";
import ButtonType from "./types/ButtonType.js";
/**
 * @class
 *
 * <h3 class="comment-api-title">Overview</h3>
 *
 * The <code>ui5-button</code> component represents a simple push button.
 * It enables users to trigger actions by clicking or tapping the <code>ui5-button</code>, or by pressing
 * certain keyboard keys, such as Enter.
 *
 *
 * <h3>Usage</h3>
 *
 * For the <code>ui5-button</code> UI, you can define text, icon, or both. You can also specify
 * whether the text or the icon is displayed first.
 * <br><br>
 * You can choose from a set of predefined types that offer different
 * styling to correspond to the triggered action.
 * <br><br>
 * You can set the <code>ui5-button</code> as enabled or disabled. An enabled
 * <code>ui5-button</code> can be pressed by clicking or tapping it. The button changes
 * its style to provide visual feedback to the user that it is pressed or hovered over with
 * the mouse cursor. A disabled <code>ui5-button</code> appears inactive and cannot be pressed.
 *
 * <h3>CSS Shadow Parts</h3>
 *
 * <ui5-link target="_blank" href="https://developer.mozilla.org/en-US/docs/Web/CSS/::part">CSS Shadow Parts</ui5-link> allow developers to style elements inside the Shadow DOM.
 * <br>
 * The <code>ui5-button</code> exposes the following CSS Shadow Parts:
 * <ul>
 * <li>button - Used to style the native button element</li>
 * </ul>
 *
 * <h3>ES6 Module Import</h3>
 *
 * <code>import "@ui5/webcomponents/dist/Button";</code>
 *
 * @constructor
 * @author SAP SE
 * @alias sap.ui.webc.main.Button
 * @extends sap.ui.webc.base.UI5Element
 * @tagname ui5-button
 * @implements sap.ui.webc.main.IButton
 * @public
 */
declare class Button extends UI5Element implements IFormElement {
    /**
     * Defines the component design.
     *
     * @type {sap.ui.webc.main.types.ButtonDesign}
     * @name sap.ui.webc.main.Button.prototype.design
     * @defaultvalue "Default"
     * @public
     */
    design: `${ButtonDesign}`;
    /**
     * Defines whether the component is disabled.
     * A disabled component can't be pressed or
     * focused, and it is not in the tab chain.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.Button.prototype.disabled
     * @defaultvalue false
     * @public
     */
    disabled: boolean;
    /**
     * Defines the icon, displayed as graphical element within the component.
     * The SAP-icons font provides numerous options.
     * <br><br>
     * Example:
     *
     * See all the available icons within the <ui5-link target="_blank" href="https://sdk.openui5.org/test-resources/sap/m/demokit/iconExplorer/webapp/index.html">Icon Explorer</ui5-link>.
     *
     * @type {string}
     * @name sap.ui.webc.main.Button.prototype.icon
     * @defaultvalue ""
     * @public
     */
    icon: string;
    /**
     * Defines whether the icon should be displayed after the component text.
     *
     * @type {boolean}
     * @name sap.ui.webc.main.Button.prototype.iconEnd
     * @defaultvalue false
     * @public
     */
    iconEnd: boolean;
    /**
     * When set to <code>true</code>, the component will
     * automatically submit the nearest HTML form element on <code>press</code>.
     * <br><br>
     * <b>Note:</b> For the <code>submits</code> property to have effect, you must add the following import to your project:
     * <code>import "@ui5/webcomponents/dist/features/InputElementsFormSupport.js";</code>
     *
     * @type {boolean}
     * @name sap.ui.webc.main.Button.prototype.submits
     * @defaultvalue false
     * @public
     * @deprecated Set the "type" property to "Submit" to achieve the same result. The "submits" property is ignored if "type" is set to any value other than "Button".
     */
    submits: boolean;
    /**
     * Defines the tooltip of the component.
     * <br>
     * <b>Note:</b> A tooltip attribute should be provided for icon-only buttons, in order to represent their exact meaning/function.
     * @type {string}
     * @name sap.ui.webc.main.Button.prototype.tooltip
     * @defaultvalue ""
     * @public
     * @since 1.2.0
     */
    tooltip: string;
    /**
     * Defines the accessible ARIA name of the component.
     *
     * @type {string}
     * @name sap.ui.webc.main.Button.prototype.accessibleName
     * @defaultvalue undefined
     * @public
     * @since 1.0.0-rc.15
     */
    accessibleName?: string;
    /**
     * Receives id(or many ids) of the elements that label the component.
     *
     * @type {string}
     * @name sap.ui.webc.main.Button.prototype.accessibleNameRef
     * @defaultvalue ""
     * @public
     * @since 1.1.0
     */
    accessibleNameRef: string;
    /**
     * An object of strings that defines several additional accessibility attribute values
     * for customization depending on the use case.
     *
     * It supports the following fields:
     *
     * <ul>
     * 		<li><code>expanded</code>: Indicates whether the button, or another grouping element it controls, is currently expanded or collapsed. Accepts the following string values:
     *			<ul>
     *				<li><code>true</code></li>
     *				<li><code>false</code></li>
     *			</ul>
     * 		</li>
     * 		<li><code>hasPopup</code>: Indicates the availability and type of interactive popup element, such as menu or dialog, that can be triggered by the button. Accepts the following string values:
     * 			<ul>
     *				<li><code>Dialog</code></li>
     *				<li><code>Grid</code></li>
     *				<li><code>ListBox</code></li>
     *				<li><code>Menu</code></li>
     *				<li><code>Tree</code></li>
     * 			</ul>
     * 		</li>
     * 		<li><code>controls</code>: Identifies the element (or elements) whose contents or presence are controlled by the button element. Accepts a string value.</li>
     * </ul>
     * @type {object}
     * @name sap.ui.webc.main.Button.prototype.accessibilityAttributes
     * @public
     * @since 1.2.0
     */
    accessibilityAttributes: {
        expanded: "true" | "false";
        hasPopup: "Dialog" | "Grid" | "ListBox" | "Menu" | "Tree";
        controls: string;
    };
    /**
     * Defines whether the button has special form-related functionality.
     *
     * <br><br>
     * <b>Note:</b> For the <code>type</code> property to have effect, you must add the following import to your project:
     * <code>import "@ui5/webcomponents/dist/features/InputElementsFormSupport.js";</code>
     *
     * @type {sap.ui.webc.main.types.ButtonType}
     * @name sap.ui.webc.main.Button.prototype.type
     * @defaultvalue "Button"
     * @public
     * @since 1.15.0
     */
    type: `${ButtonType}`;
    /**
     * Used to switch the active state (pressed or not) of the component.
     * @private
     */
    active: boolean;
    /**
     * Defines if a content has been added to the default slot
     * @private
     */
    iconOnly: boolean;
    /**
     * Indicates if the elements is on focus
     * @private
     */
    focused: boolean;
    /**
     * Indicates if the elements has a slotted icon
     * @private
     */
    hasIcon: boolean;
    /**
     * Indicates if the element if focusable
     * @private
     */
    nonInteractive: boolean;
    /**
     * The current title of the button, either the tooltip property or the icons tooltip. The tooltip property with higher prio.
     * @private
     */
    buttonTitle?: string;
    _iconSettings: object;
    /**
     * Defines the tabIndex of the component.
     * @private
     */
    _tabIndex: string;
    /**
     * @since 1.0.0-rc.13
     * @private
     */
    _isTouch: boolean;
    /**
     * Defines the text of the component.
     * <br><br>
     * <b>Note:</b> Although this slot accepts HTML Elements, it is strongly recommended that you only use text in order to preserve the intended design.
     *
     * @type {Node[]}
     * @name sap.ui.webc.main.Button.prototype.default
     * @slot
     * @public
     */
    text: Array<Node>;
    _deactivate: () => void;
    _ontouchstart: PassiveEventListenerObject;
    static i18nBundle: I18nBundle;
    constructor();
    onEnterDOM(): void;
    onBeforeRendering(): Promise<void>;
    _onclick(e: MouseEvent): void;
    _onmousedown(e: MouseEvent): void;
    _ontouchend(e: TouchEvent): void;
    _onmouseup(e: MouseEvent): void;
    _onkeydown(e: KeyboardEvent): void;
    _onkeyup(e: KeyboardEvent): void;
    _onfocusout(): void;
    _onfocusin(e: FocusEvent): void;
    get hasButtonType(): boolean;
    get iconRole(): "" | "presentation";
    get isIconOnly(): boolean;
    static typeTextMappings(): Record<string, I18nText>;
    get buttonTypeText(): string;
    get tabIndexValue(): string;
    get showIconTooltip(): boolean;
    get ariaLabelText(): string | undefined;
    get _isSubmit(): boolean;
    get _isReset(): boolean;
    static onDefine(): Promise<void>;
}
export default Button;
