import UI5Element from "@ui5/webcomponents-base/dist/UI5Element.js";
import type I18nBundle from "@ui5/webcomponents-base/dist/i18nBundle.js";
import CalendarType from "@ui5/webcomponents-base/dist/types/CalendarType.js";
import "@ui5/webcomponents-icons/dist/slim-arrow-left.js";
import "@ui5/webcomponents-icons/dist/slim-arrow-right.js";
type SecondaryCalendarButtonTexts = {
    monthButtonText: string;
    monthButtonInfo: string;
    yearButtonText: string;
};
declare class CalendarHeader extends UI5Element {
    /**
     * Defines component's timestamp.
     * <b>Note:</b> set by the Calendar component
     * @type {sap.ui.webc.base.types.Integer}
     * @name sap.ui.webc.main.CalendarHeader.prototype.timestamp
     * @public
     */
    timestamp?: number;
    /**
     * Defines component's primary calendar type.
     * <b>Note:</b> set by the Calendar component
     * @type {sap.ui.webc.base.types.CalendarType}
     * @name sap.ui.webc.main.CalendarHeader.prototype.primaryCalendarType
     * @public
     */
    primaryCalendarType?: `${CalendarType}`;
    /**
     * Defines component's secondary calendar type.
     * <b>Note:</b> set by the Calendar component
     * @sience 1.0.0-rc.16
     * @defaultvalue undefined
     * @type {sap.ui.webc.base.types.CalendarType}
     * @name sap.ui.webc.main.CalendarHeader.prototype.secondaryCalendarType
     * @public
     */
    secondaryCalendarType?: `${CalendarType}`;
    /**
     * Stores information for month button for secondary calendar type
     * @type {object}
     * @private
    */
    buttonTextForSecondaryCalendarType: SecondaryCalendarButtonTexts;
    isNextButtonDisabled: boolean;
    isPrevButtonDisabled: boolean;
    isMonthButtonHidden: boolean;
    _monthButtonText: string;
    _yearButtonText: string;
    _yearButtonTextSecType: string;
    isYearButtonHidden: boolean;
    _prevButtonText?: string;
    _nextButtonText?: string;
    _secondMonthButtonText?: string;
    _secondYearButtonText?: string;
    static i18nBundle: I18nBundle;
    static onDefine(): Promise<void>;
    constructor();
    onBeforeRendering(): void;
    onPrevButtonClick(e: MouseEvent): void;
    onNextButtonClick(e: MouseEvent): void;
    onMonthButtonClick(e: MouseEvent): void;
    onMonthButtonKeyDown(e: KeyboardEvent): void;
    onMonthButtonKeyUp(e: KeyboardEvent): void;
    onYearButtonClick(e: MouseEvent): void;
    onYearButtonKeyDown(e: KeyboardEvent): void;
    onYearButtonKeyUp(e: KeyboardEvent): void;
    get hasSecondaryCalendarType(): boolean;
    get classes(): {
        prevButton: {
            "ui5-calheader-arrowbtn": boolean;
            "ui5-calheader-arrowbtn-disabled": boolean;
        };
        nextButton: {
            "ui5-calheader-arrowbtn": boolean;
            "ui5-calheader-arrowbtn-disabled": boolean;
        };
    };
    get accInfo(): {
        ariaLabelMonthButton: string;
    };
}
export default CalendarHeader;
